;==============================================================================

; file: "_parms.scm"

; Copyright (C) 1994-1998 by Marc Feeley, All Rights Reserved.

(include "fixnum.scm")

;------------------------------------------------------------------------------
;
; Compiler parameters module
; --------------------------

; This module contains definitions that parameterize the behavior of
; the compiler.

;------------------------------------------------------------------------------

; Specific symbols needed by the compiler.

(define quote-sym              (string->canonical-symbol "quote"))
(define quasiquote-sym         (string->canonical-symbol "quasiquote"))
(define unquote-sym            (string->canonical-symbol "unquote"))
(define unquote-splicing-sym   (string->canonical-symbol "unquote-splicing"))
(define lambda-sym             (string->canonical-symbol "lambda"))
(define if-sym                 (string->canonical-symbol "if"))
(define set!-sym               (string->canonical-symbol "set!"))
(define cond-sym               (string->canonical-symbol "cond"))
(define =>-sym                 (string->canonical-symbol "=>"))
(define else-sym               (string->canonical-symbol "else"))
(define and-sym                (string->canonical-symbol "and"))
(define or-sym                 (string->canonical-symbol "or"))
(define case-sym               (string->canonical-symbol "case"))
(define let-sym                (string->canonical-symbol "let"))
(define let*-sym               (string->canonical-symbol "let*"))
(define letrec-sym             (string->canonical-symbol "letrec"))
(define begin-sym              (string->canonical-symbol "begin"))
(define do-sym                 (string->canonical-symbol "do"))
(define define-sym             (string->canonical-symbol "define"))
(define delay-sym              (string->canonical-symbol "delay"))
(define future-sym             (string->canonical-symbol "future"))
(define **include-sym          (string->canonical-symbol "##include"))
(define **define-macro-sym     (string->canonical-symbol "##define-macro"))
(define **declare-sym          (string->canonical-symbol "##declare"))
(define **namespace-sym        (string->canonical-symbol "##namespace"))

(define not-sym                (string->canonical-symbol "not"))

(define **not-sym              (string->canonical-symbol "##not"))
(define **eq?-sym              (string->canonical-symbol "##eq?"))
(define **eqv?-sym             (string->canonical-symbol "##eqv?"))
(define **quasi-append-sym     (string->canonical-symbol "##quasi-append"))
(define **quasi-list-sym       (string->canonical-symbol "##quasi-list"))
(define **quasi-cons-sym       (string->canonical-symbol "##quasi-cons"))
(define **quasi-list->vector-sym (string->canonical-symbol "##quasi-list->vector"))
(define **make-cell-sym        (string->canonical-symbol "##make-cell"))
(define **cell-ref-sym         (string->canonical-symbol "##cell-ref"))
(define **cell-set!-sym        (string->canonical-symbol "##cell-set!"))
(define **make-promise-sym     (string->canonical-symbol "##make-promise"))

(define ieee-scheme-sym        (string->canonical-symbol "ieee-scheme"))
(define r4rs-scheme-sym        (string->canonical-symbol "r4rs-scheme"))
(define multilisp-sym          (string->canonical-symbol "multilisp"))

(define lambda-lift-sym        (string->canonical-symbol "lambda-lift"))

(define inline-sym             (string->canonical-symbol "inline"))
(define inlining-limit-sym     (string->canonical-symbol "inlining-limit"))

(define block-sym              (string->canonical-symbol "block"))
(define separate-sym           (string->canonical-symbol "separate"))

(define standard-bindings-sym  (string->canonical-symbol "standard-bindings"))
(define extended-bindings-sym  (string->canonical-symbol "extended-bindings"))

(define safe-sym               (string->canonical-symbol "safe"))

(define interrupts-enabled-sym (string->canonical-symbol "interrupts-enabled"))

(define environment-map-sym    (string->canonical-symbol "environment-map"))

(define generic-sym            (string->canonical-symbol "generic"))
(define fixnum-sym             (string->canonical-symbol "fixnum"))
(define flonum-sym             (string->canonical-symbol "flonum"))

(define c-define-type-sym      (string->canonical-symbol "c-define-type"))
(define c-declare-sym          (string->canonical-symbol "c-declare"))
(define c-initialize-sym       (string->canonical-symbol "c-initialize"))
(define c-lambda-sym           (string->canonical-symbol "c-lambda"))
(define c-define-sym           (string->canonical-symbol "c-define"))

(define void-sym               (string->canonical-symbol "void"))
(define char-sym               (string->canonical-symbol "char"))
(define signed-char-sym        (string->canonical-symbol "signed-char"))
(define unsigned-char-sym      (string->canonical-symbol "unsigned-char"))
(define latin1-sym             (string->canonical-symbol "latin1"))
(define ucs4-sym               (string->canonical-symbol "ucs4"))
(define ucs2-sym               (string->canonical-symbol "ucs2"))
(define short-sym              (string->canonical-symbol "short"))
(define unsigned-short-sym     (string->canonical-symbol "unsigned-short"))
(define int-sym                (string->canonical-symbol "int"))
(define unsigned-int-sym       (string->canonical-symbol "unsigned-int"))
(define long-sym               (string->canonical-symbol "long"))
(define unsigned-long-sym      (string->canonical-symbol "unsigned-long"))
(define float-sym              (string->canonical-symbol "float"))
(define double-sym             (string->canonical-symbol "double"))
(define struct-sym             (string->canonical-symbol "struct"))
(define union-sym              (string->canonical-symbol "union"))
(define pointer-sym            (string->canonical-symbol "pointer"))
(define function-sym           (string->canonical-symbol "function"))
(define bool-sym               (string->canonical-symbol "bool"))
(define char-string-sym        (string->canonical-symbol "char-string"))
(define ucs4-string-sym        (string->canonical-symbol "ucs4-string"))
(define ucs2-string-sym        (string->canonical-symbol "ucs2-string"))
(define utf8-string-sym        (string->canonical-symbol "utf8-string"))
(define scheme-object-sym      (string->canonical-symbol "scheme-object"))


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; Note: Module prefix and C id prefix must match the definitions
; in the "gambit.h" header file.

(define module-prefix " ") ; Identifier prefix for module names.

(define c-id-prefix "___") ; Identifier prefix for C identifiers generated by
                           ; the C-interface and the C back-end.


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; C types available to the C-interface.

(define scheme-to-c-notation
  (list
; Scheme notation   C-interface name   C notation   C allocation on Scheme->C?
;         \            /              /                                \
;          \          /              /                                  \
    (cons void-sym
          (vector "VOID"       "void"                                   #f))
    (cons char-sym
          (vector "CHAR"       "char"                                   #f))
    (cons signed-char-sym
          (vector "SCHAR"      (string-append c-id-prefix "SCHAR")      #f))
    (cons unsigned-char-sym
          (vector "UCHAR"      "unsigned char"                          #f))
    (cons latin1-sym
          (vector "LATIN1"     (string-append c-id-prefix "LATIN1")     #f))
    (cons ucs4-sym
          (vector "UCS4"       (string-append c-id-prefix "UCS4")       #f))
    (cons ucs2-sym
          (vector "UCS2"       (string-append c-id-prefix "UCS2")       #f))
    (cons short-sym
          (vector "SHORT"      "short"                                  #f))
    (cons unsigned-short-sym
          (vector "USHORT"     "unsigned short"                         #f))
    (cons int-sym
          (vector "INT"        "int"                                    #f))
    (cons unsigned-int-sym
          (vector "UINT"       "unsigned int"                           #f))
    (cons long-sym
          (vector "LONG"       "long"                                   #f))
    (cons unsigned-long-sym
          (vector "ULONG"      "unsigned long"                          #f))
    (cons float-sym
          (vector "FLOAT"      "float"                                  #f))
    (cons double-sym
          (vector "DOUBLE"     "double"                                 #f))
    (cons bool-sym
          (vector "BOOL"       (string-append c-id-prefix "BOOL")       #f))
    (cons char-string-sym
          (vector "CHARSTRING" "char*"                                  #t))
    (cons utf8-string-sym
          (vector "UTF8STRING" (string-append c-id-prefix "UTF8STRING") #t))
    (cons ucs4-string-sym
          (vector "UCS4STRING" (string-append c-id-prefix "UCS4STRING") #t))
    (cons ucs2-string-sym
          (vector "UCS2STRING" (string-append c-id-prefix "UCS2STRING") #t))
    (cons scheme-object-sym
          (vector "SCMOBJ"     (string-append c-id-prefix "WORD")       #f))))


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; For '_source.scm'.

; Filename extensions to try in order to find source files from module name.

(define scm-file-exts '(".scm" "")) ; "" means no extension


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; Version of the Gambit compiler and "gambit.h" header file.

(define compiler-version "3.0")
(define header-version 21)


;==============================================================================
