/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
/*
** clauseStack.h
*/

# ifndef clauseStack_H
# define clauseStack_H

abst_typedef struct _clauseStack
{
  int nelements;
  int nspace;
  int current;
  /*@reldef@*/ clause *elements;
} *clauseStack ;

/*@iter clauseStack_elements (sef clauseStack s, yield clause el); @*/
# define clauseStack_elements(s, m_el) \
  { int m_i; for (m_i = (s)->nelements - 1; m_i >= 0; m_i--) { clause m_el = (s)->elements[m_i]; 

# define end_clauseStack_elements }} 

extern int clauseStack_size (clauseStack p_s) /*@*/ ;
extern bool clauseStack_isEmpty (clauseStack p_s) /*@*/ ;

# define clauseStack_size(s) ((s)->nelements)   
# define clauseStack_isEmpty(s) (clauseStack_size(s) == 0)

extern /*@only@*/ clauseStack clauseStack_new (void) /*@*/ ;

extern void clauseStack_push (clauseStack p_s, clause p_el) /*@modifies p_s@*/ ;
extern void clauseStack_pop (clauseStack p_s) /*@modifies p_s@*/ ;
extern clause clauseStack_top (clauseStack p_s) /*@*/ ;

extern /*@only@*/ cstring clauseStack_unparse (clauseStack p_s) /*@*/ ;
extern void clauseStack_free (/*@only@*/ clauseStack p_s) ;
extern void clauseStack_clear (clauseStack p_s) /*@modifies p_s@*/ ;
extern void clauseStack_switchTop (clauseStack p_s, clause p_x) /*@modifies p_s@*/ ;
extern void clauseStack_removeFirst (clauseStack p_s, clause p_key)
            /*@modifies p_s@*/ ;

extern int clauseStack_controlDepth (clauseStack p_s) /*@*/ ;

/*@constant int clauseStackBASESIZE;@*/
# define clauseStackBASESIZE MIDBASESIZE

# else
# error "Multiple include"
# endif




