/* Alternative to tkwait variable */
#include <tcl.h>
#include <tk.h>
#include <caml/mlvalues.h>
#include <caml/memory.h>
#include "camltk.h"

/* Copy a Caml string to the C heap. Should deallocate with stat_free */
char *string_to_c(s)
     value s;
{
  int l = string_length(s);
  char *res = stat_alloc(l + 1);
  bcopy(String_val(s),res,l);
  res[l] = '\0';
  return res;
}

/* Forward declaration to keep the compiler happy */
static char *		WaitVariableProc _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *interp, char *name1, char *name2,
			    int flags));


static char * WaitVariableProc(clientdata, interp, name1, name2, flags)
     ClientData clientdata;
     Tcl_Interp *interp;	/* Interpreter containing variable. */
     char *name1;		/* Name of variable. */
     char *name2;		/* Second part of variable name. */
     int flags;			/* Information about what happened. */
{
  char *fullvar;

  /* Rebuild the full variable name */
  if (NULL == name2) {
    fullvar = stat_alloc (strlen(name1) + 1);
    strcpy(fullvar,name1);
  } else { 
    fullvar= stat_alloc (strlen(name1) + strlen(name2) + 3);
    strcpy(fullvar,name1);
    strcat(fullvar,"(");
    strcat(fullvar,name2);
    strcat(fullvar,")");
  }
  Tcl_UntraceVar(interp, fullvar,
		TCL_GLOBAL_ONLY|TCL_TRACE_WRITES|TCL_TRACE_UNSETS,
		WaitVariableProc, clientdata);
  stat_free(fullvar);
  callback2(handler_code,Val_int(clientdata),Val_int(0));
  return (char *)NULL;
}

/* Sets up a callback upon modification of a variable */
value camltk_trace_var(var,cbid) /* ML */
     value var;
     value cbid;
{
  /* Make a copy of var, since Tcl will modify it in place, and we
   * don't trust that much what it will do here
   */
  char *cvar = string_to_c(var);

  if (Tcl_TraceVar(cltclinterp, cvar,
		   TCL_GLOBAL_ONLY|TCL_TRACE_WRITES|TCL_TRACE_UNSETS,
		   WaitVariableProc,
		   (ClientData) (Int_val(cbid)))
		   != TCL_OK) {
    stat_free(cvar);
    tk_error(cltclinterp->result);
  };
  stat_free(cvar);
  return Val_unit;
}

