/*
  cvtmake
  Holder header file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#ifndef _HOLDER_H_
#define _HOLDER_H_

typedef class Holder *PHolder;
typedef class Entry *PEntry;

//
//	Class name : Holder
//
//	Description :
//
class Holder {
  friend class Entry;
protected:
  PEntry firstEntry;                    // Pointer to the first entry
  PEntry lastEntry;                     // Pointer to the last entry
public:
  Holder();                             // Constructor
  ~Holder();                            // Destructor
  void insert(char *s);                 // Inserts a entry

  void process(unsigned int ASMtype, unsigned int CPUtype);   // Changes the Makefile

  void loadFile(void);                  // Loads the source-file (GAS)
  void saveFile(void);                  // Saves the buffer into dest-file (GAS)

  void printAll(void);                  // Print all entries
};

#endif
