#include "xmame.h"
#include "network.h"

#ifdef MAME_NET

#define NAME_LENGTH 256
#define PORT_DATA 9000
#define PORT_SYNC 9010

int slaves; /* number of slaves registered to the master */

int init_master_socket(int socks[4], struct sockaddr_in names[4], int port)
{
	struct hostent *hp;
	char hname[NAME_LENGTH];

	gethostname(hname, 256);

	/* socket creation */
	if ((socks[0] = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	{
		fprintf(stderr, "init master : Can't initialise socket\n");
		return(OSD_NOT_OK);
	}

	/* Assign domain and port number */
	bzero((char*)&names[0], sizeof(names[0]));
	names[0].sin_family = AF_INET;
	names[0].sin_port = port;
	
	/* Assign IP address */
	if ((hp = gethostbyname(hname)) == NULL)
	{
		fprintf(stderr, "init master : gethostbyname error\n");
		return(OSD_NOT_OK);
	}
	bcopy(hp->h_addr, &(names[0].sin_addr.s_addr), hp->h_length);

	/* bind socket */
	if (bind(socks[0], (struct sockaddr *)&names[0], sizeof(names[0])) == -1)
	{
		fprintf(stderr, "init master : Bind failure.\n");
		return(OSD_NOT_OK);
	}

	return(OSD_OK);
}

int init_slave_sockets(int socks[4], struct sockaddr_in names[4], int port)
{
        struct hostent *hp;
	char hname[NAME_LENGTH];

        /* socket creation */
        if ((socks[1] = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        {
                fprintf(stderr, "init slave : Can't initialise socket\n");
                return(OSD_NOT_OK);
        }

        /* Assign domain and port number */
        bzero((char*)&names[1], sizeof(names[1]));
        names[1].sin_family = AF_INET;
        names[1].sin_port = port;

        /* Assign IP address */
        if ((hp = gethostbyname(mastername)) == NULL)
        {
                fprintf(stderr, "init slave : gethostbyname error\n");
                return(OSD_NOT_OK);
        }
        bcopy(hp->h_addr, &(names[1].sin_addr.s_addr), hp->h_length);

        gethostname(hname, 256);

        /* socket creation */
        if ((socks[0] = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        {
                fprintf(stderr, "init slave : Can't initialise socket\n");
                return(OSD_NOT_OK);
        }

        /* Assign domain and port number */
        bzero((char*)&names[0], sizeof(names[0]));
        names[0].sin_family = AF_INET;
        names[0].sin_port = port+1;

        /* Assign IP address */
        if ((hp = gethostbyname(hname)) == NULL)
        {
                fprintf(stderr, "init slave : gethostbyname error\n");
                return(OSD_NOT_OK);
        }
        bcopy(hp->h_addr, &(names[0].sin_addr.s_addr), hp->h_length);

        /* bind socket */
        if (bind(socks[0], (struct sockaddr *)&names[0], sizeof(names[0])) ==
-1)
        {
                fprintf(stderr, "init slave : Bind failure.\n");
                return(OSD_NOT_OK);
        }

	return(OSD_OK);
}

int add_slave(char *host, int socks[4], struct sockaddr_in names[4], int port)
{
        struct hostent *hp;

        /* socket creation */
        if ((socks[slaves] = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        {
                fprintf(stderr, "add slave : Can't initialise socket\n");
                return(OSD_NOT_OK);
        }

        /* Assign domain and port number */
        bzero((char*)&names[slaves], sizeof(names[slaves]));
        names[slaves].sin_family = AF_INET;
        names[slaves].sin_port = port+1;

        /* Assign IP address */
        if ((hp = gethostbyname(host)) == NULL)
        {
                fprintf(stderr, "add_slave : gethostbyname error\n");
                return(OSD_NOT_OK);
        }
        bcopy(hp->h_addr, &(names[slaves].sin_addr.s_addr), hp->h_length);

	return(OSD_OK);
}

void register_to_master(void)
{
	char hname[NAME_LENGTH];
	struct Event e;

	gethostname(hname, NAME_LENGTH);
	if (sendto(socks[1], hname, NAME_LENGTH, 0, (struct sockaddr *)&names[1], sizeof(names[1])) == -1)
	{
		fprintf(stderr, "slave registration : Can't send registration to master");
		return;
	}
	osd_receive_msg(&e, sizeof(e));
	players = e.players;
	printf("Registered as player %d\n", e.players);
}

void wait_registration(void)
{
	char hname[NAME_LENGTH]; /* slave host name */
	int lg = 0;
	int i;
	struct Event e;

	for(i=1;i<players;i++)
	{
		if (recvfrom(socks[0], hname, NAME_LENGTH, 0, NULL, &lg) == -1)
		{
			fprintf(stderr, "master registration : Can't receive registration from slaves.\n");
			return;
		}
		slaves++;
		add_slave(hname, socks, names, PORT_DATA);
		add_slave(hname, syncsocks, syncnames, PORT_SYNC);
		e.type = IDENTIFY;
		e.players = slaves+1;
		sendto(socks[slaves], &e, sizeof(e), 0, (struct sockaddr *)&names[slaves], sizeof(names[slaves]));
		printf("%s registered successfully as player %d.\n", hname, slaves+1);
	}

}

void receive_msg(void *msg, int size, int socks[4])
{
        int lg = 0;

        if (recvfrom(socks[0], msg, size, 0, NULL, &lg) == -1)
        {
        	fprintf(stderr, "Can't receive messages.\n");
                return;
        }
}

void send_msg(void *msg, int size, int socks[4], struct sockaddr_in names[4])
{
	int i;

	switch(netstate)
	{
	case MASTER:
		for(i=1;i<players;i++)
		{
			if (sendto(socks[i], msg, size, 0, (struct sockaddr *)&names[i], sizeof(names[i])) == -1)
			{
				fprintf(stderr, "Can't send message.");
				return;
			}
		}
		break;
	case SLAVE:
		if (sendto(socks[1], msg, size, 0, (struct sockaddr *)&names[1], sizeof(names[1])) == -1)
		{
			fprintf(stderr, "Can't send message.");
			return;
		}
		break;
	}
}

void osd_build_global_inputs(void *inputs, int inputsize)
{
  switch(netstate)
  {
        case MASTER:
        {
                osd_send_msg(inputs, inputsize);
                break;
        }
        case SLAVE:
        {
                osd_receive_msg(inputs, inputsize);
                break;
        }
  }
}

/*
 * master mode : send message to all slaves
 * slave mode  : send message to master
 */
int osd_send_msg(void *msg, int size)
{
  send_msg(msg, size, socks, names);
  return netstate;
}

/*
 * read message available or wait for it
 */
int osd_receive_msg(void *msg, int size)
{
  receive_msg(msg, size, socks);
  return netstate;
}

void send_synchronisation()
{
	struct Event e;

	e.type = SYNC;
	send_msg(&e, sizeof(e), syncsocks, syncnames);
}

void wait_synchronisation()
{
  struct Event e;

  do
    {
      receive_msg(&e, sizeof(e), syncsocks);
    }
  while(e.type != SYNC);
}

/*
 * Master and slaves are synchronising
 */
void osd_network_synchronise()
{
    send_synchronisation();
    wait_synchronisation();
}

/*
 * Close all opened sockets
 */
void osd_cleanup_network(void)
{
	int i;

	switch(netstate)
	{
	case MASTER:
		for(i=0;i<slaves;i++) close(socks[i]);
		for(i=0;i<slaves;i++) close(syncsocks[i]);	
		break;
	case SLAVE:
		close(socks[0]);
		close(socks[1]);
		close(syncsocks[0]);
		close(syncsocks[1]);
		break;
	}
}

/*
 * Initialise network
 * - the master opens a socket and waits for slaves
 * - the slaves register to the master
 */
void osd_net_init(void)
{
	slaves = 0;
	switch(netstate)
	{
	case MASTER:
		init_master_socket(socks, names, PORT_DATA);
		init_master_socket(syncsocks, syncnames, PORT_SYNC);
		wait_registration();
		break;
	case SLAVE:
		init_slave_sockets(socks, names, PORT_DATA);
		init_slave_sockets(syncsocks, syncnames, PORT_SYNC);
		register_to_master();
		break;
	}
}

#endif /* MAME_NET */
