.TH add_node 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
add_node - adds a disconnected node to a graph
.SH CALLING SEQUENCE
.nf
g1 = add_node(g,[xy,name])
.fi
.SH PARAMETERS
.TP 2
g
: graph list
.TP 3
xy
: optional row vector of coordinates of new node
.TP 5
name
: optional name of the added node
.TP 3
g1
: graph list of the new graph with the added node
.SH DESCRIPTION
\fVadd_node\fR adds a disconnected node to graph \fVg\fR and returns the new
graph \fVg1\fR.

The coordinates of the new node can be given as a row vector of
coordinates in \fVxy\fR. If the nodes of graph \fVg\fR have no
coordinates (elements \fVnode_x\fR and \fVnode_y\fR are \fV[]\fR), to
give \fVxy\fR has no effect. If the nodes of graph \fVg\fR have
coordinates and \fVxy\fR is not given, the new node has \fV(0,0)\fR as
coordinates.

If \fVname\fR is given, it is the name of the new node, otherwise the number
of nodes plus 1 is taken as the name of the new node.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 5 5 7 8 8 9 10 10 10 11 12 13 13 13 14 15 16 16 17 17];
he=[2 10 3 5 7 4 2 4 6 8 6 9 7 7 11 15 12 13 9 10 14 11 16 1 17 14 15];
g=make_graph('foo',1,17,ta,he);
g('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
g('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
show_graph(g);
n=g('node_number');
g1=add_node(g,[270 140]);
g1('node_color')=[ones(1,n) 11];
show_graph(g1);
.fi
.SH SEE ALSO
add_edge, delete_arcs, delete_nodes
