/************************************************************************/
/* Module : util.c					                */
/* Purpose: utility module for Mpsql              	                */
/* By     : Keith R. Davis					        */
/* Date   : 12/8/95					                */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software                    */
/*          Copyright(c) 1994, Regents of the University of California  */
/************************************************************************/

#include <string.h>		/* string lib header		        */
#include <malloc.h>             /* malloc header                        */

#include "util.h"               /* util func. header                    */

/* all routines assume null-terminated strings!                         */

/* removes whitespaces from the left, right and both sides of a string  */
/* MODIFIES the string passed in and returns the head of it             */

/************************************************************************/
/* Function: leftTrim                                                   */
/* Purpose : trims whitespace from left side of a string                */
/* Params  : s : char string to trim                                    */
/* Returns : ptr to resulting string                                    */
/* Notes   :                                                            */
/************************************************************************/

char* leftTrim(char* s)  
{
  char* s2 = s;
  int shift=0;
  int j=0;

  while (isspace(*s))
    { s++; shift++;}
  if (shift > 0)
    {
      while ( (s2[j] = s2[j+shift]) !='\0')
	j++;
    }

  return s2;
}

/************************************************************************/
/* Function: rightTrim                                                  */
/* Purpose : trims whitespace from right side of a string               */
/* Params  : s : char string to trim                                    */
/* Returns : ptr to resulting string                                    */
/* Notes   :                                                            */
/************************************************************************/

char* rightTrim(char* s)
{
  char* sEnd;
  sEnd = s+strlen(s)-1;
  while (isspace(*sEnd))
    sEnd--;
  if (sEnd < s)
    s[0]='\0';
  else
    s[sEnd-s+1]='\0';
  return s;
}

/************************************************************************/
/* Function: doubleTrim                                                 */
/* Purpose : trims whitespace from both sides of a string               */
/* Params  : s : char string to trim                                    */
/* Returns : ptr to resulting string                                    */
/* Notes   :                                                            */
/************************************************************************/

char* doubleTrim(char* s)
{
  strcpy(s,leftTrim(rightTrim(s)));
  return s;
}

/************************************************************************/
/* Function: dupstr                                                     */
/* Purpose : copies a string, while allocating space for it.            */
/*           the CALLER is responsible for freeing the space            */
/* Params  : s : char string to trim                                    */
/* Returns : ptr to resulting string                                    */
/* Notes   : returns NULL if the argument is NULL                       */
/************************************************************************/

char* dupstr(char *s)
{
  char* result;

  if (s == NULL)
    return NULL;

  result = (char*)malloc(strlen(s)+1);
  strcpy(result, s);
  return result;
}

/************************************************************************/
/* Function: reverse					                */
/* Purpose : reverses the order of a character string		        */
/* Params  : s : ptr to string to be reversed			        */
/* Returns : nothing                                                    */
/* Notes   :                             				*/
/************************************************************************/

void reverse(char *s)
{
    int	c;		/* character value		*/
    int	i;		/* loop counter		*/
    int	j;		/* loop counter		*/

    for(i=0, j = strlen(s) - 1; i < j; i++, j--)
    {
	c = s[i];
	s[i] = s[j];
	s[j] = c;
    } 	
	
}

/************************************************************************/
/* Function: itoa					                */
/* Purpose : converts a int to a char string			        */
/* Params  : n : integer to convert to string			        */		
/*	   : s : ptr to array to hold the converted int value	        */
/* Returns : ptr to the char array (s)			                */
/* Notes                                                                */
/************************************************************************/

char* itoa(int n, char *s)
{
    int	i;		/* loop counter		*/
    int	sign;		/* int sign			*/

    if((sign = n) < 0)
	n = -n;
    i = 0;

    do
    {
	s[i++] = n % 10 + '0';
    } while ((n /= 10) > 0);

    if(sign < 0)
	s[i++] = '-';
    s[i] = '\0';

    reverse(s);

    return(s);
}

