/* This file Copyright 1992 by Clifford A. Adams */
/* scanart.h
 *
 * Interface to rest of [t]rn
 */

/* return codes for sa_main */
	/* go to and enter prior newsgroup */
#define SA_PRIOR (-5)
	/* go to and enter next newsgroup */
#define SA_NEXT (-4)
	/* Fake a command (buf and art already set up) */
#define SA_FAKE (-3)
	/* error, quit out one level */
#define SA_ERR (-2)
	/* quit out one level and clean up... */
#define SA_QUIT (-1)
	/* read article pointed to by art */
#define SA_NORM 0

/* per-entry data */
typedef struct sa_entrydata {
    ART_NUM artnum;
    long subj_thread_num;
    char sa_flags;		/* status bitmap (marked, select, etc...) */
} SA_ENTRYDATA;

EXT SA_ENTRYDATA *sa_ents INIT(Null(SA_ENTRYDATA*));
EXT int sa_num_ents	INIT(0);
EXT int sa_ents_alloc	INIT(0);

EXT bool sa_initialized INIT(FALSE);	/* Have we initialized? */
EXT bool sa_never_initialized INIT(TRUE); /* Have we ever initialized? */

/* note: sa_in should be checked for returning to SA */
EXT bool sa_in INIT(FALSE);		/* Are we "in" SA? */

EXT bool sa_go INIT(FALSE);		/* go to sa.  Do not pass GO (:-) */
EXT bool sa_go_explicit INIT(FALSE);	/* want to bypass read-next-marked */

EXT bool sa_context_init INIT(FALSE);	/* has context been initialized? */

EXT bool sa_follow INIT(TRUE);		/* follow by default? */

/* used to pass an article number to read soon */
EXT ART_NUM sa_art INIT(0);

/* reimplement later */
/* select threads from TRN thread selector */
EXT bool sa_do_selthreads INIT(FALSE);

/* TRUE if read articles are eligible */
/* in scanart.h for world-visibilty */
EXT bool sa_mode_read_elig INIT(FALSE);

/* Display order variable:
 *
 * 1: Arrival order
 * 2: Descending score
 */
EXT int sa_mode_order INIT(1);
/* biggest mode# for sa_mode_order */
EXT int sa_mode_order_max INIT(2);	/* just note: dependence on SCORE */

/* common entry point: returns action code */
int	sa_main		_((void));

/* More articles arrived while reading: (inclusive) range is passed. */
void	sa_grow		_((ART_NUM, ART_NUM));

/* normal exit/cleanup procedure */
void	sa_cleanup	_((void));

/* overall initialization (in case someone else wants to pre-initialize) */
void	sa_init		_((void));
