
#include <stdio.h>
#include "jni_Item_Content.h"
#include "ling_class/EST_Stream.h"
#include "ling_class/EST_stream_aux.h"
#include "EST_play_audio.h"

static jobject streamItem_class;
static jclass string_class;
static jfieldID handle_field;

static inline short abs(short s) { return s>0?s:-s; }

JNIEXPORT jboolean JNICALL
Java_cstr_est_cpp_Item_1Content_initialise_1cpp (JNIEnv *env, jclass myclass)
{
  streamItem_class = env->NewGlobalRef(myclass);
  string_class = (jclass)env->NewGlobalRef(env->FindClass("java/lang/String"));
  handle_field = env->GetFieldID(myclass, "cpp_handle", "J");

  if (!handle_field)
    {
    printf("can't find cpp_handle!\n");
    return 0;
    }

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Item_1Content_finalise_1cpp (JNIEnv *env, jclass myclass)
{
  (void)env;
  (void)myclass;
  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Item_1Content_create_1cpp_1streamItem(JNIEnv *env, 
						      jobject self,
						      jlong handle
						      )
{
  EST_Item_Content *streamItem = (handle==0L
				 ? (new EST_Item_Content)
				 : (EST_Item_Content *)handle
				 );

  // printf("create streamItem %x\n", streamItem);

  env->SetLongField(self, handle_field, (jlong)streamItem);

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Item_1Content_destroy_1cpp_1streamItem (JNIEnv *env, jobject self)
{
  EST_Item_Content *streamItem = (EST_Item_Content *) env->GetLongField(self, handle_field);

  // printf("destroy streamItem  %x\n", streamItem);

  delete streamItem;
  return 1;
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Item_1Content_cpp_1name (JNIEnv *env, jobject self)
{
  EST_Item_Content *streamItem = (EST_Item_Content *) env->GetLongField(self, handle_field);

  return  env->NewStringUTF(streamItem->name());
}

JNIEXPORT jobjectArray JNICALL 
Java_cstr_est_cpp_Item_1Content_cpp_1featureNames (JNIEnv *env, jobject self)
{
  EST_Item_Content *item = (EST_Item_Content *) env->GetLongField(self, handle_field);
  
  int n;
  EST_Litem *p;

  n=0;
  for(p=item->f.head(); p != NULL; p=next(p))
      n++;

  jobjectArray names = env->NewObjectArray(n, string_class, NULL);

  p=item->f.head();
  for(int i=0; i<n; i++)
    {
      jstring fn = env->NewStringUTF(item->f.fname(p));
      env->SetObjectArrayElement(names, i, fn);
      p=next(p);
    }
  return names;
}


JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Item_1Content_cpp_1getS(JNIEnv *env, jobject self, jstring jname)
{
  EST_Item_Content *item = (EST_Item_Content *) env->GetLongField(self, handle_field);
  const char *name = env->GetStringUTFChars(jname, 0);
  
  EST_String val = item->f.S(name);

  env->ReleaseStringUTFChars(jname, name);
  
  return  env->NewStringUTF(val);
}

JNIEXPORT jfloat JNICALL 
Java_cstr_est_cpp_Item_1Content_cpp_1getF(JNIEnv *env, jobject self, jstring jname)
{
  EST_Item_Content *item = (EST_Item_Content *) env->GetLongField(self, handle_field);
  const char *name = env->GetStringUTFChars(jname, 0);
  
  float val = item->f.F(name);

  env->ReleaseStringUTFChars(jname, name);
  
  return  val;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Item_1Content_cpp_1featurePresent(JNIEnv *env, jobject self, jstring jname)
{
  EST_Item_Content *item = (EST_Item_Content *) env->GetLongField(self, handle_field);
  const char *name = env->GetStringUTFChars(jname, 0);
  
  int val = item->f.present(name);

  env->ReleaseStringUTFChars(jname, name);

  return  val;
}

JNIEXPORT jfloat JNICALL 
Java_cstr_est_cpp_Item_1Content_cpp_1getStartTime(JNIEnv *env, jobject self)
{
  EST_Item_Content *item = (EST_Item_Content *) env->GetLongField(self, handle_field);

  return  item?item->f.F("start"):0.0;
}

JNIEXPORT jfloat JNICALL 
Java_cstr_est_cpp_Item_1Content_cpp_1getMidTime(JNIEnv *env, jobject self)
{
  EST_Item_Content *item = (EST_Item_Content *) env->GetLongField(self, handle_field);

  return  item?item->f.F("mid"):0.0;
}

JNIEXPORT jfloat JNICALL 
Java_cstr_est_cpp_Item_1Content_cpp_1getEndTime(JNIEnv *env, jobject self)
{
  EST_Item_Content *item = (EST_Item_Content *) env->GetLongField(self, handle_field);

  return  item?item->f.F("end"):0.0;
}




