/*
 * ImageLoader.java
 *
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970807
 *
 * $Id: ImageLoader.java,v 1.1 1997/08/08 09:50:41 kwagen Exp $
 */

package iicm.vrml.vrwave;

import java.util.Hashtable;
import java.awt.image.ImageProducer;
import java.awt.image.ImageConsumer;
import java.awt.image.ColorModel;
import java.awt.Image;


/**
 * ImageLoader - load an image and provide access to
 * RGB pixel data. Provide progress feedback.
 */

public class ImageLoader implements ImageConsumer
{ 
  ImageProducer producer;
  private int w, h, current;
  private int[] pixelbuf;
  private boolean loading;
  private int flags;
  Scene scene_;

  public synchronized void loadImage (ImageProducer ip, Scene scene)
    throws InterruptedException
  {
    producer = ip;
    scene_ = scene;
    if (!loading)
    {
      loading = true;
      current = 0;
      flags &= ~(ImageConsumer.IMAGEABORTED);
      producer.startProduction(this);
    }
    while (loading)
    {
      wait (0);
    }
  }

  public synchronized boolean error ()
  {
    return (flags != ImageConsumer.STATICIMAGEDONE);
  }

  public int getWidth ()
  {
    return w;
  }

  public int getHeight ()
  {
    return h;
  }

  public int[] getPixels ()
  {
    return pixelbuf;
  }

  public void setDimensions(int width, int height)
  {
    w = width;
    h = height;
    pixelbuf = new int[w * h];
    return;
  }

  public void setHints(int hints)
  {
    return;
  }

  public void setProperties(Hashtable props)
  {
    return;
  }

  public void setColorModel(ColorModel model)
  {
    return;
  }

  public void setPixels (int srcX, int srcY, int srcW, int srcH, ColorModel model,
                         byte pixels[], int srcOff, int srcScan)
  {
    int dstPtr = srcY * w + srcX;
    int srcRem = srcScan - srcW;
    for (int h = srcH; h > 0; h--)
    {
      for (int w = srcW; w > 0; w--)
        pixelbuf[dstPtr++] = model.getRGB(pixels[srcOff++] & 0xff);
      srcOff += srcRem;
    }
    current += srcW * srcH;
    scene_.setProgress ((float) current / (float)(w * h));
  }

  public void setPixels (int srcX, int srcY, int srcW, int srcH, ColorModel model,
                         int pixels[], int srcOff, int srcScan)
  {
    int dstPtr = srcY * w + srcX;
    int srcRem = srcScan - srcW;
    for (int h = srcH; h > 0; h--)
    {
      for (int w = srcW; w > 0; w--)
        pixelbuf[dstPtr++] = model.getRGB(pixels[srcOff++]);
      srcOff += srcRem;
    }
    current += srcW * srcH;
    scene_.setProgress ((float) current / (float)(w * h));
  }

  public synchronized void imageComplete (int status)
  {
    loading = false;
    flags = status;
    producer.removeConsumer(this);
    notifyAll();
  }
} // ImageLoader
