/*
 * Copyright 1990,1991,1992 Brian Totty
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Brian Totty or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  Brian Totty and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * Brian Totty and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall Brian Totty or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	Brian Totty
 * 	Department of Computer Science
 * 	University Of Illinois at Urbana-Champaign
 *	1304 West Springfield Avenue
 * 	Urbana, IL 61801
 * 
 * 	totty@cs.uiuc.edu
 * 	
 */ 
#include <stdio.h>
#include <DirMgr.h>

int main(argc,argv)
int argc;
char **argv;
{
	DIRECTORY_MGR *dm;
	DIR_ENTRY *de;
	char *path,*pat;
	int sort_mode;

	if (argc != 3 && argc != 4)
	{
		fprintf(stderr,"usage: %s path sort_mode [pattern]\n",argv[0]);
		exit(-1);
	}
	path = argv[1];
	sort_mode = atoi(argv[2]);
	if (argc == 4)
		pat = argv[3];
	    else
		pat = NULL;
	dm = DirectoryMgrSimpleOpen(path,sort_mode,pat);
	if (dm == NULL)
	{
		fprintf(stderr,"Can't open directory mgr for '%s'\n",path);
		exit(-1);
	}
	while (1)
	{
		de = DirectoryMgrNextEntry(dm);
		if (de == NULL) break;
		DirEntryDump(stderr,de);
	}

	printf("Changing sort mode to 1\n");
	DirectoryMgrSimpleResort(dm,1);
	while (1)
	{
		de = DirectoryMgrNextEntry(dm);
		if (de == NULL) break;
		DirEntryDump(stderr,de);
	}


	DirectoryMgrClose(dm);
	return(1);
}
