/*
 * xep80_fonts.c - XEP80 Font emulation
 *
 * Copyright (C) 2007 Mark Grebe
 *
 * This file is part of the Atari800 emulator project which emulates
 * the Atari 400, 800, 800XL, 130XE, and 5200 8-bit computers.
 *
 * Atari800 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Atari800 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Atari800; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"
#ifdef XEP80_EMULATION
#include "atari.h"
#include "xep80_fonts.h"
#include <string.h>

#define NORM_FONT           0
#define REV_FONT            XEP80_FONTS_REV_FONT_BIT
#define UNDER_FONT          XEP80_FONTS_UNDER_FONT_BIT
#define REV_UNDER_FONT      (XEP80_FONTS_REV_FONT_BIT | XEP80_FONTS_UNDER_FONT_BIT)
#define BLK_FONT            XEP80_FONTS_BLK_FONT_BIT
#define REV_BLK_FONT        (XEP80_FONTS_REV_FONT_BIT | XEP80_FONTS_BLK_FONT_BIT)
#define UNDER_BLK_FONT      (XEP80_FONTS_UNDER_FONT_BIT | XEP80_FONTS_BLK_FONT_BIT)
#define REV_UNDER_BLK_FONT  (XEP80_FONTS_REV_FONT_BIT | XEP80_FONTS_UNDER_FONT_BIT | XEP80_FONTS_BLK_FONT_BIT)

#define CHAR_SET_INTERNAL   2

/* The values below define shape of the block font */
enum {
	BLOCK_FONT_MIDDLE_ROW = 3, /* Line at which middle row starts */
	BLOCK_FONT_BOTTOM_ROW = 6, /* Line at which bottom row starts */
	BLOCK_FONT_MIDDLE_COL = 2, /* Pixel at which middle column starts */
	BLOCK_FONT_RIGHT_COL = 5 /* Pixel at which right column starts */
};

int XEP80_FONTS_inited = FALSE;

/* Internal character set of the NS405 chip */
UBYTE internal_font[XEP80_FONTS_CHAR_COUNT / 2][XEP80_MAX_CHAR_HEIGHT][XEP80_CHAR_WIDTH] = {
	{{0,0,0,0,0,0,0}, /* 00 */
	 {0,0,1,0,0,1,0},
	 {0,0,1,0,0,1,0},
	 {0,0,1,0,0,1,0},
	 {0,0,1,0,0,1,0},
	 {0,0,1,0,0,1,0},
	 {0,0,1,0,1,1,0},
	 {0,1,0,1,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 01 */
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 02 */
	 {0,0,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,1,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,1,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 03 */
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,1,0,0},
	 {0,0,1,0,0,0,0},
	 {0,1,1,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 04 */
	 {0,0,0,0,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,1,0,1,0,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 05 */
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 06 */
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 07 */
	 {0,0,1,1,1,1,0},
	 {0,1,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 08 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 09 */
	 {0,0,1,1,0,1,0},
	 {0,1,0,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,0,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,0,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 0a */
	 {0,0,1,1,1,1,0},
	 {0,1,0,1,0,0,0},
	 {0,1,0,1,0,0,0},
	 {0,1,0,1,1,1,0},
	 {0,1,1,1,0,0,0},
	 {0,1,0,1,0,0,0},
	 {0,1,0,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 0b */
	 {0,0,1,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,1,0,0},
	 {0,1,1,1,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 0c */
	 {0,0,1,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 0d */
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,1,0,0},
	 {0,1,1,1,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 0e */
	 {0,0,1,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 0f */
	 {0,0,1,1,1,1,0},
	 {0,1,0,1,0,0,0},
	 {0,1,0,1,0,0,0},
	 {0,1,0,1,1,1,0},
	 {0,1,0,1,0,0,0},
	 {0,1,0,1,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 10 */
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,0,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,1,0,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 11 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 12 */
	 {0,0,1,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 13 */
	 {0,0,1,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,1,1,1,0},
	 {0,1,0,0,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 14 */
	 {0,0,1,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 15 */
	 {0,0,1,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 16 */
	 {0,0,1,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,1,1,0},
	 {0,0,1,1,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 17 */
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,1,1,1,0},
	 {0,1,0,0,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 18 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 19 */
	 {0,0,1,1,0,1,0},
	 {0,1,0,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,1,1,0,0},
	 {0,1,1,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 1a */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,1,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 1b */
	 {0,0,1,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 1c */
	 {0,0,0,0,0,0,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 1d */
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,1,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 1e */
	 {0,0,1,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,1,1,0},
	 {0,0,1,1,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 1f */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,1,1,1,0},
	 {0,1,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 20 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 21 */
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 22 */
	 {0,0,1,0,1,0,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 23 */
	 {0,0,1,0,1,0,0},
	 {0,0,1,0,1,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,1,0,1,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,1,0,1,0,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 24 */
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,1,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 25 */
	 {0,1,1,0,0,0,0},
	 {0,1,1,0,0,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,1,0,0,1,1,0},
	 {0,0,0,0,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 26 */
	 {0,0,1,0,0,0,0},
	 {0,1,0,1,0,0,0},
	 {0,1,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,0,1,0,0},
	 {0,0,1,1,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 27 */
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 28 */
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 29 */
	 {0,0,1,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 2a */
	 {0,0,0,1,0,0,0},
	 {0,1,0,1,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,1,0,1,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 2b */
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 2c */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 2d */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 2e */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 2f */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 30 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,1,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,1,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 31 */
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 32 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 33 */
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 34 */
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,1,0,0},
	 {0,0,1,0,1,0,0},
	 {0,1,0,0,1,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 35 */
	 {0,1,1,1,1,1,0},
	 {0,1,0,0,0,0,0},
	 {0,1,1,1,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 36 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 37 */
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 38 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 39 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,1,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 3a */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 3b */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 3c */
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 3d */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 3e */
	 {0,0,1,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 3f */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 40 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,1,1,1,0},
	 {0,1,0,1,1,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 41 */
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,1,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 42 */
	 {0,1,1,1,1,0,0},
	 {0,0,1,0,0,1,0},
	 {0,0,1,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,1,0,0,1,0},
	 {0,0,1,0,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 43 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 44 */
	 {0,1,1,1,1,0,0},
	 {0,0,1,0,0,1,0},
	 {0,0,1,0,0,1,0},
	 {0,0,1,0,0,1,0},
	 {0,0,1,0,0,1,0},
	 {0,0,1,0,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 45 */
	 {0,1,1,1,1,1,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 46 */
	 {0,1,1,1,1,1,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 47 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 48 */
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,1,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 49 */
	 {0,0,1,1,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 4a */
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 4b */
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,1,0,0},
	 {0,1,0,1,0,0,0},
	 {0,1,1,0,0,0,0},
	 {0,1,0,1,0,0,0},
	 {0,1,0,0,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 4c */
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 4d */
	 {0,1,0,0,0,1,0},
	 {0,1,1,0,1,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 4e */
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,0,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,0,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 4f */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 50 */
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 51 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,0,1,0,0},
	 {0,0,1,1,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 52 */
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,1,0,1,0,0,0},
	 {0,1,0,0,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 53 */
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 54 */
	 {0,1,1,1,1,1,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 55 */
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 56 */
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,0,1,0,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 57 */
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 58 */
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 59 */
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 5a */
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 5b */
	 {0,0,1,1,1,1,0},
	 {0,0,1,0,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 5c */
	 {0,0,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 5d */
	 {0,1,1,1,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,1,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 5e */
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 5f */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 60 */
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 61 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 62 */
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 63 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 64 */
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 65 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,1,1,1,0},
	 {0,1,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 66 */
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 67 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 68 */
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 69 */
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 6a */
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,1,0,0,1,0,0},
	 {0,0,1,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 6b */
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,1,0,0},
	 {0,1,0,1,0,0,0},
	 {0,1,1,0,0,0,0},
	 {0,1,0,1,0,0,0},
	 {0,1,0,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 6c */
	 {0,0,1,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 6d */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,1,0,1,0,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 6e */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,1,1,0,0},
	 {0,1,1,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 6f */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 70 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 71 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 72 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,1,1,0,0},
	 {0,1,1,0,0,1,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,1,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 73 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,1,1,1,1,0},
	 {0,1,0,0,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,1,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 74 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 75 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,1,1,0},
	 {0,0,1,1,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 76 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,0,1,0,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 77 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,1,0,1,0,1,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 78 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,1,0,0},
	 {0,1,0,0,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 79 */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,1,0,0,0,1,0},
	 {0,0,1,1,1,1,0},
	 {0,0,0,0,0,1,0},
	 {0,0,1,1,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 7a */
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,1,1,1,1,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 7b */
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,1,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 7c */
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 7d */
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,0,1,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,0,1,0,0},
	 {0,0,0,1,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 7e */
	 {0,0,1,1,0,1,0},
	 {0,1,0,0,1,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	},
	{{0,0,0,0,0,0,0}, /* 7f */
	 {0,1,0,1,0,1,0},
	 {0,0,1,0,1,0,0},
	 {0,1,0,1,0,1,0},
	 {0,0,1,0,1,0,0},
	 {0,1,0,1,0,1,0},
	 {0,0,1,0,1,0,0},
	 {0,1,0,1,0,1,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0}
	}
};

UBYTE XEP80_FONTS_atari_fonts[XEP80_FONTS_NUM_FONT_SETS][XEP80_FONTS_NUM_FONTS][XEP80_FONTS_CHAR_COUNT][XEP80_MAX_CHAR_HEIGHT][XEP80_CHAR_WIDTH];

UBYTE XEP80_FONTS_oncolor = 15;
UBYTE XEP80_FONTS_offcolor = 0;

static int InitExternalFonts(char const *charset_filename)
{
	int font_set, char_no, char_row, char_col;
	FILE *f;
	f = fopen(charset_filename, "rb");
	if (f == NULL)
		return FALSE;

	for (font_set = 0; font_set < 2; ++font_set) {
		for (char_no = 0; char_no < XEP80_FONTS_CHAR_COUNT; ++char_no) {
			UBYTE char_data[16]; /* Each character in the ROM takes 16 bytes */
			if (fread(char_data, sizeof(UBYTE), 16, f) != 16) {
				fclose(f);
				return FALSE;
			}
			for (char_row = 0; char_row < XEP80_MAX_CHAR_HEIGHT; ++char_row) {
				UBYTE row_data = char_data[char_row];
				UBYTE mask = 0x80;
				for (char_col = 0; char_col < XEP80_CHAR_WIDTH; ++char_col) {
					int pixel_lit = row_data & mask; /* If !=0, then pixel is lit */
					/* Normal font */
					XEP80_FONTS_atari_fonts[font_set][NORM_FONT][char_no][char_row][char_col] =
						pixel_lit ? XEP80_FONTS_oncolor : XEP80_FONTS_offcolor;
					/* Inverse font */
					XEP80_FONTS_atari_fonts[font_set][REV_FONT][char_no][char_row][char_col] =
						pixel_lit ? XEP80_FONTS_offcolor : XEP80_FONTS_oncolor;

					/* Normal and inverse underline fonts */
					if (char_row != XEP80_FONTS_UNDER_ROW) {
						XEP80_FONTS_atari_fonts[font_set][UNDER_FONT][char_no][char_row][char_col] =
							pixel_lit ? XEP80_FONTS_oncolor : XEP80_FONTS_offcolor;
						XEP80_FONTS_atari_fonts[font_set][REV_UNDER_FONT][char_no][char_row][char_col] =
							pixel_lit ? XEP80_FONTS_offcolor : XEP80_FONTS_oncolor;
					}
					else {
						XEP80_FONTS_atari_fonts[font_set][UNDER_FONT][char_no][char_row][char_col] =
							char_no < 128 ? XEP80_FONTS_oncolor : XEP80_FONTS_offcolor;
						XEP80_FONTS_atari_fonts[font_set][REV_UNDER_FONT][char_no][char_row][char_col] =
							char_no < 128 ? XEP80_FONTS_oncolor : XEP80_FONTS_offcolor;
					}
					mask >>= 1;
				}
			}
		}
	}
	fclose(f);
	return TRUE;
}

static void InitInternalFont(void)
{
	int char_no1, char_no2, char_row, char_col;

	for (char_no1 = 0, char_no2 = XEP80_FONTS_CHAR_COUNT / 2; char_no1 < XEP80_FONTS_CHAR_COUNT / 2; ++char_no1, ++char_no2) {
		for (char_row = 0; char_row < XEP80_MAX_CHAR_HEIGHT; ++char_row) {
			for (char_col = 0; char_col < XEP80_CHAR_WIDTH; ++char_col) {
				int pixel_lit = internal_font[char_no1][char_row][char_col]; /* If !=0, then pixel is lit */
				/* Normal font */
				XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][NORM_FONT][char_no1][char_row][char_col] =
					XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][NORM_FONT][char_no2][char_row][char_col] =
					pixel_lit ? XEP80_FONTS_oncolor : XEP80_FONTS_offcolor;
				/* Inverse font */
				XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][REV_FONT][char_no1][char_row][char_col] =
					XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][REV_FONT][char_no2][char_row][char_col] =
					pixel_lit ? XEP80_FONTS_offcolor : XEP80_FONTS_oncolor;

				/* Normal and inverse underline fonts */
				if (char_row != XEP80_FONTS_UNDER_ROW) {
					XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][UNDER_FONT][char_no1][char_row][char_col] =
						XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][UNDER_FONT][char_no2][char_row][char_col] =
						pixel_lit ? XEP80_FONTS_oncolor : XEP80_FONTS_offcolor;
					XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][REV_UNDER_FONT][char_no1][char_row][char_col] =
						XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][REV_UNDER_FONT][char_no2][char_row][char_col] =
						pixel_lit ? XEP80_FONTS_offcolor : XEP80_FONTS_oncolor;
				}
				else {
					XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][UNDER_FONT][char_no1][char_row][char_col] = XEP80_FONTS_oncolor;
					XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][UNDER_FONT][char_no2][char_row][char_col] = XEP80_FONTS_offcolor;
					XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][REV_UNDER_FONT][char_no1][char_row][char_col] = XEP80_FONTS_oncolor;
					XEP80_FONTS_atari_fonts[CHAR_SET_INTERNAL][REV_UNDER_FONT][char_no2][char_row][char_col] = XEP80_FONTS_offcolor;
				}
			}
		}
	}
}

static void SetBlockFontPixel(int char_no, int row_start, int row_end, int col_start, int col_end, int pixel_lit)
{
	int char_row, char_col;
	for (char_row = row_start; char_row < row_end; ++char_row) {
		for (char_col = col_start; char_col < col_end; ++char_col) {
			/* Block Fonts */
			XEP80_FONTS_atari_fonts[0][BLK_FONT][char_no][char_row][char_col] =
				pixel_lit ? XEP80_FONTS_oncolor : XEP80_FONTS_offcolor;
			/* Inverse Block Fonts */
			XEP80_FONTS_atari_fonts[0][REV_BLK_FONT][char_no][char_row][char_col] =
				pixel_lit ? XEP80_FONTS_offcolor : XEP80_FONTS_oncolor;
			/* Normal Underline Block Fonts */
			/* Rev Underline Block Fonts */
			if (char_row != XEP80_FONTS_UNDER_ROW) {
				XEP80_FONTS_atari_fonts[0][UNDER_BLK_FONT][char_no][char_row][char_col] =
					pixel_lit ? XEP80_FONTS_oncolor : XEP80_FONTS_offcolor;
				XEP80_FONTS_atari_fonts[0][REV_UNDER_BLK_FONT][char_no][char_row][char_col] =
					pixel_lit ? XEP80_FONTS_offcolor : XEP80_FONTS_oncolor;
			}
			else {
				XEP80_FONTS_atari_fonts[0][UNDER_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
				XEP80_FONTS_atari_fonts[0][REV_UNDER_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
			}
		}
	}
}
static void InitBlockFont(void)
{
	int char_no;

	for (char_no = 0;char_no<XEP80_FONTS_CHAR_COUNT/2;char_no++) {
		if (char_no == 0x1b) {
			SetBlockFontPixel(char_no, 0, XEP80_MAX_CHAR_HEIGHT, 0, XEP80_CHAR_WIDTH, 0);
		}
		else {
			int pixel_lit = char_no & 0x01;
			SetBlockFontPixel(char_no, 0, BLOCK_FONT_MIDDLE_ROW, 0, BLOCK_FONT_MIDDLE_COL, pixel_lit);
			SetBlockFontPixel(char_no, 0, BLOCK_FONT_MIDDLE_ROW, BLOCK_FONT_RIGHT_COL, XEP80_CHAR_WIDTH, pixel_lit);
			pixel_lit = char_no & 0x02;
			SetBlockFontPixel(char_no, 0, BLOCK_FONT_MIDDLE_ROW, BLOCK_FONT_MIDDLE_COL, BLOCK_FONT_RIGHT_COL, pixel_lit);
			pixel_lit = char_no & 0x04;
			SetBlockFontPixel(char_no, BLOCK_FONT_MIDDLE_ROW, BLOCK_FONT_BOTTOM_ROW, 0, BLOCK_FONT_MIDDLE_COL, pixel_lit);
			pixel_lit = char_no & 0x08;
			SetBlockFontPixel(char_no, BLOCK_FONT_MIDDLE_ROW, BLOCK_FONT_BOTTOM_ROW, BLOCK_FONT_MIDDLE_COL, BLOCK_FONT_RIGHT_COL, pixel_lit);
			pixel_lit = char_no & 0x10;
			SetBlockFontPixel(char_no, BLOCK_FONT_MIDDLE_ROW, BLOCK_FONT_BOTTOM_ROW, BLOCK_FONT_RIGHT_COL, XEP80_CHAR_WIDTH, pixel_lit);
			pixel_lit = char_no & 0x20;
			SetBlockFontPixel(char_no, BLOCK_FONT_BOTTOM_ROW, XEP80_MAX_CHAR_HEIGHT, 0, BLOCK_FONT_MIDDLE_COL, pixel_lit);
			SetBlockFontPixel(char_no, BLOCK_FONT_BOTTOM_ROW, XEP80_MAX_CHAR_HEIGHT, BLOCK_FONT_RIGHT_COL, XEP80_CHAR_WIDTH, pixel_lit);
			pixel_lit = char_no & 0x40;
			SetBlockFontPixel(char_no, BLOCK_FONT_BOTTOM_ROW, XEP80_MAX_CHAR_HEIGHT, BLOCK_FONT_MIDDLE_COL, BLOCK_FONT_RIGHT_COL, pixel_lit);
		}
	}
	memcpy(XEP80_FONTS_atari_fonts[0][BLK_FONT][XEP80_FONTS_CHAR_COUNT/2], XEP80_FONTS_atari_fonts[0][BLK_FONT][0],
	       XEP80_FONTS_CHAR_COUNT/2*XEP80_MAX_CHAR_HEIGHT*XEP80_CHAR_WIDTH);
	memcpy(XEP80_FONTS_atari_fonts[0][REV_BLK_FONT][XEP80_FONTS_CHAR_COUNT/2], XEP80_FONTS_atari_fonts[0][REV_BLK_FONT][0],
	       XEP80_FONTS_CHAR_COUNT/2*XEP80_MAX_CHAR_HEIGHT*XEP80_CHAR_WIDTH);
	memcpy(XEP80_FONTS_atari_fonts[0][UNDER_BLK_FONT][XEP80_FONTS_CHAR_COUNT/2], XEP80_FONTS_atari_fonts[0][UNDER_BLK_FONT][0],
	       XEP80_FONTS_CHAR_COUNT/2*XEP80_MAX_CHAR_HEIGHT*XEP80_CHAR_WIDTH);
	memcpy(XEP80_FONTS_atari_fonts[0][REV_UNDER_BLK_FONT][XEP80_FONTS_CHAR_COUNT/2], XEP80_FONTS_atari_fonts[0][REV_UNDER_BLK_FONT][0],
	       XEP80_FONTS_CHAR_COUNT/2*XEP80_MAX_CHAR_HEIGHT*XEP80_CHAR_WIDTH);
	/* Copy Block fonts to international fonts */
	memcpy(XEP80_FONTS_atari_fonts[1][4], XEP80_FONTS_atari_fonts[0][4],
	       4*XEP80_FONTS_CHAR_COUNT*XEP80_MAX_CHAR_HEIGHT*XEP80_CHAR_WIDTH);
}

int XEP80_FONTS_InitFonts(char const *charset_filename)
{

	if (!InitExternalFonts(charset_filename))
		return FALSE;
	InitInternalFont();
	InitBlockFont();

	XEP80_FONTS_inited = TRUE;
	return TRUE;
}
#endif /* XEP80 */
