/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.i18n;

import java.util.Locale;

/**
 * Used to map locale information to URI space, to find the relevant bundle.
 *
 * @author <a href="mailto:neeme@apache.org">Neeme Praks</a>
 * @version CVS $Revision: 1.6 $ $Date: 2002/01/02 19:04:56 $ $Author: neeme $
 */
public class BundleInfo {

    private String name;
    private Locale locale;
    private String ext;

    public BundleInfo() {
        this(null, null, null);
    }

    public BundleInfo(String name, Locale locale) {
        this(name, locale, null);
    }

    public BundleInfo(String name, Locale locale, String ext) {
        this.name = name;
        this.locale = locale;
        this.ext = ext;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected void setExtensionParameter(String ext) {
        this.ext = ext;
    }

    public String getName()
    {
        return this.name;
    }

    public Locale getLocale() 
    {
        return this.locale;
    }

    public String getExtensionParameter() 
    {
        return this.ext;
    }

    public String toString() 
    {
        return "BundleInfo(" + this.name + "," + this.locale + "," + this.ext + ")";
    }

    public BundleInfo getParent() 
    {
        if (this.locale != null && !this.locale.getLanguage().equals(""))
            return new BundleInfo(this.name, this.getParentLocale(), this.ext);
        else
            return null;
    }

    /**
     * Returns the next locale up the parent hierarchy.
     * E.g. the parent of new Locale("en","us","mac") would be
     * new Locale("en", "us", "").
     *
     * @param locale            the locale
     * @return                  the parent locale
     */
    protected Locale getParentLocale() 
    {
        Locale newloc;
        if (this.locale.getVariant().equals("")) 
        {
            if (this.locale.getCountry().equals(""))
                newloc = new Locale("","","");
            else
                newloc = new Locale(this.locale.getLanguage(), "", "");
        }
        else
            newloc = new Locale(this.locale.getLanguage(), this.locale.getCountry(), "");

        return newloc;
    }

}
