/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int groupHandle;
    int accelerator;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        int count = parent.getItemCount();
        if (index < 0 || index > count) {
            this.error(6);
        }
        this.createWidget(index);
    }

    void addAccelerator(int accelGroup) {
        this.updateAccelerator(accelGroup, true);
    }

    void addAccelerators(int accelGroup) {
        this.addAccelerator(accelGroup);
        if (this.menu != null) {
            this.menu.addAccelerators(accelGroup);
        }
    }

    public void addArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int index) {
        int parentHandle;
        boolean enabled;
        this.state |= 8;
        byte[] buffer = new byte[1];
        int bits = 58;
        switch (this.style & bits) {
            case 2: {
                this.handle = OS.gtk_separator_menu_item_new();
                break;
            }
            case 16: {
                this.groupHandle = OS.gtk_radio_menu_item_new((int)0);
                if (this.groupHandle == 0) {
                    this.error(2);
                }
                OS.g_object_ref((int)this.groupHandle);
                OS.gtk_object_sink((int)this.groupHandle);
                int group = OS.gtk_radio_menu_item_get_group((int)this.groupHandle);
                this.handle = OS.gtk_radio_menu_item_new_with_label((int)group, (byte[])buffer);
                break;
            }
            case 32: {
                this.handle = OS.gtk_check_menu_item_new_with_label((byte[])buffer);
                break;
            }
            default: {
                this.handle = OS.gtk_image_menu_item_new_with_label((byte[])buffer);
            }
        }
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 2) == 0) {
            int label = OS.gtk_bin_get_child((int)this.handle);
            OS.gtk_accel_label_set_accel_widget((int)label, (int)0);
        }
        if (!(enabled = OS.GTK_WIDGET_SENSITIVE((int)(parentHandle = this.parent.handle)))) {
            OS.GTK_WIDGET_SET_FLAGS((int)parentHandle, (int)512);
        }
        OS.gtk_menu_shell_insert((int)parentHandle, (int)this.handle, (int)index);
        if (!enabled) {
            OS.GTK_WIDGET_UNSET_FLAGS((int)parentHandle, (int)512);
        }
        OS.gtk_widget_show((int)this.handle);
    }

    void fixMenus(Decorations newParent) {
        if (this.menu != null) {
            this.menu.fixMenus(newParent);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    int getAccelGroup() {
        Menu menu = this.parent;
        while (menu != null && menu.cascade != null) {
            menu = menu.cascade.parent;
        }
        Decorations shell = menu.parent;
        return shell.menuBar == menu ? shell.accelGroup : 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.GTK_WIDGET_SENSITIVE((int)this.handle);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.gtk_check_menu_item_get_active((int)this.handle);
    }

    int gtk_activate(int widget) {
        if ((this.style & 0x40) != 0 && this.menu != null) {
            return 0;
        }
        if (!this.isEnabled()) {
            return 0;
        }
        Event event = new Event();
        int ptr = OS.gtk_get_current_event();
        if (ptr != 0) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove((GdkEvent)gdkEvent, (int)ptr, (int)GdkEvent.sizeof);
            switch (gdkEvent.type) {
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    int[] state = new int[1];
                    OS.gdk_event_get_state((int)ptr, (int[])state);
                    this.setInputState(event, state[0]);
                }
            }
            OS.gdk_event_free((int)ptr);
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.postEvent(13, event);
        return 0;
    }

    int gtk_select(int item) {
        this.parent.selectedItem = this;
        this.postEvent(30);
        return 0;
    }

    int gtk_show_help(int widget, int helpType) {
        boolean handled = this.hooks(28);
        if (handled) {
            this.postEvent(28);
        } else {
            handled = this.parent.sendHelpEvent(helpType);
        }
        if (handled) {
            OS.gtk_menu_shell_deactivate((int)this.parent.handle);
            return 1;
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc2 = this.display.windowProc2;
        int windowProc3 = this.display.windowProc3;
        OS.g_signal_connect((int)this.handle, (byte[])OS.activate, (int)windowProc2, (int)1);
        OS.g_signal_connect((int)this.handle, (byte[])OS.select, (int)windowProc2, (int)33);
        OS.g_signal_connect((int)this.handle, (byte[])OS.show_help, (int)windowProc3, (int)35);
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    void releaseChild() {
        super.releaseChild();
        if (this.menu != null) {
            if (this.menu.selectedItem == this) {
                this.menu.selectedItem = null;
            }
            this.menu.dispose();
        }
        this.menu = null;
    }

    void releaseWidget() {
        if (this.menu != null) {
            this.menu.releaseResources();
        }
        this.menu = null;
        super.releaseWidget();
        int accelGroup = this.getAccelGroup();
        if (accelGroup != 0) {
            this.removeAccelerator(accelGroup);
        }
        if (this.groupHandle != 0) {
            OS.g_object_unref((int)this.groupHandle);
        }
        this.groupHandle = 0;
        this.accelerator = 0;
        this.parent = null;
    }

    void removeAccelerator(int accelGroup) {
        this.updateAccelerator(accelGroup, false);
    }

    void removeAccelerators(int accelGroup) {
        this.removeAccelerator(accelGroup);
        if (this.menu != null) {
            this.menu.removeAccelerators(accelGroup);
        }
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        int index = 0;
        MenuItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        if (this.accelerator == accelerator) {
            return;
        }
        int accelGroup = this.getAccelGroup();
        if (accelGroup != 0) {
            this.removeAccelerator(accelGroup);
        }
        this.accelerator = accelerator;
        if (accelGroup != 0) {
            this.addAccelerator(accelGroup);
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (OS.GTK_WIDGET_SENSITIVE((int)this.handle) == enabled) {
            return;
        }
        int accelGroup = this.getAccelGroup();
        if (accelGroup != 0) {
            this.removeAccelerator(accelGroup);
        }
        OS.gtk_widget_set_sensitive((int)this.handle, (boolean)enabled);
        if (accelGroup != 0) {
            this.addAccelerator(accelGroup);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (!OS.GTK_IS_IMAGE_MENU_ITEM((int)this.handle)) {
            return;
        }
        if (image != null) {
            int imageHandle = OS.gtk_image_new_from_pixmap((int)image.pixmap, (int)image.mask);
            OS.gtk_image_menu_item_set_image((int)this.handle, (int)imageHandle);
            OS.gtk_widget_show((int)imageHandle);
        } else {
            OS.gtk_image_menu_item_set_image((int)this.handle, (int)0);
        }
    }

    public void setMenu(Menu menu) {
        Menu oldMenu;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((oldMenu = this.menu) == menu) {
            return;
        }
        int accelGroup = this.getAccelGroup();
        if (accelGroup != 0) {
            this.removeAccelerators(accelGroup);
        }
        if (oldMenu != null) {
            oldMenu.cascade = null;
            OS.g_object_ref((int)oldMenu.handle);
            OS.gtk_menu_item_remove_submenu((int)this.handle);
        }
        if ((this.menu = menu) != null) {
            menu.cascade = this;
            OS.gtk_menu_item_set_submenu((int)this.handle, (int)menu.handle);
        }
        if (accelGroup != 0) {
            this.addAccelerators(accelGroup);
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)1);
        OS.gtk_check_menu_item_set_active((int)this.handle, (boolean)selected);
        if ((this.style & 0x10) != 0) {
            OS.gtk_check_menu_item_set_active((int)this.groupHandle, (!selected ? 1 : 0) != 0);
        }
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)1);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        String accelString = "";
        int index = string.indexOf(9);
        if (index != -1) {
            accelString = string.substring(index, string.length());
            string = string.substring(0, index);
        }
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        int label = OS.gtk_bin_get_child((int)this.handle);
        OS.gtk_label_set_text_with_mnemonic((int)label, (byte[])buffer);
        buffer = Converter.wcsToMbcs(null, accelString, true);
        int ptr = OS.g_malloc((int)buffer.length);
        OS.memmove((int)ptr, (byte[])buffer, (int)buffer.length);
        int oldPtr = OS.GTK_ACCEL_LABEL_GET_ACCEL_STRING((int)label);
        OS.GTK_ACCEL_LABEL_SET_ACCEL_STRING((int)label, (int)ptr);
        if (oldPtr != 0) {
            OS.g_free((int)oldPtr);
        }
    }

    void updateAccelerator(int accelGroup, boolean add) {
        int keysym;
        int newKey;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return;
        }
        int mask = 0;
        if ((this.accelerator & 0x10000) != 0) {
            mask |= 8;
        }
        if ((this.accelerator & 0x20000) != 0) {
            mask |= 1;
        }
        if ((this.accelerator & 0x40000) != 0) {
            mask |= 4;
        }
        if ((newKey = Display.untranslateKey(keysym = this.accelerator & 0x100FFFF)) != 0) {
            keysym = newKey;
        } else {
            switch (keysym) {
                case 13: {
                    keysym = 65293;
                    break;
                }
                default: {
                    keysym = Display.wcsToMbcs((char)keysym);
                }
            }
        }
        if (add) {
            OS.gtk_widget_add_accelerator((int)this.handle, (byte[])OS.activate, (int)accelGroup, (int)keysym, (int)mask, (int)1);
        } else {
            OS.gtk_widget_remove_accelerator((int)this.handle, (int)accelGroup, (int)keysym, (int)mask);
        }
    }
}

