/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreLifecycleListener;
import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.update.AzureusRestarterFactory;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerFactory;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class AzureusCoreImpl
implements AzureusCore,
AzureusCoreListener {
    protected static AzureusCore singleton;
    protected static AEMonitor class_mon;
    protected GlobalManager global_manager;
    protected boolean running;
    protected List listeners = new ArrayList();
    protected List lifecycle_listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("AzureusCore");

    static {
        class_mon = new AEMonitor("AzureusCore:class");
    }

    public static AzureusCore create() throws AzureusCoreException {
        try {
            class_mon.enter();
            if (singleton != null) {
                throw new AzureusCoreException("Azureus core already instantiated");
            }
            AzureusCore azureusCore = singleton = new AzureusCoreImpl();
            class_mon.exit();
            return azureusCore;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public static AzureusCore getSingleton() throws AzureusCoreException {
        if (singleton == null) {
            throw new AzureusCoreException("core not instantiated");
        }
        return singleton;
    }

    protected AzureusCoreImpl() {
        COConfigurationManager.initialise();
        LGLogger.initialise();
        AEDiagnostics.startup();
        AETemporaryFileHandler.startup();
    }

    public LocaleUtil getLocaleUtil() {
        return LocaleUtil.getSingleton();
    }

    public void start() throws AzureusCoreException {
        try {
            this.this_mon.enter();
            if (this.running) {
                throw new AzureusCoreException("Core: already running");
            }
            this.running = true;
        }
        finally {
            this.this_mon.exit();
        }
        this.global_manager = GlobalManagerFactory.create(this);
        int i = 0;
        while (i < this.lifecycle_listeners.size()) {
            ((AzureusCoreLifecycleListener)this.lifecycle_listeners.get(i)).componentCreated(this, this.global_manager);
            ++i;
        }
        PluginInitializer.getSingleton(this, this).initializePlugins(this);
        LGLogger.log("Core: Initializing Plugins complete");
        new AEThread("Plugin Init Complete"){

            public void runSupport() {
                PluginInitializer.initialisationComplete();
                int i = 0;
                while (i < AzureusCoreImpl.this.lifecycle_listeners.size()) {
                    ((AzureusCoreLifecycleListener)AzureusCoreImpl.this.lifecycle_listeners.get(i)).started(AzureusCoreImpl.this);
                    ++i;
                }
            }
        }.start();
        Runtime.getRuntime().addShutdownHook(new AEThread("Shutdown Hook"){

            public void runSupport() {
                if (AzureusCoreImpl.this.running) {
                    try {
                        System.out.println("Core: Forced VM shutdown...auto-stopping...");
                        AzureusCoreImpl.this.stop();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        });
    }

    public void stop() throws AzureusCoreException {
        LGLogger.log("Core: Stop operation starts");
        this.stopSupport(true);
    }

    public void stopSupport(boolean apply_updates) throws AzureusCoreException {
        try {
            this.this_mon.enter();
            if (!this.running) {
                throw new AzureusCoreException("Core not running");
            }
            this.running = false;
        }
        finally {
            this.this_mon.exit();
        }
        this.global_manager.stopAll();
        int i = 0;
        while (i < this.lifecycle_listeners.size()) {
            ((AzureusCoreLifecycleListener)this.lifecycle_listeners.get(i)).stopped(this);
            ++i;
        }
        NonDaemonTaskRunner.waitUntilIdle();
        AEDiagnostics.shutdown();
        LGLogger.log("Core: Stop operation completes");
        if (apply_updates && this.getPluginManager().getDefaultPluginInterface().getUpdateManager().getInstallers().length > 0) {
            AzureusRestarterFactory.create(this).restart(true);
        }
    }

    public void requestStop() throws AzureusCoreException {
        int i = 0;
        while (i < this.lifecycle_listeners.size()) {
            if (!((AzureusCoreLifecycleListener)this.lifecycle_listeners.get(i)).stopRequested(this)) {
                LGLogger.log("Core: Request to stop the core has been denied");
                return;
            }
            ++i;
        }
        this.stop();
    }

    public void restart() throws AzureusCoreException {
        LGLogger.log("Core: Restart operation starts");
        this.checkCanRestart();
        this.stopSupport(false);
        AzureusRestarterFactory.create(this).restart(false);
    }

    public void requestRestart() throws AzureusCoreException {
        this.checkCanRestart();
        int i = 0;
        while (i < this.lifecycle_listeners.size()) {
            if (!((AzureusCoreLifecycleListener)this.lifecycle_listeners.get(i)).restartRequested(this)) {
                LGLogger.log("Core: Request to restart the core has been denied");
                return;
            }
            ++i;
        }
        this.restart();
    }

    protected void checkCanRestart() throws AzureusCoreException {
        if (this.getPluginManager().getPluginInterfaceByClass("org.gudy.azureus2.update.UpdaterPatcher") == null) {
            LGLogger.logRepeatableAlert(3, "Can't restart without the 'azupdater' plugin installed");
            throw new AzureusCoreException("Can't restart without the 'azupdater' plugin installed");
        }
    }

    public GlobalManager getGlobalManager() throws AzureusCoreException {
        if (!this.running) {
            throw new AzureusCoreException("Core not running");
        }
        return this.global_manager;
    }

    public TRHost getTrackerHost() throws AzureusCoreException {
        if (!this.running) {
            throw new AzureusCoreException("Core not running");
        }
        return TRHostFactory.getSingleton();
    }

    public PluginManagerDefaults getPluginManagerDefaults() throws AzureusCoreException {
        return PluginManager.getDefaults();
    }

    public PluginManager getPluginManager() throws AzureusCoreException {
        return PluginInitializer.getDefaultInterface().getPluginManager();
    }

    public IpFilterManager getIpFilterManager() throws AzureusCoreException {
        return IpFilterManagerFactory.getSingleton();
    }

    public void reportCurrentTask(String currentTask) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((AzureusCoreListener)this.listeners.get(i)).reportCurrentTask(currentTask);
            ++i;
        }
    }

    public void reportPercent(int percent) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((AzureusCoreListener)this.listeners.get(i)).reportPercent(percent);
            ++i;
        }
    }

    public void addLifecycleListener(AzureusCoreLifecycleListener l) {
        this.lifecycle_listeners.add(l);
    }

    public void removeLifecycleListener(AzureusCoreLifecycleListener l) {
        this.lifecycle_listeners.remove(l);
    }

    public void addListener(AzureusCoreListener l) {
        this.listeners.add(l);
    }

    public void removeListener(AzureusCoreListener l) {
        this.listeners.remove(l);
    }
}

