/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager;

import com.aelitis.azureus.core.networkmanager.BurstingSinglePeerUploader;
import com.aelitis.azureus.core.networkmanager.Connection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.PacketFillingMultiPeerUploader;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class UploadEntityController {
    private final HashMap upgraded_connections = new HashMap();
    private final AEMonitor lock = new AEMonitor("UploadEntityController:lock");
    private final PacketFillingMultiPeerUploader global_uploader;

    protected UploadEntityController(RateHandler rate_handler) {
        this.global_uploader = new PacketFillingMultiPeerUploader(rate_handler);
        NetworkManager.getSingleton().addWriteEntity(this.global_uploader);
    }

    protected void registerPeerConnection(Connection connection) {
        this.global_uploader.addPeerConnection(connection);
    }

    protected void cancelPeerConnection(Connection connection) {
        if (!this.global_uploader.removePeerConnection(connection)) {
            BurstingSinglePeerUploader upload_entity = (BurstingSinglePeerUploader)this.upgraded_connections.remove(connection);
            if (upload_entity != null) {
                NetworkManager.getSingleton().removeWriteEntity(upload_entity);
            } else {
                Debug.out("upload_entity == null");
            }
        }
    }

    protected void upgradePeerConnection(Connection connection, RateHandler handler) {
        BurstingSinglePeerUploader upload_entity = new BurstingSinglePeerUploader(connection, handler);
        try {
            this.lock.enter();
            if (!this.global_uploader.removePeerConnection(connection)) {
                Debug.out("upgradePeerConnection:: connection not found/removed !");
            }
            NetworkManager.getSingleton().addWriteEntity(upload_entity);
            this.upgraded_connections.put(connection, upload_entity);
        }
        finally {
            this.lock.exit();
        }
    }

    protected void downgradePeerConnection(Connection connection) {
        try {
            this.lock.enter();
            BurstingSinglePeerUploader upload_entity = (BurstingSinglePeerUploader)this.upgraded_connections.remove(connection);
            if (upload_entity != null) {
                NetworkManager.getSingleton().removeWriteEntity(upload_entity);
            } else {
                Debug.out("upload_entity == null");
            }
            this.global_uploader.addPeerConnection(connection);
        }
        finally {
            this.lock.exit();
        }
    }

    protected boolean isGeneralPoolWriteNeeded() {
        return this.global_uploader.hasWriteDataAvailable();
    }
}

