/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.classic;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerClientClassicImpl;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacket;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketHandler;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketHandlerException;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketHandlerFactory;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TrackerStatus {
    public static final int componentID = 2;
    public static final int evtLifeCycle = 0;
    public static final int evtFullTrace = 1;
    public static final int evtErrors = 2;
    private static final int FAULTY_SCRAPE_RETRY_INTERVAL = 600000;
    private URL tracker_url;
    private String scrapeURL = null;
    private HashMap hashes;
    private TRTrackerScraperImpl scraper;
    private boolean bSingleHashScrapes = false;
    protected AEMonitor hashes_mon = new AEMonitor("TrackerStatus:hashes");

    public TrackerStatus(TRTrackerScraperImpl _scraper, URL _tracker_url) {
        this.scraper = _scraper;
        this.tracker_url = _tracker_url;
        String trackerUrl = this.tracker_url.toString();
        this.hashes = new HashMap();
        try {
            trackerUrl = trackerUrl.replaceAll(" ", "");
            int position = trackerUrl.lastIndexOf(47);
            if (position >= 0 && trackerUrl.length() >= position + 9 && trackerUrl.substring(position + 1, position + 9).equals("announce")) {
                this.scrapeURL = String.valueOf(trackerUrl.substring(0, position + 1)) + "scrape" + trackerUrl.substring(position + 9);
            } else if (trackerUrl.toLowerCase().startsWith("udp:")) {
                this.scrapeURL = trackerUrl;
            } else if (position >= 0 && trackerUrl.lastIndexOf(46) < position) {
                this.scrapeURL = String.valueOf(trackerUrl) + (trackerUrl.endsWith("/") ? "" : "/") + "scrape";
            } else {
                LGLogger.log(2, 2, 3, "can't scrape using '" + trackerUrl + "' as it doesn't end in '/announce'");
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    protected TRTrackerScraperResponseImpl getHashData(HashWrapper hash) {
        try {
            this.hashes_mon.enter();
            TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)this.hashes.get(hash.getHash());
            this.hashes_mon.exit();
            return tRTrackerScraperResponseImpl;
        }
        catch (Throwable throwable) {
            this.hashes_mon.exit();
            throw throwable;
        }
    }

    protected TRTrackerScraperResponseImpl getHashData(byte[] hash) {
        try {
            this.hashes_mon.enter();
            TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)this.hashes.get(hash);
            this.hashes_mon.exit();
            return tRTrackerScraperResponseImpl;
        }
        catch (Throwable throwable) {
            this.hashes_mon.exit();
            throw throwable;
        }
    }

    protected void updateSingleHash(HashWrapper hash, boolean force) {
        this.updateSingleHash(hash.getHash(), force, true);
    }

    protected void updateSingleHash(byte[] hash, boolean force) {
        this.updateSingleHash(hash, force, true);
    }

    protected void updateSingleHash(byte[] hash, boolean force, boolean async) {
        TRTrackerScraperResponseImpl response;
        if (this.scrapeURL == null) {
            return;
        }
        ArrayList<TRTrackerScraperResponseImpl> responsesToUpdate = new ArrayList<TRTrackerScraperResponseImpl>();
        try {
            this.hashes_mon.enter();
            response = (TRTrackerScraperResponseImpl)this.hashes.get(hash);
            if (response == null) {
                response = this.addHash(hash);
            }
        }
        finally {
            this.hashes_mon.exit();
        }
        long lMainNextScrapeStartTime = response.getNextScrapeStartTime();
        if (!SystemTime.isErrorLast1min() && !force && lMainNextScrapeStartTime >= SystemTime.getCurrentTime()) {
            return;
        }
        response.setStatus(3, null);
        responsesToUpdate.add(response);
        if (!this.bSingleHashScrapes) {
            try {
                this.hashes_mon.enter();
                Iterator iterHashes = this.hashes.values().iterator();
                while (iterHashes.hasNext()) {
                    long lTimeDiff;
                    TRTrackerScraperResponseImpl r = (TRTrackerScraperResponseImpl)iterHashes.next();
                    if (r.getHash().equals(hash) || (lTimeDiff = Math.abs(lMainNextScrapeStartTime - r.getNextScrapeStartTime())) > 30000L || r.getStatus() == 3) continue;
                    r.setStatus(3, null);
                    responsesToUpdate.add(r);
                }
            }
            finally {
                this.hashes_mon.exit();
            }
        }
        new ThreadedScrapeRunner(responsesToUpdate, force, async);
    }

    protected void scrapeHTTP(URL reqUrl, ByteArrayOutputStream message) throws IOException {
        TRTrackerUtils.checkForBlacklistedURLs(reqUrl);
        reqUrl = TRTrackerUtils.adjustURLForHosting(reqUrl);
        reqUrl = AEProxyFactory.getAddressMapper().internalise(reqUrl);
        InputStream is = null;
        try {
            boolean gzip;
            HttpURLConnection con = null;
            if (reqUrl.getProtocol().equalsIgnoreCase("https")) {
                HttpsURLConnection ssl_con = (HttpsURLConnection)reqUrl.openConnection();
                ssl_con.setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String host, SSLSession session) {
                        return true;
                    }
                });
                con = ssl_con;
            } else {
                con = (HttpURLConnection)reqUrl.openConnection();
            }
            con.setRequestProperty("User-Agent", "Azureus 2.2.0.2");
            con.addRequestProperty("Accept-Encoding", "gzip");
            con.connect();
            is = con.getInputStream();
            String encoding = con.getHeaderField("content-encoding");
            boolean bl = gzip = encoding != null && encoding.equalsIgnoreCase("gzip");
            if (gzip) {
                is = new GZIPInputStream(is);
            }
            byte[] data = new byte[1024];
            int nbRead = 0;
            while (nbRead >= 0) {
                try {
                    nbRead = is.read(data);
                    if (nbRead >= 0) {
                        message.write(data, 0, nbRead);
                    }
                    Thread.sleep(20L);
                }
                catch (Exception e) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void scrapeUDP(URL reqUrl, ByteArrayOutputStream message, byte[] hash) throws Exception {
        if (PRUDPPacket.VERSION == 2 && this.scraper.isTorrentDownloading(hash)) {
            LGLogger.log(2, 0, 2, "Scrape of " + reqUrl + " skipped as torrent running and therefore scrape data available in announce replies");
            return;
        }
        reqUrl = TRTrackerUtils.adjustURLForHosting(reqUrl);
        PasswordAuthentication auth = null;
        boolean auth_ok = false;
        try {
            if (reqUrl.getQuery().toLowerCase().indexOf("auth") != -1) {
                auth = SESecurityManager.getPasswordAuthentication("UDP Tracker", reqUrl);
            }
            int port = COConfigurationManager.getIntParameter("TCP.Listen.Port", 6881);
            PRUDPPacketHandler handler = PRUDPPacketHandlerFactory.getHandler(port);
            InetSocketAddress destination = new InetSocketAddress(reqUrl.getHost(), reqUrl.getPort() == -1 ? 80 : reqUrl.getPort());
            String failure_reason = null;
            int retry_loop = 0;
            while (retry_loop < 1) {
                try {
                    PRUDPPacketRequestConnect connect_request = new PRUDPPacketRequestConnect();
                    PRUDPPacket reply = handler.sendAndReceive(auth, connect_request, destination);
                    if (reply.getAction() == 0) {
                        PRUDPPacketReplyConnect connect_reply = (PRUDPPacketReplyConnect)reply;
                        long my_connection = connect_reply.getConnectionId();
                        PRUDPPacketRequestScrape scrape_request = new PRUDPPacketRequestScrape(my_connection, hash);
                        if ((reply = handler.sendAndReceive(auth, scrape_request, destination)).getAction() == 2) {
                            auth_ok = true;
                            if (PRUDPPacket.VERSION == 1) {
                                PRUDPPacketReplyScrape scrape_reply = (PRUDPPacketReplyScrape)reply;
                                HashMap<String, ByteEncodedKeyHashMap> map = new HashMap<String, ByteEncodedKeyHashMap>();
                                byte[][] hashes = scrape_reply.getHashes();
                                int[] complete = scrape_reply.getComplete();
                                int[] downloaded = scrape_reply.getDownloaded();
                                int[] incomplete = scrape_reply.getIncomplete();
                                ByteEncodedKeyHashMap files = new ByteEncodedKeyHashMap();
                                map.put("files", files);
                                int i = 0;
                                while (i < hashes.length) {
                                    HashMap<String, Long> file = new HashMap<String, Long>();
                                    byte[] resp_hash = hashes[i];
                                    files.put(new String(resp_hash, "ISO-8859-1"), file);
                                    file.put("complete", new Long(complete[i]));
                                    file.put("downloaded", new Long(downloaded[i]));
                                    file.put("incomplete", new Long(incomplete[i]));
                                    ++i;
                                }
                                byte[] data = BEncoder.encode(map);
                                message.write(data);
                                if (auth != null) {
                                    SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerClientClassicImpl.UDP_REALM, reqUrl, auth_ok);
                                }
                                return;
                            }
                            PRUDPPacketReplyScrape2 scrape_reply = (PRUDPPacketReplyScrape2)reply;
                            HashMap<String, ByteEncodedKeyHashMap> map = new HashMap<String, ByteEncodedKeyHashMap>();
                            int[] complete = scrape_reply.getComplete();
                            int[] downloaded = scrape_reply.getDownloaded();
                            int[] incomplete = scrape_reply.getIncomplete();
                            ByteEncodedKeyHashMap files = new ByteEncodedKeyHashMap();
                            map.put("files", files);
                            HashMap<String, Long> file = new HashMap<String, Long>();
                            byte[] resp_hash = hash;
                            files.put(new String(resp_hash, "ISO-8859-1"), file);
                            file.put("complete", new Long(complete[0]));
                            file.put("downloaded", new Long(downloaded[0]));
                            file.put("incomplete", new Long(incomplete[0]));
                            byte[] data = BEncoder.encode(map);
                            message.write(data);
                            if (auth != null) {
                                SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerClientClassicImpl.UDP_REALM, reqUrl, auth_ok);
                            }
                            return;
                        }
                        failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                        LGLogger.log(2, 2, 3, "Response from scrape interface : " + failure_reason);
                        break;
                    }
                    failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                    LGLogger.log(2, 2, 3, "Response from scrape interface : " + ((PRUDPPacketReplyError)reply).getMessage());
                    break;
                }
                catch (PRUDPPacketHandlerException e) {
                    if (e.getMessage() == null || e.getMessage().indexOf("timed out") == -1) {
                        throw e;
                    }
                    failure_reason = "Timeout";
                    ++retry_loop;
                }
            }
            if (failure_reason != null) {
                HashMap<String, byte[]> map = new HashMap<String, byte[]>();
                map.put("failure reason", failure_reason.getBytes());
                byte[] data = BEncoder.encode(map);
                message.write(data);
            }
        }
        finally {
            if (auth != null) {
                SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerClientClassicImpl.UDP_REALM, reqUrl, auth_ok);
            }
        }
    }

    protected String getURLParam(String url, String param) {
        int p1 = url.indexOf(String.valueOf(param) + "=");
        if (p1 == -1) {
            return null;
        }
        int p2 = url.indexOf("&", p1);
        if (p2 == -1) {
            return url.substring(p1 + param.length() + 1);
        }
        return url.substring(p1 + param.length() + 1, p2);
    }

    protected TRTrackerScraperResponseImpl addHash(byte[] hash) {
        TRTrackerScraperResponseImpl response = new TRTrackerScraperResponseImpl(this, hash);
        if (this.scrapeURL == null) {
            response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.badURL"));
        } else {
            response.setStatus(0, MessageText.getString("Scrape.status.initializing"));
        }
        try {
            this.hashes_mon.enter();
            this.hashes.put(hash, response);
        }
        finally {
            this.hashes_mon.exit();
        }
        this.scraper.scrapeReceived(response);
        return response;
    }

    protected void removeHash(HashWrapper hash) {
        try {
            this.hashes_mon.enter();
            this.hashes.remove(hash.getHash());
        }
        finally {
            this.hashes_mon.exit();
        }
    }

    protected URL getTrackerURL() {
        return this.tracker_url;
    }

    protected Map getHashes() {
        return this.hashes;
    }

    protected AEMonitor getHashesMonitor() {
        return this.hashes_mon;
    }

    protected void scrapeReceived(TRTrackerScraperResponse response) {
        this.scraper.scrapeReceived(response);
    }

    static /* synthetic */ String access$0(TrackerStatus trackerStatus) {
        return trackerStatus.scrapeURL;
    }

    static /* synthetic */ boolean access$1(TrackerStatus trackerStatus) {
        return trackerStatus.bSingleHashScrapes;
    }

    static /* synthetic */ void access$2(TrackerStatus trackerStatus, boolean bl) {
        trackerStatus.bSingleHashScrapes = bl;
    }

    static /* synthetic */ TRTrackerScraperImpl access$3(TrackerStatus trackerStatus) {
        return trackerStatus.scraper;
    }

    private class ThreadedScrapeRunner
    extends AEThread {
        boolean force;
        ArrayList responses;

        public ThreadedScrapeRunner(ArrayList _responses, boolean _force, boolean async) {
            super("ThreadedScrapeRunner");
            this.force = _force;
            this.responses = _responses;
            if (async) {
                this.setDaemon(true);
                this.start();
            } else {
                this.run();
            }
        }

        /*
         * Unable to fully structure code
         */
        public void runSupport() {
            block39: {
                if (TrackerStatus.access$0(TrackerStatus.this) == null) {
                    return;
                }
                original_bSingleHashScrapes = TrackerStatus.access$1(TrackerStatus.this);
                try {
                    one_of_the_hashes = null;
                    first_separator = TrackerStatus.access$0(TrackerStatus.this).indexOf(63) == -1 ? '?' : '&';
                    info_hash = "";
                    i = 0;
                    while (i < this.responses.size()) {
                        response = (TRTrackerScraperResponseImpl)this.responses.get(i);
                        response.setStatus(3, MessageText.getString("Scrape.status.scraping"));
                        hash = response.getHash();
                        one_of_the_hashes = hash;
                        info_hash = String.valueOf(info_hash) + (i > 0 ? '&' : first_separator) + "info_hash=";
                        info_hash = String.valueOf(info_hash) + URLEncoder.encode(new String(hash, "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
                        ++i;
                    }
                    if (one_of_the_hashes == null) {
                        Debug.out("No hashes for scrape");
                    } else {
                        TorrentUtils.setTLSTorrentHash(one_of_the_hashes);
                    }
                    reqUrl = new URL(String.valueOf(TrackerStatus.access$0(TrackerStatus.this)) + info_hash);
                    LGLogger.log(2, 0, 2, "Accessing scrape interface using url : " + reqUrl);
                    message = new ByteArrayOutputStream();
                    scrapeStartTime = SystemTime.getCurrentTime();
                    if (reqUrl.getProtocol().equalsIgnoreCase("udp")) {
                        TrackerStatus.this.scrapeUDP(reqUrl, message, ((TRTrackerScraperResponseImpl)this.responses.get(0)).getHash());
                        TrackerStatus.access$2(TrackerStatus.this, true);
                    } else {
                        TrackerStatus.this.scrapeHTTP(reqUrl, message);
                    }
                    map = BDecoder.decode(message.toByteArray());
                    mapFiles = map == null ? null : (Map)map.get("files");
                    LGLogger.log(2, 0, 1, "Response from scrape interface " + TrackerStatus.access$0(TrackerStatus.this) + ": " + (mapFiles == null ? "null" : "" + mapFiles.size()) + " returned");
                    if (mapFiles == null || mapFiles.size() == 0) {
                        v0 = failure_reason_bytes = map == null ? null : (byte[])map.get("failure reason");
                        if (failure_reason_bytes != null) {
                            i = 0;
                            while (i < this.responses.size()) {
                                response = (TRTrackerScraperResponseImpl)this.responses.get(i);
                                response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + new String(failure_reason_bytes, "UTF8"));
                                TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                                ++i;
                            }
                        } else if (this.responses.size() > 1) {
                            TrackerStatus.access$2(TrackerStatus.this, true);
                            LGLogger.log(2, 1, 0, String.valueOf(TrackerStatus.access$0(TrackerStatus.this)) + " doesn't properly support multi-hash scrapes");
                            i = 0;
                            while (i < this.responses.size()) {
                                response = (TRTrackerScraperResponseImpl)this.responses.get(i);
                                response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid"));
                                TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                                ++i;
                            }
                        } else {
                            response = (TRTrackerScraperResponseImpl)this.responses.get(0);
                            response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.nohash"));
                            TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                        }
                        return;
                    }
                    if (!TrackerStatus.access$1(TrackerStatus.this) && this.responses.size() > 1 && mapFiles.size() == 1) {
                        TrackerStatus.access$2(TrackerStatus.this, true);
                        LGLogger.log(2, 1, 0, String.valueOf(TrackerStatus.access$0(TrackerStatus.this)) + " only returned " + mapFiles.size() + " hash scrape(s), but we asked for " + this.responses.size());
                    }
                    i = 0;
                    while (i < this.responses.size()) {
                        response = (TRTrackerScraperResponseImpl)this.responses.get(i);
                        scrapeMap = (Map)mapFiles.get(new String(response.getHash(), "ISO-8859-1"));
                        if (scrapeMap == null) {
                            if (this.responses.size() == 1 || mapFiles.size() != 1) {
                                response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.nohash"));
                                TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                            } else {
                                response.revertStatus();
                                if (response.getStatus() == 3) {
                                    System.out.println("Hash " + ByteFormatter.nicePrint(response.getHash(), true) + " mysteriously reverted to ST_SCRAPING!");
                                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid"));
                                } else {
                                    TrackerStatus.access$2(TrackerStatus.this, true);
                                    if (original_bSingleHashScrapes) {
                                        response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                    }
                                }
                                TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                            }
                        } else {
                            seeds = ((Long)scrapeMap.get("complete")).intValue();
                            peers = ((Long)scrapeMap.get("incomplete")).intValue();
                            if (seeds < 0 || peers < 0) {
                                System.out.println("scrapeMap=" + scrapeMap);
                                if (this.responses.size() > 1 && TrackerStatus.access$1(TrackerStatus.this)) {
                                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid"));
                                    TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                                } else {
                                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid") + " " + (seeds < 0 ? String.valueOf(MessageText.getString("MyTorrentsView.seeds")) + " == " + seeds + ". " : "") + (peers < 0 ? String.valueOf(MessageText.getString("MyTorrentsView.peers")) + " == " + peers + ". " : ""));
                                    TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                                }
                            } else {
                                scrapeInterval = 900 + seeds * 10;
                                mapFlags = (Map)map.get("flags");
                                if (mapFlags != null && (iNewScrapeInterval = ((Long)mapFlags.get("min_request_interval")).intValue()) > scrapeInterval) {
                                    scrapeInterval = iNewScrapeInterval;
                                }
                                if (scrapeInterval < 600) {
                                    scrapeInterval = 600;
                                }
                                if (scrapeInterval > 10800) {
                                    scrapeInterval = 10800;
                                }
                                nextScrapeTime = SystemTime.getCurrentTime() + (long)(scrapeInterval * 1000);
                                response.setNextScrapeStartTime(nextScrapeTime);
                                response.setScrapeStartTime(scrapeStartTime);
                                response.seeds = seeds;
                                response.peers = peers;
                                response.setStatus(2, MessageText.getString("Scrape.status.ok"));
                                TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                            }
                        }
                        ++i;
                    }
                    break block39;
                }
                catch (NoClassDefFoundError ignoreSSL) {
                    i = 0;
                    ** while (i < this.responses.size())
                }
lbl-1000:
                // 1 sources

                {
                    response = (TRTrackerScraperResponseImpl)this.responses.get(i);
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + ignoreSSL.getMessage());
                    TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                    ++i;
                    continue;
lbl125:
                    // 1 sources

                    break block39;
                }
                catch (FileNotFoundException e) {
                    i = 0;
                    ** while (i < this.responses.size())
                }
lbl-1000:
                // 1 sources

                {
                    response = (TRTrackerScraperResponseImpl)this.responses.get(i);
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("DownloadManager.error.filenotfound"));
                    TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                    ++i;
                    continue;
lbl135:
                    // 1 sources

                    break block39;
                }
                catch (ConnectException e) {
                    i = 0;
                    ** while (i < this.responses.size())
                }
lbl-1000:
                // 1 sources

                {
                    response = (TRTrackerScraperResponseImpl)this.responses.get(i);
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + e.getLocalizedMessage());
                    TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                    ++i;
                    continue;
lbl145:
                    // 1 sources

                    break block39;
                }
                catch (Exception e) {
                    error_message = e.getMessage();
                    if (error_message != null && error_message.indexOf("414") != -1) {
                        TrackerStatus.access$2(TrackerStatus.this, true);
                    }
                    LGLogger.log(2, 2, 3, "Error from scrape interface " + TrackerStatus.access$0(TrackerStatus.this) + " : " + Debug.getNestedExceptionMessage(e));
                    i = 0;
                    ** while (i < this.responses.size())
                }
lbl-1000:
                // 1 sources

                {
                    response = (TRTrackerScraperResponseImpl)this.responses.get(i);
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + Debug.getNestedExceptionMessage(e));
                    TrackerStatus.access$3(TrackerStatus.this).scrapeReceived(response);
                    ++i;
                    continue;
                }
            }
        }
    }
}

