/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class PRUDPPacket {
    public static int VERSION = 2;
    public static final int MAX_PACKET_SIZE = 8192;
    public static final int DEFAULT_UDP_TIMEOUT = 30000;
    public static final int DEFAULT_RETRY_COUNT = 1;
    public static final int ACT_REQUEST_CONNECT = 0;
    public static final int ACT_REQUEST_ANNOUNCE = 1;
    public static final int ACT_REQUEST_SCRAPE = 2;
    public static final int ACT_REPLY_CONNECT = 0;
    public static final int ACT_REPLY_ANNOUNCE = 1;
    public static final int ACT_REPLY_SCRAPE = 2;
    public static final int ACT_REPLY_ERROR = 3;
    public static final long INITIAL_CONNECTION_ID = 4497486125440L;
    protected static int next_id;
    protected static AEMonitor class_mon;
    protected int type;
    protected int transaction_id;

    static {
        VERSION = COConfigurationManager.getIntParameter("Tracker Port UDP Version", 2);
        next_id = new Random(SystemTime.getCurrentTime()).nextInt();
        class_mon = new AEMonitor("PRUDPPacket");
    }

    protected PRUDPPacket(int _type, int _transaction_id) {
        this.type = _type;
        this.transaction_id = _transaction_id;
    }

    protected PRUDPPacket(int _type) {
        this.type = _type;
        try {
            class_mon.enter();
            this.transaction_id = next_id++;
        }
        finally {
            class_mon.exit();
        }
    }

    public int getAction() {
        return this.type;
    }

    public int getTransactionId() {
        return this.transaction_id;
    }

    public abstract void serialise(DataOutputStream var1) throws IOException;

    public String getString() {
        return "type=".concat(String.valueOf(this.type));
    }
}

