/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactoryListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerUDP;
import org.gudy.azureus2.core3.util.AEMonitor;

public class TRTrackerServerFactoryImpl {
    protected static List servers = new ArrayList();
    protected static List listeners = new ArrayList();
    protected static AEMonitor class_mon = new AEMonitor("TRTrackerServerFactory");

    public static TRTrackerServer create(String name, int protocol, int port, boolean ssl, boolean apply_ip_filter) throws TRTrackerServerException {
        try {
            TRTrackerServerImpl server;
            class_mon.enter();
            if (protocol == 1) {
                server = new TRTrackerServerTCP(name, port, ssl, apply_ip_filter);
            } else {
                if (ssl) {
                    throw new TRTrackerServerException("TRTrackerServerFactory: UDP doesn't support SSL");
                }
                server = new TRTrackerServerUDP(name, port);
            }
            servers.add(server);
            int i = 0;
            while (i < listeners.size()) {
                ((TRTrackerServerFactoryListener)listeners.get(i)).serverCreated(server);
                ++i;
            }
            TRTrackerServerImpl tRTrackerServerImpl = server;
            class_mon.exit();
            return tRTrackerServerImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public static void addListener(TRTrackerServerFactoryListener l) {
        try {
            class_mon.enter();
            listeners.add(l);
            int i = 0;
            while (i < servers.size()) {
                l.serverCreated((TRTrackerServer)servers.get(i));
                ++i;
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static void removeListener(TRTrackerServerFactoryListener l) {
        try {
            class_mon.enter();
            TRTrackerServerFactoryImpl.removeListener(l);
        }
        finally {
            class_mon.exit();
        }
    }
}

