/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileIsADirectoryException;
import org.gudy.azureus2.core3.util.SystemProperties;

public class FileUtil {
    public static final String DIR_SEP = System.getProperty("file.separator");
    private static final int RESERVED_FILE_HANDLE_COUNT = 4;
    private static List reserved_file_handles = new ArrayList();
    private static AEMonitor class_mon = new AEMonitor("FileUtil:class");

    public static String getCanonicalFileName(String filename) {
        String canonicalFileName = filename;
        try {
            canonicalFileName = new File(filename).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return canonicalFileName;
    }

    public static File getUserFile(String filename) {
        return new File(SystemProperties.getUserPath(), filename);
    }

    public static File getApplicationFile(String filename) {
        String path = SystemProperties.getApplicationPath();
        if (Constants.isOSX) {
            path = String.valueOf(path) + "/Azureus.app/Contents/";
        }
        return new File(path, filename);
    }

    public static boolean isTorrentFile(String filename) throws FileNotFoundException, IOException {
        File check = new File(filename);
        if (!check.exists()) {
            throw new FileNotFoundException("File " + filename + " not found.");
        }
        if (!check.canRead()) {
            throw new IOException("File " + filename + " cannot be read.");
        }
        if (check.isDirectory()) {
            throw new FileIsADirectoryException("File " + filename + " is a directory.");
        }
        try {
            TOTorrentFactory.deserialiseFromBEncodedFile(check);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void recursiveDelete(File f) {
        String defSaveDir = COConfigurationManager.getStringParameter("Default save path", "");
        String moveToDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
        try {
            if (f.getCanonicalPath().equals(moveToDir)) {
                System.out.println("FileUtil::recursiveDelete:: not allowed to delete the MoveTo dir !");
                return;
            }
            if (f.getCanonicalPath().equals(defSaveDir)) {
                System.out.println("FileUtil::recursiveDelete:: not allowed to delete the default data dir !");
                return;
            }
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                int i = 0;
                while (i < files.length) {
                    FileUtil.recursiveDelete(files[i]);
                    ++i;
                }
                f.delete();
            } else {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static long getFileOrDirectorySize(File file) {
        if (file.isFile()) {
            return file.length();
        }
        long res = 0L;
        File[] files = file.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                res += FileUtil.getFileOrDirectorySize(files[i]);
                ++i;
            }
        }
        return res;
    }

    public static void recursiveEmptyDirDelete(File f) {
        int p1;
        HashMap<String, String> ignore_map = new HashMap<String, String>();
        String ignore_list = COConfigurationManager.getStringParameter("File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini");
        int pos = 0;
        do {
            String bit;
            if ((p1 = ignore_list.indexOf(";", pos)) == -1) {
                bit = ignore_list.substring(pos);
            } else {
                bit = ignore_list.substring(pos, p1);
                pos = p1 + 1;
            }
            ignore_map.put(bit.trim().toLowerCase(), "");
        } while (p1 != -1);
        FileUtil.recursiveEmptyDirDelete(f, ignore_map);
    }

    private static void recursiveEmptyDirDelete(File f, Map ignore_map) {
        try {
            String defSaveDir = COConfigurationManager.getStringParameter("Default save path", "");
            String moveToDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
            if (defSaveDir.trim().length() > 0) {
                defSaveDir = new File(defSaveDir).getCanonicalPath();
            }
            if (moveToDir.trim().length() > 0) {
                moveToDir = new File(moveToDir).getCanonicalPath();
            }
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                if (files == null) {
                    Debug.out("FileUtil::recursiveEmptyDirDelete:: failed list contents of directory" + f);
                    return;
                }
                int i = 0;
                while (i < files.length) {
                    File x = files[i];
                    if (x.isDirectory()) {
                        FileUtil.recursiveEmptyDirDelete(files[i], ignore_map);
                    } else if (ignore_map.get(x.getName().toLowerCase()) != null && !x.delete()) {
                        Debug.out("FileUtil::recursiveEmptyDirDelete:: failed to delete file" + x);
                    }
                    ++i;
                }
                if (f.getCanonicalPath().equals(moveToDir)) {
                    Debug.out("FileUtil::recursiveEmptyDirDelete:: not allowed to delete the MoveTo dir !");
                    return;
                }
                if (f.getCanonicalPath().equals(defSaveDir)) {
                    Debug.out("FileUtil::recursiveEmptyDirDelete:: not allowed to delete the default data dir !");
                    return;
                }
                if (f.listFiles().length == 0) {
                    if (!f.delete()) {
                        Debug.out("FileUtil::recursiveEmptyDirDelete:: failed to delete directory" + f);
                    }
                } else {
                    Debug.out("FileUtil::recursiveEmptyDirDelete:: " + f.listFiles().length + " file(s)/folder(s) still in " + f + ". Not removing.");
                }
            }
        }
        catch (Exception e) {
            Debug.out(e.toString());
        }
    }

    public static String convertOSSpecificChars(String file_name_in) {
        char[] chars = file_name_in.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\"') {
                chars[i] = 39;
            }
            ++i;
        }
        if (!Constants.isOSX) {
            char c;
            if (Constants.isWindows) {
                i = 0;
                while (i < chars.length) {
                    c = chars[i];
                    if (c == '\\' || c == '/' || c == ':' || c == '?' || c == '*') {
                        chars[i] = 95;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < chars.length) {
                c = chars[i];
                if (c == '/' || c == '\r' || c == '\n') {
                    chars[i] = 32;
                }
                ++i;
            }
        }
        String file_name_out = new String(chars);
        try {
            String str = new File(file_name_out).getCanonicalFile().toString();
            int p = str.lastIndexOf(File.separator);
            file_name_out = str.substring(p + 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return file_name_out;
    }

    public static void writeResilientConfigFile(String file_name, Map data) {
        try {
            class_mon.enter();
            try {
                FileUtil.getReservedFileHandles();
                File temp = new File(String.valueOf(SystemProperties.getUserPath()) + file_name + ".saving");
                FilterOutputStream baos = null;
                try {
                    try {
                        byte[] encoded_data = BEncoder.encode(data);
                        baos = new BufferedOutputStream(new FileOutputStream(temp, false), 8192);
                        baos.write(encoded_data);
                        ((BufferedOutputStream)baos).flush();
                        baos.close();
                        baos = null;
                        if (temp.length() > 1L) {
                            File file = new File(String.valueOf(SystemProperties.getUserPath()) + file_name);
                            if (file.exists()) {
                                file.delete();
                            }
                            temp.renameTo(file);
                        }
                    }
                    catch (Exception e) {
                        LGLogger.logUnrepeatableAlert("Save of '" + file_name + "' fails", e);
                    }
                }
                finally {
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                    }
                    catch (Exception e) {
                        LGLogger.logUnrepeatableAlert("Save of '" + file_name + "' fails", e);
                    }
                }
            }
            finally {
                FileUtil.releaseReservedFileHandles();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * Loose catch block
     */
    public static Map readResilientConfigFile(String file_name) {
        class_mon.enter();
        try {
            FileUtil.getReservedFileHandles();
            Map map = FileUtil.readResilientConfigFile(file_name, 0);
            FileUtil.releaseReservedFileHandles();
            class_mon.exit();
            return map;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            HashMap hashMap = new HashMap();
            FileUtil.releaseReservedFileHandles();
            class_mon.exit();
            return hashMap;
            {
                catch (Throwable throwable) {
                    try {
                        FileUtil.releaseReservedFileHandles();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        class_mon.exit();
                        throw throwable2;
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map readResilientConfigFile(String file_name, int fail_count) {
        boolean using_backup = file_name.endsWith(".saving");
        File file = new File(String.valueOf(SystemProperties.getUserPath()) + file_name);
        if (!file.exists() || file.length() <= 1L) {
            if (!using_backup) {
                LGLogger.log("Load of '" + file_name + "' failed, file not found or 0-sized.");
                return FileUtil.readResilientConfigFile(String.valueOf(file_name) + ".saving", 0);
            }
            if (fail_count == 1) {
                LGLogger.logUnrepeatableAlert(3, "Load of '" + file_name + "' fails, no usable file or backup");
                return new HashMap();
            }
            LGLogger.log(0, "Load of '" + file_name + "' fails, file not found");
            return new HashMap();
        }
        BufferedInputStream bin = null;
        try {
            try {
                int retry_limit = 5;
                while (true) {
                    try {
                        bin = new BufferedInputStream(new FileInputStream(file), 8192);
                    }
                    catch (IOException e) {
                        if (--retry_limit == 0) {
                            throw e;
                        }
                        LGLogger.log("Failed to open '" + file.toString() + "' - " + e.getMessage() + ", retrying");
                        Thread.sleep(500L);
                        continue;
                    }
                    break;
                }
                Map res = BDecoder.decode(bin);
                if (using_backup) {
                    LGLogger.logUnrepeatableAlert(1, "Load of '" + file_name.substring(0, file_name.length() - 7) + "' had to revert to backup file");
                }
                Map map = res;
                try {
                    if (bin == null) return map;
                    bin.close();
                    return map;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                return map;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                LGLogger.log("Read of '" + file_name + "' failed, b-decoding error. Renaming to *.bad");
                File bad = new File(file.getParentFile(), String.valueOf(file.getName()) + ".bad");
                try {
                    if (bin != null) {
                        bin.close();
                    }
                }
                catch (Exception x) {
                    Debug.printStackTrace(x);
                }
                file.renameTo(bad);
                if (using_backup) {
                    LGLogger.logUnrepeatableAlert(3, "Load of '" + file_name + "' fails, no usable file or backup");
                    HashMap hashMap = new HashMap();
                    try {
                        if (bin == null) return hashMap;
                        bin.close();
                        return hashMap;
                    }
                    catch (Exception e2) {
                        Debug.printStackTrace(e2);
                    }
                    return hashMap;
                }
                Map map = FileUtil.readResilientConfigFile(String.valueOf(file_name) + ".saving", 1);
                try {
                    if (bin == null) return map;
                    bin.close();
                    return map;
                }
                catch (Exception e4) {
                    Debug.printStackTrace(e4);
                }
                return map;
            }
        }
        catch (Throwable throwable) {
            try {
                if (bin == null) throw throwable;
                bin.close();
                throw throwable;
            }
            catch (Exception e3) {
                Debug.printStackTrace(e3);
            }
            throw throwable;
        }
    }

    private static void getReservedFileHandles() {
        try {
            class_mon.enter();
            while (reserved_file_handles.size() > 0) {
                InputStream is = (InputStream)reserved_file_handles.remove(0);
                try {
                    is.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    private static void releaseReservedFileHandles() {
        try {
            try {
                class_mon.enter();
                File lock_file = new File(String.valueOf(SystemProperties.getUserPath()) + ".lock");
                lock_file.createNewFile();
                while (reserved_file_handles.size() < 4) {
                    FileInputStream is = new FileInputStream(lock_file);
                    reserved_file_handles.add(is);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static void backupFile(String _filename, boolean _make_copy) {
        FileUtil.backupFile(new File(_filename), _make_copy);
    }

    public static void backupFile(File _file, boolean _make_copy) {
        if (_file.length() > 0L) {
            File bakfile = new File(String.valueOf(_file.getAbsolutePath()) + ".bak");
            if (bakfile.exists()) {
                bakfile.delete();
            }
            if (_make_copy) {
                FileUtil.copyFile(_file, bakfile);
            } else {
                _file.renameTo(bakfile);
            }
        }
    }

    public static boolean copyFile(String _source_name, String _dest_name) {
        return FileUtil.copyFile(new File(_source_name), new File(_dest_name));
    }

    public static boolean copyFile(File _source, File _dest) {
        try {
            FileUtil.copyFile(new FileInputStream(_source), new FileOutputStream(_dest));
            return true;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    public static boolean copyFile(File _source, OutputStream _dest, boolean closeOutputStream) {
        try {
            FileUtil.copyFile(new FileInputStream(_source), _dest, closeOutputStream);
            return true;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    public static void copyFile(InputStream is, OutputStream os) throws IOException {
        FileUtil.copyFile(is, os, true);
    }

    public static void copyFile(InputStream is, OutputStream os, boolean closeInputStream) throws IOException {
        try {
            int len;
            if (!(is instanceof BufferedInputStream)) {
                is = new BufferedInputStream(is);
            }
            byte[] buffer = new byte[131072];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        finally {
            try {
                if (closeInputStream) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            os.close();
        }
    }

    public static File getFileOrBackup(String _filename) {
        try {
            File file = new File(_filename);
            if (file.length() <= 1L) {
                File bakfile = new File(String.valueOf(_filename) + ".bak");
                if (bakfile.length() <= 1L) {
                    return null;
                }
                return bakfile;
            }
            return file;
        }
        catch (Exception e) {
            Debug.out(e);
            return null;
        }
    }

    public static File getJarFileFromURL(String url_str) {
        if (url_str.startsWith("jar:file:")) {
            if (!(url_str = url_str.replaceAll(" ", "%20")).startsWith("jar:file:/")) {
                url_str = "jar:file:/".concat(url_str.substring(9));
            }
            try {
                int posPling = url_str.lastIndexOf(33);
                String jarName = url_str.substring(4, posPling);
                URI uri = URI.create(jarName);
                File jar = new File(uri);
                return jar;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean renameFile(File from_file, File to_file) {
        if (to_file.exists()) {
            Debug.out("renameFile: target file '" + to_file + "' already exists, failing");
            return false;
        }
        if (!COConfigurationManager.getBooleanParameter("Copy And Delete Data Rather Than Move") && from_file.renameTo(to_file)) {
            return true;
        }
        boolean success = false;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                fis = new FileInputStream(from_file);
                fos = new FileOutputStream(to_file);
                byte[] buffer = new byte[65536];
                while (true) {
                    int len;
                    if ((len = fis.read(buffer)) <= 0) {
                        fos.close();
                        fos = null;
                        fis.close();
                        fis = null;
                        if (!from_file.delete()) {
                            throw new Exception("Failed to delete '" + from_file.toString() + "'");
                        }
                        break;
                    }
                    fos.write(buffer, 0, len);
                }
                success = true;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (success || !to_file.exists()) return true;
                to_file.delete();
                return true;
            }
            catch (Throwable e) {
                LGLogger.logUnrepeatableAlert("Failed to rename '" + from_file.toString() + "' to '" + to_file.toString() + "'", e);
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (success || !to_file.exists()) return false;
                to_file.delete();
                return false;
            }
        }
        catch (Throwable throwable) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
            }
            if (success || !to_file.exists()) throw throwable;
            to_file.delete();
            throw throwable;
        }
    }
}

