/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser;

import java.util.Vector;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentAttributeImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SimpleXMLParserDocumentNodeImpl
implements SimpleXMLParserDocumentNode {
    protected SimpleXMLParserDocumentImpl document;
    protected Node node;
    protected SimpleXMLParserDocumentNode[] kids;

    protected SimpleXMLParserDocumentNodeImpl(SimpleXMLParserDocumentImpl _doc, Node _node) {
        this.document = _doc;
        this.node = _node;
    }

    public String getName() {
        return this.node.getLocalName();
    }

    public String getValue() {
        if (this.node.getNodeType() == 7) {
            return this.node.getNodeValue();
        }
        String res = "";
        Node child = this.node.getFirstChild();
        while (child != null) {
            short type = child.getNodeType();
            if (type == 4 || type == 3 || type == 12) {
                String str = child.getNodeValue();
                res = String.valueOf(res) + str;
            }
            child = child.getNextSibling();
        }
        return res;
    }

    public SimpleXMLParserDocumentAttribute getAttribute(String name) {
        SimpleXMLParserDocumentAttribute[] attributes = this.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].getName().equalsIgnoreCase(name)) {
                return attributes[i];
            }
            ++i;
        }
        return null;
    }

    public SimpleXMLParserDocumentAttribute[] getAttributes() {
        Vector<SimpleXMLParserDocumentAttributeImpl> v = new Vector<SimpleXMLParserDocumentAttributeImpl>();
        if (this.node.getNodeType() == 1) {
            NamedNodeMap atts = this.node.getAttributes();
            int i = 0;
            while (i < atts.getLength()) {
                Node child = atts.item(i);
                v.addElement(new SimpleXMLParserDocumentAttributeImpl(child.getNodeName(), child.getNodeValue()));
                ++i;
            }
        }
        Node child = this.node.getFirstChild();
        while (child != null) {
            short type = child.getNodeType();
            if (type == 2) {
                v.addElement(new SimpleXMLParserDocumentAttributeImpl(child.getNodeName(), child.getNodeValue()));
            }
            child = child.getNextSibling();
        }
        Object[] res = new SimpleXMLParserDocumentAttributeImpl[v.size()];
        v.copyInto(res);
        return res;
    }

    public SimpleXMLParserDocumentNode[] getChildren() {
        if (this.kids == null) {
            this.kids = this.document.parseNode(this.node, true);
        }
        return this.kids;
    }

    public SimpleXMLParserDocumentNode getChild(String name) {
        SimpleXMLParserDocumentNode[] kids = this.getChildren();
        int i = 0;
        while (i < kids.length) {
            if (kids[i].getName().equalsIgnoreCase(name)) {
                return kids[i];
            }
            ++i;
        }
        return null;
    }

    protected void print(String indent) {
        String attr_str = "";
        SimpleXMLParserDocumentAttribute[] attrs = this.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            attr_str = String.valueOf(attr_str) + (i == 0 ? "" : ",") + attrs[i].getName() + "=" + attrs[i].getValue();
            ++i;
        }
        System.out.println(String.valueOf(indent) + this.getName() + ":" + attr_str + " -> " + this.getValue());
        SimpleXMLParserDocumentNode[] kids = this.getChildren();
        int i2 = 0;
        while (i2 < kids.length) {
            ((SimpleXMLParserDocumentNodeImpl)kids[i2]).print(String.valueOf(indent) + "  ");
            ++i2;
        }
    }
}

