/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.BufferedToolItem;

public class IconBar {
    CoolBar coolBar;
    Composite parent;
    Map itemKeyToControl;
    IconBarEnabler currentEnabler;

    public IconBar(Composite parent) {
        this.parent = parent;
        this.itemKeyToControl = new HashMap();
        this.coolBar = new CoolBar(parent, 0);
        this.initBar();
        this.coolBar.setLocked(true);
    }

    public void setEnabled(String itemKey, boolean enabled) {
        BufferedToolItem BufferedToolItem2 = (BufferedToolItem)this.itemKeyToControl.get(itemKey);
        if (BufferedToolItem2 != null) {
            BufferedToolItem2.setEnabled(enabled);
        }
    }

    public void setSelection(String itemKey, boolean selection) {
        BufferedToolItem BufferedToolItem2 = (BufferedToolItem)this.itemKeyToControl.get(itemKey);
        if (BufferedToolItem2 != null) {
            BufferedToolItem2.setSelection(selection);
        }
    }

    public void setCurrentEnabler(IconBarEnabler enabler) {
        this.currentEnabler = enabler;
        this.refreshEnableItems();
    }

    private void refreshEnableItems() {
        Iterator iter = this.itemKeyToControl.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            BufferedToolItem BufferedToolItem2 = (BufferedToolItem)this.itemKeyToControl.get(key);
            if (BufferedToolItem2 == null) continue;
            if (this.currentEnabler != null) {
                BufferedToolItem2.setEnabled(this.currentEnabler.isEnabled(key));
                BufferedToolItem2.setSelection(this.currentEnabler.isSelected(key));
                continue;
            }
            BufferedToolItem2.setEnabled(false);
            BufferedToolItem2.setSelection(false);
        }
    }

    private BufferedToolItem createBufferedToolItem(ToolBar toolBar, int style, String key, String imageName, String toolTipKey) {
        final BufferedToolItem bufferedToolItem = new BufferedToolItem(toolBar, style);
        bufferedToolItem.setData("key", key);
        Messages.setLanguageText(bufferedToolItem, toolTipKey);
        bufferedToolItem.setImage(ImageRepository.getImage(imageName));
        bufferedToolItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (IconBar.this.currentEnabler != null) {
                    IconBar.this.currentEnabler.itemActivated((String)bufferedToolItem.getData("key"));
                }
            }
        });
        this.itemKeyToControl.put(key, bufferedToolItem);
        return bufferedToolItem;
    }

    private void initBar() {
        CoolItem coolItem = new CoolItem(this.coolBar, 0);
        ToolBar toolBar = new ToolBar((Composite)this.coolBar, 0x800000);
        this.createBufferedToolItem(toolBar, 8, "open", "cb_open", "iconBar.open.tooltip");
        this.createBufferedToolItem(toolBar, 8, "open_no_default", "cb_open_no_default", "iconBar.openNoDefault.tooltip");
        this.createBufferedToolItem(toolBar, 8, "open_url", "cb_open_url", "iconBar.openURL.tooltip");
        this.createBufferedToolItem(toolBar, 8, "open_folder", "cb_open_folder", "iconBar.openFolder.tooltip");
        this.createBufferedToolItem(toolBar, 8, "new", "cb_new", "iconBar.new.tooltip");
        toolBar.pack();
        Point p = toolBar.getSize();
        coolItem.setControl((Control)toolBar);
        coolItem.setSize(coolItem.computeSize(p.x, p.y));
        coolItem.setMinimumSize(p.x, p.y);
        coolItem = new CoolItem(this.coolBar, 0);
        toolBar = new ToolBar((Composite)this.coolBar, 0x800000);
        this.createBufferedToolItem(toolBar, 8, "top", "cb_top", "iconBar.top.tooltip");
        this.createBufferedToolItem(toolBar, 8, "up", "cb_up", "iconBar.up.tooltip");
        this.createBufferedToolItem(toolBar, 8, "down", "cb_down", "iconBar.down.tooltip");
        this.createBufferedToolItem(toolBar, 8, "bottom", "cb_bottom", "iconBar.bottom.tooltip");
        new BufferedToolItem(toolBar, 2);
        this.createBufferedToolItem(toolBar, 8, "run", "cb_run", "iconBar.run.tooltip");
        this.createBufferedToolItem(toolBar, 8, "host", "cb_host", "iconBar.host.tooltip");
        this.createBufferedToolItem(toolBar, 8, "publish", "cb_publish", "iconBar.publish.tooltip");
        this.createBufferedToolItem(toolBar, 8, "start", "cb_start", "iconBar.start.tooltip");
        this.createBufferedToolItem(toolBar, 8, "stop", "cb_stop", "iconBar.stop.tooltip");
        this.createBufferedToolItem(toolBar, 8, "remove", "cb_remove", "iconBar.remove.tooltip");
        toolBar.pack();
        p = toolBar.getSize();
        coolItem.setControl((Control)toolBar);
        coolItem.setSize(p.x, p.y);
        coolItem.setMinimumSize(p.x, p.y);
    }

    public void setLayoutData(Object layoutData) {
        this.coolBar.setLayoutData(layoutData);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        ImageRepository.loadImages(display);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        shell.setLayout((Layout)layout);
        IconBar ibar = new IconBar((Composite)shell);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        ibar.setLayoutData(formData);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public CoolBar getCoolBar() {
        return this.coolBar;
    }
}

