/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.cxx;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.cxx.Cxx;
import gov.llnl.babel.backend.cxx.CxxStubHeader;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import java.io.IOException;
import java.util.Iterator;

public class CxxImplHeader {
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;
    private CodeSplicer d_splicer = null;

    public CxxImplHeader(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void generateCode() throws CodeGenerationException {
        String nm = "CxxImplHeader.generateCode: ";
        SymbolID id = this.d_ext.getSymbolID();
        int type = this.d_ext.getSymbolType();
        String filename = Cxx.generateFilename(id, 1, 1);
        try {
            block4: {
                try {
                    this.d_splicer = FileManager.getInstance().getCodeSplicer(id, type, filename);
                    this.d_writer = Cxx.createHeader(this.d_ext, 1, "IMPLHDRS");
                    this.d_splicer.setLineRedirector(this.d_writer);
                    this.d_writer.println();
                    this.d_writer.openHeaderGuard(filename);
                    Cxx.generateDependencyIncludes(this.d_writer, this.d_ext, false);
                    this.spliceIncludes();
                    Cxx.nestPackagesInNamespaces(this.d_writer, this.d_ext);
                    this.writeClassBeginning();
                    this.writeSIDLDefinedMethods();
                    this.writeClassEnd();
                    Cxx.unnestPackagesInNamespaces(this.d_writer, this.d_ext);
                    this.writeMiscStuff();
                    this.d_writer.closeHeaderGuard();
                    if (!this.d_splicer.hasUnusedSymbolEdits()) break block4;
                    this.d_writer.println();
                    this.d_writer.printlnUnformatted("#error File has unused splicer blocks.");
                    this.d_writer.beginBlockComment(true);
                    this.d_writer.println("================= BEGIN UNREFERENCED METHOD(S) ================");
                    this.d_writer.println("The following code segment(s) belong to unreferenced method(s).");
                    this.d_writer.println("This can result from a method rename/removal in the sidl file.");
                    this.d_writer.println("Move or remove the code in order to compile cleanly.");
                    this.d_writer.println("================== END UNREFERENCED METHOD(S) =================");
                    this.d_splicer.outputUnusedSymbolEdits(this.d_writer.getPrintWriter());
                    this.d_writer.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
                }
                catch (IOException ex) {
                    throw new CodeGenerationException("CxxImplHeader.generateCode: IOException : " + ex.getMessage());
                }
            }
            Object var7_5 = null;
            if (this.d_writer == null) return;
            this.d_writer.close();
            this.d_writer = null;
            return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
    }

    private void spliceIncludes() {
        this.d_writer.println();
        String includes = this.d_ext.getSymbolID().getFullName() + "." + "_includes";
        this.d_splicer.splice(includes, this.d_writer, "includes or arbitrary code");
        this.d_writer.println();
    }

    private void writeClassBeginning() throws CodeGenerationException {
        String name = this.d_ext.getSymbolID().getShortName();
        SymbolID id = this.d_ext.getSymbolID();
        String splicer_symbol_impl = this.d_ext.getSymbolID().getFullName() + "._implementation";
        String splicer_symbol_inherit = this.d_ext.getSymbolID().getFullName() + "._inherits";
        this.d_writer.writeComment(this.d_ext, true);
        this.d_writer.println("class " + name + "_impl");
        this.d_splicer.splice(splicer_symbol_inherit, this.d_writer, "optional inheritance here");
        this.d_writer.println("{");
        this.d_writer.println();
        this.writeSuperClass();
        this.d_writer.println("private:");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("Pointer back to IOR.");
        this.d_writer.writeCommentLine("Use this to dispatch back through IOR vtable.");
        this.d_writer.println(name + " self;");
        this.d_writer.println();
        this.d_splicer.splice(splicer_symbol_impl, this.d_writer, "additional details");
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("private:");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("private default constructor (required)");
        this.d_writer.println(name + "_impl() ");
        if (this.hasOverwrittenClassMethods()) {
            this.d_writer.println(": super() ");
        }
        this.d_writer.println("{} ");
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("public:");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("sidl constructor (required)");
        this.d_writer.writeCommentLine("Note: alternate Skel constructor doesn't call addref()");
        this.d_writer.writeCommentLine("(fixes bug #275)");
        if (this.hasOverwrittenClassMethods()) {
            this.d_writer.println(name + "_impl( " + IOR.getObjectName(id) + " * s ) : self(s,true), super(s, " + id.getShortName() + "::_get_ext()) { _ctor(); }");
        } else {
            this.d_writer.println(name + "_impl( " + IOR.getObjectName(id) + " * s ) : self(s,true) { _ctor(); }");
        }
        this.d_writer.println();
        this.d_writer.writeCommentLine("user defined construction");
        this.d_writer.println("void _ctor();");
        this.d_writer.println();
        this.d_writer.writeCommentLine("virtual destructor (required)");
        this.d_writer.println("virtual ~" + name + "_impl() { _dtor(); }");
        this.d_writer.println();
        this.d_writer.writeCommentLine("user defined destruction");
        this.d_writer.println("void _dtor();");
        this.d_writer.println();
        this.d_writer.writeCommentLine("static class initializer");
        this.d_writer.println("static void _load();");
        this.d_writer.println();
        String handler_desc = "assertion error handler.";
        String user_def = "user-defined ";
        if (IOR.supportAssertions(this.d_ext)) {
            if (this.d_ext.hasStaticMethod(true)) {
                Cxx.generateMethodSignature(this.d_writer, IOR.getBuiltinMethod(8, id, true), "", "user-defined static assertion error handler.", 1, false);
            }
            Cxx.generateMethodSignature(this.d_writer, IOR.getBuiltinMethod(8, id), "", "user-defined assertion error handler.", 1, false);
        }
    }

    private void writeClassEnd() {
        String name = this.d_ext.getSymbolID().getShortName();
        this.d_writer.backTab();
        this.d_writer.print("};  ");
        this.d_writer.writeCommentLine("end class " + name + "_impl");
        this.d_writer.println();
    }

    private void writeMiscStuff() {
        String splicer_symbol = this.d_ext.getSymbolID().getFullName() + "._misc";
        this.d_splicer.splice(splicer_symbol, this.d_writer, "miscellaneous things");
        this.d_writer.println();
    }

    private void writeSuperClass() throws CodeGenerationException {
        String nm = "CxxImplHeader.writeSuperClass: ";
        if (!this.d_ext.isInterface()) {
            try {
                Class cls = (Class)this.d_ext;
                if (cls.hasOverwrittenMethods()) {
                    CxxStubHeader.generateSupers(cls, this.d_writer);
                    this.d_writer.println();
                    this.d_writer.println("private:");
                    this.d_writer.writeCommentLine("CxxImplHeader.writeSuperClass: Use this to dispatch to super functions.");
                    this.d_writer.println("Super super;");
                    this.d_writer.println();
                }
            }
            catch (Exception ex) {
                throw new CodeGenerationException("CxxImplHeader.writeSuperClass: Attempted to cast non Class to Class.");
            }
        }
    }

    private boolean hasOverwrittenClassMethods() throws CodeGenerationException {
        String nm = "CxxImplHeader.hasOverwrittenClassMethods: ";
        if (!this.d_ext.isInterface()) {
            try {
                Class cls = (Class)this.d_ext;
                if (cls.hasOverwrittenMethods()) {
                    return true;
                }
            }
            catch (Exception ex) {
                throw new CodeGenerationException("CxxImplHeader.hasOverwrittenClassMethods: Attempted to cast non Class to Class.");
            }
        }
        return false;
    }

    private void writeSIDLDefinedMethods() throws CodeGenerationException {
        Method method;
        String user_def = "user defined ";
        String pre = "pre-call ";
        String post = "post-call ";
        String iceptor = "interceptor.";
        String meth = "method.";
        this.d_writer.backTab();
        this.d_writer.println("public:");
        this.d_writer.tab();
        String desc = "static ";
        Iterator m = null;
        m = this.d_ext.getStaticMethods(false).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            if (IOR.supportInterceptors(this.d_ext)) {
                Cxx.generateMethodSignature(this.d_writer, method, "_pre", "user defined " + desc + "pre-call " + "interceptor.", 1, true);
                Cxx.generateMethodSignature(this.d_writer, method, "", "user defined " + desc + "method.", 1, true);
                Cxx.generateMethodSignature(this.d_writer, method, "_post", "user defined " + desc + "post-call " + "interceptor.", 1, true);
                continue;
            }
            Cxx.generateMethodSignature(this.d_writer, method, "", "user defined " + desc + "method.", 1, true);
        }
        this.d_writer.println();
        desc = "non-static ";
        m = this.d_ext.getNonstaticMethods(false).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            if (method.isAbstract()) continue;
            if (IOR.supportInterceptors(this.d_ext)) {
                Cxx.generateMethodSignature(this.d_writer, method, "_pre", "user defined " + desc + "pre-call " + "interceptor.", 1, true);
                Cxx.generateMethodSignature(this.d_writer, method, "", "user defined " + desc + "method.", 1, true);
                Cxx.generateMethodSignature(this.d_writer, method, "_post", "user defined " + desc + "post-call " + "interceptor.", 1, true);
                continue;
            }
            Cxx.generateMethodSignature(this.d_writer, method, "", "user defined " + desc + "method.", 1, true);
        }
    }
}

