/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.cxx;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.cxx.Cxx;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class CxxSkelSource {
    private static final String[] s_ensureOrderConstant = new String[]{"sidl::general_order", "sidl::column_major_order", "sidl::row_major_order"};
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;

    public CxxSkelSource(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void generateCode() throws CodeGenerationException {
        String filename = Cxx.generateFilename(this.d_ext.getSymbolID(), 2, 2);
        try {
            this.d_writer = Cxx.createSource(this.d_ext, 2, "SKELSRCS");
            SymbolID id = this.d_ext.getSymbolID();
            this.d_writer.generateInclude(Cxx.generateFilename(this.d_ext.getSymbolID(), 1, 1), true);
            this.d_writer.generateInclude(IOR.getHeaderFile(id), true);
            if (this.d_ext.hasExceptionThrowingMethod(true)) {
                this.d_writer.generateInclude(Cxx.generateFilename("sidl.BaseException", 3, 1), true);
            }
            this.d_writer.generateInclude("sidl_String.h", false);
            this.d_writer.printlnUnformatted("#include <stddef.h>");
            this.d_writer.println();
            Cxx.beginExternCRegion(this.d_writer);
            this.writeSkelFunctions();
            this.writeLoad();
            this.writeConstructor();
            this.writeDestructor();
            if (IOR.supportAssertions(this.d_ext)) {
                if (this.d_ext.hasStaticMethod(true)) {
                    this.writeCheckError(true);
                }
                this.writeCheckError(false);
            }
            this.writeInitializeEPV();
            if (this.d_ext.hasStaticMethod(true)) {
                this.writeInitializeSEPV();
            }
            Cxx.endExternCRegion(this.d_writer);
            Object var4_3 = null;
            if (this.d_writer == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
        this.d_writer.close();
        this.d_writer = null;
    }

    private void writeInitializeEPV() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(IOR.getSetEPVName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getEPVName(id));
        this.d_writer.println(" *epv) {");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("initialize builtin methods");
        this.initializeMethodPointer(IOR.getBuiltinMethod(3, id), id);
        this.initializeMethodPointer(IOR.getBuiltinMethod(4, id), id);
        if (IOR.supportAssertions(this.d_ext)) {
            this.initializeMethodPointer(IOR.getBuiltinMethod(8, id), id);
        }
        this.d_writer.writeCommentLine("initialize local methods");
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.initializeMethodPointer(m, id);
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeInitializeSEPV() throws CodeGenerationException {
        String epv = "sepv";
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(IOR.getSetSEPVName(id) + "(" + IOR.getSEPVName(id));
        this.d_writer.println(" *sepv) {");
        this.d_writer.tab();
        if (IOR.supportAssertions(this.d_ext)) {
            this.writeMethodAssignment("sepv", IOR.getVectorEntry(IOR.getBuiltinName(8, true)), Cxx.getMethodSkelName(id, IOR.getBuiltinMethod(8, id, true)));
        }
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!m.isStatic()) continue;
            String name = m.getLongMethodName();
            String skelName = Cxx.getMethodSkelName(id, name);
            if (IOR.supportInterceptors(this.d_ext) && !IOR.isBuiltinMethod(name, true)) {
                this.writeMethodAssignment("sepv", IOR.getVectorEntry(name + "_pre"), skelName + "_pre");
                this.writeMethodAssignment("sepv", IOR.getVectorEntry(name), skelName);
                this.writeMethodAssignment("sepv", IOR.getVectorEntry(name + "_post"), skelName + "_post");
                continue;
            }
            this.writeMethodAssignment("sepv", IOR.getVectorEntry(name), skelName);
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeMethodAssignment(String var, String mname, String value) {
        this.d_writer.println(var + "->" + mname + " = " + value + ";");
    }

    private void initializeMethodPointer(Method m, SymbolID id) {
        String methodName = m.getLongMethodName();
        switch (m.getDefinitionModifier()) {
            case 0: 
            case 2: {
                this.d_writer.print("epv->");
                this.d_writer.print(IOR.getVectorEntry(methodName));
                this.d_writer.print(" = ");
                this.d_writer.print(Cxx.getMethodSkelName(id, methodName));
                this.d_writer.println(";");
                break;
            }
            case 1: {
                this.d_writer.print("epv->");
                this.d_writer.print(IOR.getVectorEntry(methodName));
                this.d_writer.println(" = NULL;");
                break;
            }
        }
    }

    private void writeConstructor() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("static void");
        this.d_writer.print(Cxx.getMethodSkelName(id, "_ctor"));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println("* self ) { ");
        this.d_writer.tab();
        this.d_writer.print("self->d_data = ");
        this.d_writer.print(Cxx.reinterpretCast("void*", "new " + Cxx.getSymbolName(id, "impl") + "(self)"));
        this.d_writer.println(";");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeLoad() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(IOR.getSymbolName(id) + "__call_load");
        this.d_writer.print("(void) {");
        this.d_writer.tab();
        this.d_writer.print(Cxx.getSymbolName(id, "impl") + "::_load();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeDestructor() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("static void");
        this.d_writer.print(Cxx.getMethodSkelName(id, "_dtor"));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println("* self ) { ");
        this.d_writer.tab();
        this.d_writer.print("delete ( ");
        this.d_writer.print(Cxx.reinterpretCast(Cxx.getSymbolName(id, "impl") + "*", "self->d_data"));
        this.d_writer.println(" );");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeCheckError(boolean doStatic) throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        if (doStatic) {
            this.d_writer.print("static ");
        }
        this.d_writer.print("void ");
        this.d_writer.print(Cxx.getMethodSkelName(id, IOR.getBuiltinMethod(8, id, doStatic)));
        this.d_writer.print("(");
        if (!doStatic) {
            this.d_writer.println();
            this.d_writer.print(IOR.getObjectName(id));
            this.d_writer.print("* self, ");
        }
        this.d_writer.print("/* in */ const char* msg ");
        this.d_writer.println(") { ");
        this.d_writer.tab();
        this.d_writer.print(Cxx.getSymbolName(this.d_ext.getSymbolID(), "impl"));
        this.d_writer.print("*_this = ");
        this.d_writer.print(Cxx.reinterpretCast(Cxx.getSymbolName(this.d_ext.getSymbolID(), "impl") + "*", "self->d_data"));
        this.d_writer.println(";");
        this.d_writer.println("::std::string _local_msg = ( msg ? msg: \"\" );");
        this.d_writer.println(" _this->" + IOR.getBuiltinName(8, doStatic) + " ( /* in */ _local_msg ); ");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeGetDataPointer() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.print(C.getDataName(id));
        this.d_writer.println("*");
        this.d_writer.print(C.getDataGetName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println(" *self) {");
        this.d_writer.tab();
        this.d_writer.println("return self ? self->d_data : NULL;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeSetDataPointer() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(C.getDataSetName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println(" *self,");
        this.d_writer.tab();
        this.d_writer.print(C.getDataName(id));
        this.d_writer.println(" *data) {");
        this.d_writer.println("if (self) {");
        this.d_writer.tab();
        this.d_writer.println("self->d_data = data;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeSkelFunctions() throws CodeGenerationException {
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.writeImplDispatch(m);
        }
    }

    private void writeImplDispatch(Method m) throws CodeGenerationException {
        Argument arg;
        String nm = "CxxSkelSource.writeImplDispatch: ";
        ArrayList vArgs = m.getArgumentList();
        ArrayList callArgs = m.getArgumentListWithIndices();
        int nargs = vArgs.size();
        boolean throwsExceptions = m.getThrows().size() > 0;
        StringBuffer func_decl = new StringBuffer(nargs * 32);
        StringBuffer pre_impl = new StringBuffer(nargs * 128);
        StringBuffer impl_call = new StringBuffer(nargs * 32);
        StringBuffer impl_suffix = new StringBuffer(16);
        StringBuffer post_impl = new StringBuffer(nargs * 128);
        String shortMethodName = m.getShortMethodName();
        String longMethodName = m.getLongMethodName();
        String className = this.d_ext.getSymbolID().getShortName();
        if (shortMethodName.equals(className)) {
            shortMethodName = "f_" + shortMethodName;
            System.out.println("WARNING: gov.llnl.babel.backend.Cxx.CxxSkelSource: sidl / C++ conflict!");
            System.out.println("         methodName == className is not allowed in C++");
            System.out.println("         (this is restricted to constructors in C++)");
            System.out.println("         changing to " + className + "::" + shortMethodName + "()");
        }
        func_decl.append("static ");
        Type return_type = m.getReturnType();
        func_decl.append(IOR.getReturnString(return_type, true, false) + " ");
        if (return_type.getType() != 0) {
            pre_impl.append(IOR.getReturnString(return_type, true, false));
            pre_impl.append(" _result");
            if (return_type.getDetailedType() != 11) {
                if (return_type.getDetailedType() == 5 || return_type.getDetailedType() == 3) {
                    pre_impl.append(" = {0,0}");
                } else {
                    pre_impl.append(" = 0");
                }
            }
            pre_impl.append(";\n");
        }
        switch (return_type.getDetailedType()) {
            case 0: {
                break;
            }
            case 9: {
                impl_call.append("_result = ");
                break;
            }
            case 1: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("_result = ( _local_result ? TRUE : FALSE );\n");
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                impl_call.append("_result = ");
                break;
            }
            case 11: {
                pre_impl.append(Cxx.getEnumName(return_type.getSymbolID()) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("_result = (" + IOR.getEnumName(return_type.getSymbolID()) + ")_local_result;\n");
                break;
            }
            case 5: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("_result.real = _local_result.real();\n");
                post_impl.append("_result.imaginary = _local_result.imag();\n");
                break;
            }
            case 3: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("_result.real = _local_result.real();\n");
                post_impl.append("_result.imaginary = _local_result.imag();\n");
                break;
            }
            case 10: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("_result = sidl_String_strdup( _local_result.c_str() );\n");
                break;
            }
            case 15: {
                throw new CodeGenerationException("CxxSkelSource.writeImplDispatch: Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE.");
            }
            case 12: 
            case 13: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("if ( _local_result._not_nil() ) {\n");
                post_impl.append("  _local_result.addRef();\n");
                post_impl.append("}\n");
                post_impl.append("_result = _local_result._get_ior();\n");
                break;
            }
            case 16: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("if ( _local_result._not_nil() ) {\n");
                if (return_type.hasArrayOrderSpec()) {
                    post_impl.append("  _local_result.ensure(" + return_type.getArrayDimension() + ", " + s_ensureOrderConstant[return_type.getArrayOrder()] + ");\n");
                }
                post_impl.append("  _local_result.addRef();\n");
                post_impl.append("}\n");
                post_impl.append("_result = " + Cxx.getIORCall("_local_result", return_type) + ";\n");
                break;
            }
        }
        func_decl.append(Cxx.getMethodSkelName(this.d_ext.getSymbolID(), longMethodName));
        func_decl.append("( ");
        if (m.isStatic()) {
            impl_call.append(Cxx.getMethodImplName(this.d_ext.getSymbolID(), shortMethodName));
        } else {
            func_decl.append("\n");
            func_decl.append(IOR.getObjectName(this.d_ext.getSymbolID()) + "* self");
            if (nargs > 0) {
                func_decl.append(", ");
            }
            pre_impl.append(Cxx.getSymbolName(this.d_ext.getSymbolID(), "impl"));
            pre_impl.append(" *_this = ");
            pre_impl.append(Cxx.reinterpretCast(Cxx.getSymbolName(this.d_ext.getSymbolID(), "impl") + "*", "self->d_data"));
            pre_impl.append(";\n");
            impl_call.append("_this->" + shortMethodName);
        }
        impl_call.append("( ");
        Iterator it = vArgs.iterator();
        while (it.hasNext()) {
            arg = (Argument)it.next();
            String mode = Cxx.getArgModeComment(arg);
            String argName = arg.getFormalName();
            func_decl.append(mode);
            func_decl.append(IOR.getArgumentString(arg, true, false, false) + " " + argName);
            if (!it.hasNext()) continue;
            func_decl.append(",\n");
        }
        it = callArgs.iterator();
        while (it.hasNext()) {
            arg = (Argument)it.next();
            Type type = arg.getType();
            int typeInt = type.getDetailedType();
            String argName = arg.getFormalName();
            String mode = Cxx.getArgModeComment(arg);
            int modeInt = arg.getMode();
            impl_call.append(mode);
            block13 : switch (typeInt) {
                case 9: {
                    switch (modeInt) {
                        case 0: {
                            impl_call.append(argName);
                            break;
                        }
                        case 1: 
                        case 2: {
                            impl_call.append("*" + argName);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append("bool _local_" + argName + " = (" + argName + "==TRUE);\n");
                            impl_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_impl.append("bool _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("*" + argName + " = (_local_" + argName + " ? TRUE : FALSE);\n");
                            break;
                        }
                        case 1: {
                            pre_impl.append("bool _local_" + argName + " = (*" + argName + "==TRUE);\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("*" + argName + " = (_local_" + argName + " ? TRUE : FALSE);\n");
                        }
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    switch (modeInt) {
                        case 0: {
                            impl_call.append(argName);
                            break;
                        }
                        case 1: 
                        case 2: {
                            impl_call.append("*" + argName);
                        }
                    }
                    break;
                }
                case 11: {
                    switch (modeInt) {
                        case 0: {
                            impl_call.append("(" + Cxx.getEnumName(type.getSymbolID()) + "&)" + argName);
                            break;
                        }
                        case 1: 
                        case 2: {
                            impl_call.append("(" + Cxx.getEnumName(type.getSymbolID()) + "&)*" + argName);
                        }
                    }
                    break;
                }
                case 5: {
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + " ( " + argName + ".real, " + argName + ".imaginary );\n");
                            impl_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append(argName + "->real = _local_" + argName + ".real();\n" + argName + "->imaginary = _local_" + argName + ".imag();\n");
                            break;
                        }
                        case 1: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + " ( " + argName + "->real, " + argName + "->imaginary );\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append(argName + "->real = _local_" + argName + ".real();\n" + argName + "->imaginary = _local_" + argName + ".imag();\n");
                        }
                    }
                    break;
                }
                case 3: {
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + " ( " + argName + ".real, " + argName + ".imaginary );\n");
                            impl_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append(argName + "->real = _local_" + argName + ".real();\n" + argName + "->imaginary = _local_" + argName + ".imag();\n");
                            break;
                        }
                        case 1: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + " ( " + argName + "->real, " + argName + "->imaginary );\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append(argName + "->real = _local_" + argName + ".real();\n" + argName + "->imaginary = _local_" + argName + ".imag();\n");
                        }
                    }
                    break;
                }
                case 10: {
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "= ( " + argName + " ? " + argName + ": \"\" );\n");
                            impl_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("*" + argName + " = sidl_String_strdup( _local_" + argName + ".c_str() );\n");
                            break;
                        }
                        case 1: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "= ( *" + argName + " ? *" + argName + ": \"\" );\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("if ( *" + argName + "== 0) {\n");
                            post_impl.append("  *" + argName + " = sidl_String_strdup( _local_" + argName + ".c_str() );\n");
                            post_impl.append("} else if ( strlen( *" + argName + " ) >= _local_" + argName + ".length() ) {\n");
                            post_impl.append("  _local_" + argName + ".copy( *" + argName + ", ::std::string::npos );\n");
                            post_impl.append("  (*" + argName + ")[ _local_" + argName + ".length()] = 0;\n");
                            post_impl.append("} else { \n");
                            post_impl.append("  sidl_String_free( *" + argName + ");\n");
                            post_impl.append("  *" + argName + " = sidl_String_strdup( _local_" + argName + ".c_str() );\n");
                            post_impl.append("}");
                        }
                    }
                    break;
                }
                case 15: {
                    throw new CodeGenerationException("CxxSkelSource.writeImplDispatch: Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE.");
                }
                case 12: 
                case 13: {
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "(" + argName + ");\n");
                            impl_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("if ( _local_" + argName + "._not_nil() ) {\n");
                            post_impl.append("  _local_" + argName + ".addRef();\n");
                            post_impl.append("}\n");
                            post_impl.append("*" + argName + " = _local_" + argName + "._get_ior();\n");
                            break;
                        }
                        case 1: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "((*" + argName + "));\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("if ( _local_" + argName + "._not_nil() ) {\n");
                            post_impl.append("  _local_" + argName + ".addRef();\n");
                            post_impl.append("}\n");
                            post_impl.append("if (*" + argName + ") (*((*" + argName + ")->d_epv->f_deleteRef))((*" + argName + (typeInt == 13 ? ")->d_object);\n" : "));\n"));
                            post_impl.append("*" + argName + " = _local_" + argName + "._get_ior();\n");
                        }
                    }
                    break;
                }
                case 16: {
                    if (arg.getType().isRarray()) {
                        String r_name = arg.getFormalName();
                        Type arrayType = type.getArrayType();
                        pre_impl.append(IOR.getReturnString(arg.getType(), false, false) + " _local_" + arg.getFormalName());
                        if (modeInt == 0) {
                            pre_impl.append(" = " + C.getEnsureArray(arg.getType().getArrayType()) + "(" + arg.getFormalName() + ", " + arg.getType().getArrayDimension() + ", " + s_ensureOrderConstant[arg.getType().getArrayOrder()] + ");\n");
                        } else {
                            pre_impl.append(" = " + C.getEnsureArray(arg.getType().getArrayType()) + "(*" + arg.getFormalName() + ", " + arg.getType().getArrayDimension() + ", " + s_ensureOrderConstant[arg.getType().getArrayOrder()] + ");\n");
                            String init_func_name = IOR.getArrayNameForFunctions(type.getArrayType().getType()) + "_init";
                            post_impl.append(init_func_name + "(" + r_name + "_tmp" + ", *" + r_name + ", " + arg.getType().getArrayDimension() + ", (*" + r_name + ")->d_metadata.d_lower, (*" + r_name + ")->d_metadata.d_upper, (*" + r_name + ")->d_metadata.d_stride);\n");
                        }
                        pre_impl.append(IOR.getArgumentWithFormal(arg, false, true, false) + "_tmp" + " = ");
                        pre_impl.append("_local_" + argName + "->d_firstElement;\n");
                        impl_call.append(argName + "_tmp");
                        break;
                    }
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "(" + argName + ");\n");
                            pre_impl.append("if (" + argName + ") { ");
                            pre_impl.append("_local_" + argName + ".addRef();");
                            if (type.hasArrayOrderSpec()) {
                                pre_impl.append("_local_" + argName + ".ensure(" + type.getArrayDimension() + ", " + s_ensureOrderConstant[type.getArrayOrder()] + ");\n");
                            }
                            pre_impl.append(" }\n");
                            impl_call.append("_local_" + argName);
                            break block13;
                        }
                        case 2: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("if ( _local_" + argName + "._not_nil() ) {\n");
                            if (type.hasArrayOrderSpec()) {
                                post_impl.append("  _local_" + argName + ".ensure(" + type.getArrayDimension() + ", " + s_ensureOrderConstant[type.getArrayOrder()] + ");\n");
                            }
                            post_impl.append("  _local_" + argName + ".addRef();\n");
                            post_impl.append("}\n");
                            post_impl.append("*" + argName + " = " + Cxx.getIORCall("_local_" + argName, type) + ";\n");
                            break block13;
                        }
                        case 1: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "(*" + argName + ");\n");
                            pre_impl.append("*" + argName + " = 0;\n");
                            if (type.hasArrayOrderSpec()) {
                                pre_impl.append("_local_" + argName + ".ensure(" + type.getArrayDimension() + ", " + s_ensureOrderConstant[type.getArrayOrder()] + ");\n");
                            }
                            impl_call.append("_local_" + argName);
                            post_impl.append("if ( _local_" + argName + "._not_nil() ) {\n");
                            if (type.hasArrayOrderSpec()) {
                                post_impl.append("  _local_" + argName + ".ensure(" + type.getArrayDimension() + ", " + s_ensureOrderConstant[type.getArrayOrder()] + ");\n");
                            }
                            post_impl.append("_local_" + argName + ".addRef();\n");
                            post_impl.append("}\n");
                            post_impl.append("*" + argName + " = " + Cxx.getIORCall("_local_" + argName, type) + ";\n");
                        }
                    }
                }
            }
            if (!it.hasNext()) continue;
            impl_call.append(", ");
        }
        HashMap index_args = m.getRarrayInfo();
        Iterator i = index_args.values().iterator();
        while (i.hasNext()) {
            Collection index_collection = (Collection)i.next();
            Iterator tmp = index_collection.iterator();
            Method.RarrayInfo info = (Method.RarrayInfo)tmp.next();
            Argument index = info.index;
            Argument rarray = info.rarray;
            Type arrayType = rarray.getType().getArrayType();
            int dim = info.dim;
            if (index.getType().getType() == 8) {
                pre_impl.append("int64_t ");
            } else {
                pre_impl.append("int32_t ");
            }
            pre_impl.append(index.getFormalName() + " = sidlLength(");
            pre_impl.append("_local_" + info.rarray.getFormalName() + "," + dim + ");\n");
        }
        if (throwsExceptions) {
            if (nargs > 0 || !m.isStatic()) {
                func_decl.append(", ");
            }
            pre_impl.append("*_exception = 0;//init just to be safe\n");
            func_decl.append("sidl_BaseInterface__object ** _exception");
        }
        func_decl.append(" )\n");
        impl_call.append(" )" + impl_suffix.toString() + ";\n");
        this.d_writer.println(func_decl.toString().trim());
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("pack args to dispatch to impl");
        this.d_writer.println(pre_impl.toString().trim());
        this.d_writer.writeCommentLine("dispatch to impl");
        if (throwsExceptions) {
            this.d_writer.println("try { ");
            this.d_writer.tab();
        }
        this.d_writer.println(impl_call.toString().trim());
        if (throwsExceptions) {
            this.d_writer.backTab();
            this.d_writer.println("} catch ( ::sidl::StubBase& _sb ) { ");
            this.d_writer.tab();
            this.d_writer.println("::sidl::BaseInterface _ex(_sb);");
            this.d_writer.println("_ex.addRef();");
            this.d_writer.println("*_exception = _ex._get_ior();");
            if (return_type.getType() != 0) {
                this.d_writer.println("return _result;");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.writeCommentLine("unpack results and cleanup");
        this.d_writer.println(post_impl.toString().trim());
        if (return_type.getType() != 0) {
            this.d_writer.println("return _result;");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }
}

