/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.ior;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.SortComparator;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.ior.IORSource;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IORHeader {
    private static final String SIDL_EXCEPTION_INTERFACE = BabelConfiguration.getBaseExceptionInterface();
    private LanguageWriterForC d_writer;

    public static void generateCode(Symbol symbol, LanguageWriterForC writer) throws CodeGenerationException {
        IORHeader header = new IORHeader(writer);
        header.generateCode(symbol);
    }

    public IORHeader(LanguageWriterForC writer) {
        this.d_writer = writer;
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        if (symbol != null) {
            switch (symbol.getSymbolType()) {
                case 12: 
                case 13: {
                    this.generateExtendable((Extendable)symbol);
                    break;
                }
                case 11: {
                    this.generateEnumeration((Enumeration)symbol);
                    break;
                }
                case 14: {
                    this.generatePackage((Package)symbol);
                }
            }
        }
    }

    private void generateEnumeration(Enumeration enm) {
        SymbolID id = enm.getSymbolID();
        String header = IOR.getHeaderFile(id);
        this.d_writer.writeBanner(enm, header, false, "Intermediate Object Representation for " + id.getFullName());
        this.d_writer.openHeaderGuard(header);
        this.d_writer.generateInclude("sidlType.h", true);
        this.d_writer.openCxxExtern();
        this.d_writer.writeComment(enm, false);
        this.d_writer.println();
        this.d_writer.writeCommentLine("Opaque forward declaration of array struct");
        this.d_writer.println(IOR.getArrayName(id) + ";");
        this.d_writer.println();
        this.d_writer.print(IOR.getEnumName(id));
        this.d_writer.println(" {");
        this.d_writer.tab();
        int maxlength = Utilities.getWidth(enm.getEnumerators());
        String namespace = id.getFullName().replace('.', '_') + "_";
        maxlength += namespace.length();
        Iterator e = enm.getIterator();
        while (e.hasNext()) {
            String name = (String)e.next();
            Comment cmt = enm.getEnumeratorComment(name);
            this.d_writer.writeComment(cmt, true);
            this.d_writer.printAligned(namespace + name, maxlength);
            this.d_writer.print(" = ");
            this.d_writer.print(String.valueOf(enm.getEnumeratorValue(name)));
            if (e.hasNext()) {
                this.d_writer.print(",");
            }
            this.d_writer.println();
            if (cmt == null) continue;
            this.d_writer.println();
        }
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
        this.d_writer.closeCxxExtern();
        this.d_writer.closeHeaderGuard();
    }

    private void generateExtendable(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        String header = IOR.getHeaderFile(id);
        this.d_writer.writeBanner(ext, header, false, "Intermediate Object Representation for " + id.getFullName());
        this.d_writer.openHeaderGuard(header);
        Set defined = this.generateIncludes(ext);
        this.d_writer.openCxxExtern();
        this.generateExportedSymbols(ext);
        defined.add(id);
        this.generateForwardDeclarations(ext, defined);
        if (!ext.isInterface()) {
            this.generateMethodDescData(ext);
        }
        if (ext.hasStaticMethod(true)) {
            this.generateEPV(ext, true);
        }
        this.generateEPV(ext, false);
        if (ext.isInterface()) {
            this.generateInterfaceObject((Interface)ext);
        } else {
            this.generateControls(ext);
            this.generateClassObject((Class)ext);
            this.generateExternalStruct(ext);
            IORSource.generateExternalSignature(this.d_writer, ext, ";");
            this.d_writer.println();
        }
        this.d_writer.closeCxxExtern();
        this.d_writer.closeHeaderGuard();
    }

    private void generatePackage(Package p) {
        SymbolID id = p.getSymbolID();
        String header = IOR.getHeaderFile(id);
        this.d_writer.writeBanner(p, header, false, "Intermediate Object Representation for " + id.getFullName());
        this.d_writer.openHeaderGuard(header);
        this.d_writer.writeComment(p, false);
        ArrayList entries = Utilities.sort(p.getSymbols().keySet());
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            String include = IOR.getHeaderFile((SymbolID)i.next());
            this.d_writer.generateInclude(include, true);
        }
        this.d_writer.println();
        this.d_writer.closeHeaderGuard();
    }

    private void generateExternalStruct(Symbol sym) {
        if (sym instanceof Class) {
            Class parent;
            Class cls = (Class)sym;
            SymbolID id = sym.getSymbolID();
            String symbolType = IOR.getSymbolType(sym);
            int maxDim = BabelConfiguration.getMaximumArray();
            this.d_writer.println(IOR.getExternalName(id) + " {");
            this.d_writer.tab();
            if (!cls.isAbstract()) {
                this.d_writer.println(symbolType);
                this.d_writer.println("(*createObject)(void);");
                this.d_writer.println();
            }
            if (cls.hasStaticMethod(true)) {
                this.d_writer.println(IOR.getSEPVName(id) + "*");
                this.d_writer.println("(*getStaticEPV)(void);");
            }
            if (cls.getParentClass() != null && (parent = cls.getParentClass()) != null) {
                SymbolID pid = parent.getSymbolID();
                this.d_writer.print(IOR.getEPVName(pid) + "*");
                this.d_writer.println("(*getSuperEPV)(void);");
            }
            this.d_writer.backTab();
            this.d_writer.println("};");
            this.d_writer.println();
        }
    }

    private Set generateIncludes(Extendable ext) throws CodeGenerationException {
        Set dependencies;
        HashSet<SymbolID> includes = new HashSet<SymbolID>();
        if (!ext.isInterface()) {
            Class cls = (Class)ext;
            includes.addAll(Utilities.getUniqueInterfaceIDs(cls));
            Class parent = cls.getParentClass();
            if (parent != null) {
                includes.add(parent.getSymbolID());
            }
        }
        if ((dependencies = ext.getSymbolReferences()) != null && !dependencies.isEmpty()) {
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                Symbol symbol = Utilities.lookupSymbol(id);
                if (symbol.getSymbolType() != 11) continue;
                includes.add(id);
            }
        }
        this.d_writer.generateInclude("sidl_header.h", true);
        this.d_writer.generateInclude(C.getHeaderFile(Utilities.lookupSymbol("sidl.io.Serializer").getSymbolID()), true);
        this.d_writer.generateInclude(C.getHeaderFile(Utilities.lookupSymbol("sidl.io.Deserializer").getSymbolID()), true);
        if (IOR.supportAssertions(ext) && !ext.isInterface()) {
            this.d_writer.generateInclude("sidlAsserts.h", true);
            if (IOR.ASSERTION_LEVEL != "2") {
                this.d_writer.print("//");
            }
            this.d_writer.println("#define SIDL_FULL_ASTATS");
            this.d_writer.println("//#define SIDL_TEXT_ASTATS");
            this.d_writer.generateInclude("stdlib.h", true);
            this.d_writer.generateInclude("math.h", true);
        }
        if (!includes.isEmpty()) {
            ArrayList entries = Utilities.sort(includes);
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                String header = IOR.getHeaderFile((SymbolID)i.next());
                this.d_writer.generateInclude(header, true);
            }
            this.d_writer.println();
        }
        return includes;
    }

    private void generateExportedSymbols(Extendable ext) {
        SymbolID id = ext.getSymbolID();
        String type = IOR.getObjectName(id);
        String sepv = IOR.getSEPVName(id);
        this.d_writer.writeComment(ext, false);
        this.d_writer.println(IOR.getArrayName(id) + ";");
        this.d_writer.println(type + ";");
        if (ext.hasStaticMethod(true)) {
            this.d_writer.println(sepv + ";");
        }
        this.d_writer.println();
        if (!ext.isAbstract()) {
            this.d_writer.println("extern " + type + "*");
            this.d_writer.println(IOR.getNewName(id) + "(void);");
            this.d_writer.println();
        }
        boolean doStaticTypes = false;
        if (ext.hasStaticMethod(true)) {
            this.d_writer.println("extern " + sepv + "*");
            this.d_writer.println(IOR.getStaticsName(id) + "(void);");
            if (IOR.supportAssertions(ext) || IOR.supportInterceptors(ext)) {
                this.d_writer.println();
                this.d_writer.println("extern " + sepv + "*");
                this.d_writer.println(IOR.getLocalStaticsName(id) + "(int type);");
                doStaticTypes = true;
            }
            this.d_writer.println();
        }
        if (!ext.isInterface()) {
            this.d_writer.println("extern void " + IOR.getInitName(id) + "(");
            this.d_writer.tab();
            this.d_writer.println(type + "* self);");
            this.d_writer.backTab();
            this.d_writer.println("extern void " + IOR.getFiniName(id) + "(");
            this.d_writer.tab();
            this.d_writer.println(type + "* self);");
            this.d_writer.backTab();
            this.d_writer.println("extern void " + IOR.getVersionName(id) + "(int32_t *" + "major, int32_t *minor);");
            this.d_writer.println();
        }
        if (doStaticTypes) {
            this.d_writer.writeComment("Define static structure options.", false);
            this.d_writer.println("static const int " + IOR.getStaticTypeOption(id, 0) + " = 0;");
            int i = 1;
            if (IOR.supportAssertions(ext)) {
                this.d_writer.println("static const int " + IOR.getStaticTypeOption(id, 1) + " = " + i + ";");
                ++i;
            }
            if (IOR.supportInterceptors(ext)) {
                this.d_writer.println("static const int " + IOR.getStaticTypeOption(id, 2) + " = " + i + ";");
            }
            this.d_writer.println();
        }
    }

    private void generateForwardDeclarations(Extendable ext, Set defined) throws CodeGenerationException {
        HashSet<SymbolID> references = new HashSet<SymbolID>();
        Iterator i = ext.getMethods(true).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            references.addAll(method.getSymbolReferences());
            if (method.getThrows().isEmpty()) continue;
            Symbol symbol = Utilities.lookupSymbol(SIDL_EXCEPTION_INTERFACE);
            references.add(symbol.getSymbolID());
        }
        references.removeAll(defined);
        if (!references.isEmpty()) {
            HashSet<SymbolID> declare = new HashSet<SymbolID>();
            Iterator i2 = references.iterator();
            while (i2.hasNext()) {
                SymbolID id = (SymbolID)i2.next();
                Symbol symbol = Utilities.lookupSymbol(id);
                int type = symbol.getSymbolType();
                if (type == 14) continue;
                declare.add(id);
            }
            if (!declare.isEmpty()) {
                this.d_writer.writeComment("Forward references for external classes and interfaces.", false);
                ArrayList entries = Utilities.sort(declare);
                Iterator i3 = entries.iterator();
                while (i3.hasNext()) {
                    SymbolID id = (SymbolID)i3.next();
                    Symbol symbol = Utilities.lookupSymbol(id);
                    int type = symbol.getSymbolType();
                    this.d_writer.println(IOR.getArrayName(id) + ";");
                    if (type == 11) continue;
                    this.d_writer.println(IOR.getObjectName(id) + ";");
                }
                this.d_writer.println();
            }
        }
    }

    private void generateEPVEntry(Method m, String self, String suffix) throws CodeGenerationException {
        if (suffix.equals("")) {
            this.d_writer.print(IOR.getReturnString(m.getReturnType(), true, false));
        } else {
            this.d_writer.print("void");
        }
        this.d_writer.print(" (*");
        this.d_writer.print(IOR.getVectorEntry(m.getLongMethodName()) + suffix);
        this.d_writer.println(")(");
        this.d_writer.tab();
        boolean has_throws = !m.getThrows().isEmpty() && suffix.equals("");
        ArrayList args = m.getArgumentList();
        C.generateArguments(this.d_writer, self, (List)args, m.isStatic(), has_throws, suffix.equals("_post") ? m.getReturnType() : null, true, true, false);
        this.d_writer.println(");");
        this.d_writer.backTab();
    }

    private void generateEPVMethod(Method m, String self, boolean addHooks, Set alreadySeen) throws CodeGenerationException {
        String name = m.getLongMethodName();
        if (!alreadySeen.contains(name)) {
            alreadySeen.add(name);
            if (addHooks) {
                this.generateEPVEntry(m, self, "_pre");
                this.generateEPVEntry(m, self, "");
                this.generateEPVEntry(m, self, "_post");
            } else {
                this.generateEPVEntry(m, self, "");
            }
        }
    }

    private void generateLocalEntries(Extendable ext, String self, boolean doStatic, boolean addHooks, Set methodsAlreadySeen) throws CodeGenerationException {
        this.d_writer.writeCommentLine("Methods introduced in " + ext.getSymbolID().getSymbolName());
        Iterator m = null;
        m = doStatic ? ext.getStaticMethods(false).iterator() : ext.getNonstaticMethods(false).iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            this.generateEPVMethod(method, self, addHooks, methodsAlreadySeen);
        }
    }

    private void generateBuiltinEntries(Extendable ext, String self, boolean doStatic, Set alreadySeen) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        int numBuiltins = ext.isInterface() ? 3 : 10;
        boolean doAsserts = IOR.supportAssertions(ext);
        boolean doIceptors = IOR.supportInterceptors(ext);
        this.d_writer.writeCommentLine("Implicit builtin methods");
        if (doStatic) {
            for (int i = 0; i < numBuiltins; ++i) {
                if (!IOR.hasStaticBuiltin(i) || (!IOR.isBuiltinAssert(i) || !IOR.supportAssertions(ext)) && (i != 7 || !IOR.supportInterceptors(ext))) continue;
                Method b = IOR.getBuiltinMethod(i, id, doStatic);
                this.generateEPVMethod(b, self, false, alreadySeen);
            }
        } else {
            for (int i = 0; i < numBuiltins; ++i) {
                if (!IOR.isBuiltinBasic(i) && (!IOR.isBuiltinAssert(i) || !IOR.supportAssertions(ext)) && (i != 7 || !IOR.supportInterceptors(ext))) continue;
                Method b = IOR.getBuiltinMethod(i, id, doStatic);
                this.generateEPVMethod(b, self, false, alreadySeen);
            }
        }
    }

    private void generateParentEntries(Extendable ext, String self, boolean doStatic, boolean addHooks, Set methodsAlreadySeen, Set extAlreadySeen) throws CodeGenerationException {
        if (ext instanceof Class) {
            this.generateEPVEntries(((Class)ext).getParentClass(), self, doStatic, addHooks, methodsAlreadySeen, extAlreadySeen);
        }
        Object[] parents = ext.getParentInterfaces(false).toArray();
        Arrays.sort(parents, new SortComparator());
        for (int i = 0; i < parents.length; ++i) {
            this.generateEPVEntries((Extendable)parents[i], self, doStatic, addHooks, methodsAlreadySeen, extAlreadySeen);
        }
    }

    private static final boolean isBaseClass(Extendable ext) {
        return ext instanceof Class && ((Class)ext).getParentClass() == null;
    }

    private static final boolean hasParents(Extendable ext) {
        return !IORHeader.isBaseClass(ext) || !ext.getParentInterfaces(false).isEmpty();
    }

    private void generateEPVEntries(Extendable ext, String self, boolean doStatic, boolean addHooks, Set methodsAlreadySeen, Set extAlreadySeen) throws CodeGenerationException {
        if (ext != null && !extAlreadySeen.contains(ext)) {
            if (IORHeader.hasParents(ext)) {
                this.generateParentEntries(ext, self, doStatic, addHooks, methodsAlreadySeen, extAlreadySeen);
            }
            this.generateLocalEntries(ext, self, doStatic, addHooks, methodsAlreadySeen);
            extAlreadySeen.add(ext);
        }
    }

    private void generateMethodDescData(Extendable ext) {
        if (IOR.supportAssertions(ext)) {
            Method method;
            this.d_writer.writeComment("Define method description data for assertion control", false);
            int num = 0;
            SymbolID id = ext.getSymbolID();
            List methods = (List)ext.getMethods(true);
            String typeDecl = "static const int32_t ";
            String minName = IOR.getMethodIndex(id, "MIN");
            int width = Utilities.getWidth(methods) + typeDecl.length() + (minName.length() - 3);
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                method = (Method)i.next();
                this.d_writer.printAligned(typeDecl + IOR.getMethodIndex(id, method), width);
                this.d_writer.println(" = " + num + ";");
                ++num;
            }
            this.d_writer.printAligned(typeDecl + minName, width);
            this.d_writer.println(" = 0;");
            this.d_writer.printAligned(typeDecl + IOR.getMethodIndex(id, "MAX"), width);
            this.d_writer.println(" = " + (num - 1) + ";");
            this.d_writer.println();
            this.d_writer.println("static const " + IOR.getMethodDescDataStruct(id) + " {");
            this.d_writer.tab();
            this.d_writer.println("char* name;");
            this.d_writer.println("int   isStatic;");
            this.d_writer.backTab();
            this.d_writer.println("} " + IOR.getMethodDescDataName(id) + "[] = {");
            this.d_writer.tab();
            i = methods.iterator();
            while (i.hasNext()) {
                method = (Method)i.next();
                String val = method.isStatic() ? "1" : "0";
                this.d_writer.println("{\"" + method.getLongMethodName() + "\", " + val + "},");
            }
            this.d_writer.backTab();
            this.d_writer.println("};");
            this.d_writer.println();
        }
    }

    private void generateEPV(Extendable ext, boolean doStatic) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        String self = null;
        if (!doStatic) {
            self = ext.isInterface() ? "void* self" : IOR.getObjectName(id) + "* self";
        }
        String desc = doStatic ? "static " : "";
        this.d_writer.writeComment("Declare the " + desc + "method entry point vector.", false);
        if (doStatic) {
            this.d_writer.print(IOR.getSEPVName(id));
        } else {
            this.d_writer.print(IOR.getEPVName(id));
        }
        this.d_writer.println(" {");
        this.d_writer.tab();
        HashSet methodsAlreadySeen = new HashSet();
        HashSet extAlreadySeen = new HashSet();
        this.generateBuiltinEntries(ext, self, doStatic, methodsAlreadySeen);
        this.generateEPVEntries(ext, self, doStatic, IOR.supportInterceptors(ext), methodsAlreadySeen, extAlreadySeen);
        methodsAlreadySeen = null;
        extAlreadySeen = null;
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
    }

    private void generateInterfaceObject(Interface ifc) {
        SymbolID id = ifc.getSymbolID();
        String type = IOR.getObjectName(id);
        this.d_writer.writeComment("Define the interface object structure.", false);
        this.d_writer.println(type + " {");
        this.d_writer.tab();
        String epv = IOR.getEPVName(id);
        int width = epv.length() + 2;
        this.d_writer.printAligned(epv + "* ", width);
        this.d_writer.println(IOR.getEPVVar(0) + ";");
        this.d_writer.printAligned("void*", width);
        this.d_writer.println("d_object;");
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
    }

    private void generateControls(Extendable ext) {
        boolean doAsserts = IOR.supportAssertions(ext);
        boolean doIceptors = IOR.supportInterceptors(ext);
        if (doAsserts || doIceptors) {
            this.d_writer.writeComment("Define the controls structure.", false);
            SymbolID id = ext.getSymbolID();
            int num = ext.getNumberOfMethods(true);
            this.d_writer.println();
            this.d_writer.println(IOR.getControlsStruct(id) + " {");
            this.d_writer.tab();
            if (doAsserts) {
                this.d_writer.println("int32_t checking_level;");
                this.d_writer.println("double  check_rate;");
                this.d_writer.println(IOR.getMethodControlsStruct(id) + " {");
                this.d_writer.printlnUnformatted("#ifdef SIDL_FULL_ASTATS");
                this.d_writer.tab();
                this.d_writer.println("int32_t calls;");
                this.d_writer.println("int32_t countdown;");
                this.d_writer.println("int32_t method_exceptions;");
                this.d_writer.println("int32_t successes;");
                this.d_writer.println("int32_t tries;");
                this.d_writer.printlnUnformatted("#else /* !SIDL_FULL_ASTATS */");
                this.d_writer.println("int32_t countdown;");
                this.d_writer.printlnUnformatted("#endif /* SIDL_FULL_ASTATS */");
                this.d_writer.backTab();
                this.d_writer.println("} method_controls[" + num + "];");
            }
            if (doIceptors) {
                this.d_writer.println("int     use_iceptors;");
            }
            this.d_writer.backTab();
            this.d_writer.println("};");
        }
    }

    private void generateControlsStats(SymbolID id, int num, boolean doAsserts, boolean doIceptors, boolean all) {
    }

    private void generateClassObject(Class cls) {
        this.d_writer.writeComment("Define the class object structure.", false);
        ArrayList unique = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
        int width = Utilities.getWidth(unique) + "struct __object".length();
        Class parent = cls.getParentClass();
        SymbolID pid = null;
        String ptype = null;
        if (parent != null && (ptype = IOR.getObjectName(pid = parent.getSymbolID())).length() > width) {
            width = ptype.length();
        }
        boolean addAsserts = IOR.supportAssertions(cls);
        boolean addIceptors = IOR.supportInterceptors(cls);
        String ctrls = null;
        SymbolID id = cls.getSymbolID();
        String epv = IOR.getEPVName(id) + "*";
        int len = epv.length();
        if (len > width) {
            width = len;
        }
        if ((addAsserts || addIceptors) && (len = (ctrls = IOR.getControlsStruct(id)).length()) > width) {
            width = len;
        }
        ++width;
        this.d_writer.println(IOR.getObjectName(id) + " {");
        this.d_writer.tab();
        if (parent != null) {
            this.d_writer.printAligned(ptype, width);
            this.d_writer.println("d_" + IOR.getSymbolName(pid).toLowerCase() + ";");
        }
        Iterator i = unique.iterator();
        while (i.hasNext()) {
            SymbolID sid = (SymbolID)i.next();
            this.d_writer.printAligned(IOR.getObjectName(sid), width);
            this.d_writer.println("d_" + IOR.getSymbolName(sid).toLowerCase() + ";");
        }
        this.d_writer.printAligned(epv, width);
        this.d_writer.println(IOR.getEPVVar(0) + ";");
        if (IOR.supportBaseEPVAttr(cls)) {
            this.d_writer.printAligned(epv, width);
            this.d_writer.println(IOR.getEPVVar(1) + ";");
        }
        if (addAsserts || addIceptors) {
            this.d_writer.printAligned(ctrls, width);
            this.d_writer.println("d_controls;");
        }
        this.d_writer.printAligned("void*", width);
        this.d_writer.println("d_data;");
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
    }
}

