/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.ior;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.rmi.RMIIORSource;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Assertion;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.MethodCall;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IORSource {
    private static int s_longestBuiltin;
    private static final String s_castBuiltin;
    private static final String s_deleteBuiltin;
    private static final String s_execBuiltin;
    private static final String s_self = "self";
    private static final String s_exception_var = "_ex";
    private static final String s_superBuiltin = "_super";
    private static final int ASSERT_DECLARE = 1;
    private static final int ASSERT_RAISE = 2;
    SymbolID d_baseClass = null;
    SymbolID d_classInfo = null;
    SymbolID d_classInfoI = null;
    private LanguageWriterForC d_writer;

    public static void generateCode(Symbol symbol, LanguageWriterForC writer) throws CodeGenerationException {
        IORSource source = new IORSource(writer);
        source.generateCode(symbol);
    }

    public IORSource(LanguageWriterForC writer) {
        this.d_writer = writer;
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        if (symbol != null) {
            switch (symbol.getSymbolType()) {
                case 13: 
                case 14: {
                    break;
                }
                case 12: {
                    this.generateSource((Class)symbol);
                }
            }
        }
    }

    private void lookupSymbolIDs() {
        SymbolTable table = SymbolTable.getInstance();
        this.d_baseClass = table.lookupSymbol(BabelConfiguration.getBaseClass()).getSymbolID();
        this.d_classInfo = table.lookupSymbol(BabelConfiguration.getClassInfo()).getSymbolID();
        this.d_classInfoI = table.lookupSymbol(BabelConfiguration.getClassInfoI()).getSymbolID();
    }

    private void generateSource(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        Object baseClass = null;
        Object classInfo = null;
        Object classInfoI = null;
        String source = IOR.getSourceFile(id);
        String header = IOR.getHeaderFile(id);
        this.d_writer.writeBanner(cls, source, false, "Intermediate Object Representation for " + id.getFullName());
        this.d_writer.printlnUnformatted("#include <stdlib.h>");
        this.d_writer.printlnUnformatted("#include <stddef.h>");
        this.d_writer.printlnUnformatted("#include <string.h>");
        if (IOR.supportAssertions(cls)) {
            this.d_writer.printlnUnformatted("#include <stdio.h>");
            this.d_writer.printlnUnformatted("#include <sys/time.h>");
            this.d_writer.printlnUnformatted("#include <time.h>");
            this.d_writer.printlnUnformatted("#include \"sidlAsserts.h\"");
            this.d_writer.printlnUnformatted("#include \"sidlAssertUtils.h\"");
            if (IOR.ASSERTION_LEVEL != "2") {
                this.d_writer.print("//");
            }
            this.d_writer.println("#define SIDL_FULL_ASTATS");
            this.d_writer.println("#define SIDL_TEXT_ASTATS");
            this.d_writer.println();
        }
        this.d_writer.generateInclude(header, false);
        this.lookupSymbolIDs();
        this.d_writer.generateInclude(C.getImplHeaderFile(this.d_baseClass), true);
        this.d_writer.generateInclude(C.getHeaderFile(this.d_baseClass), true);
        this.d_writer.generateInclude(C.getHeaderFile(this.d_classInfo), true);
        this.d_writer.generateInclude(C.getHeaderFile(this.d_classInfoI), true);
        this.d_writer.println();
        this.d_writer.printlnUnformatted("#ifndef NULL");
        this.d_writer.printlnUnformatted("#define NULL 0");
        this.d_writer.printlnUnformatted("#endif");
        this.d_writer.println();
        String my_mutex = IOR.getSymbolName(id) + "__mutex";
        String lock_name = IOR.getLockStaticGlobalsMacroName();
        String unlock_name = IOR.getUnlockStaticGlobalsMacroName();
        String have_lock = IOR.getHaveLockStaticGlobalsMacroName();
        this.d_writer.printlnUnformatted("#include \"sidl_thread.h\"");
        this.d_writer.printlnUnformatted("#ifdef HAVE_PTHREAD");
        this.d_writer.printlnUnformatted("static struct sidl_recursive_mutex_t " + my_mutex + "= SIDL_RECURSIVE_MUTEX_INITIALIZER;");
        this.d_writer.printlnUnformatted("#define " + lock_name + " sidl_recursive_mutex_lock( &" + my_mutex + " )");
        this.d_writer.printlnUnformatted("#define " + unlock_name + " sidl_recursive_mutex_unlock( &" + my_mutex + " )");
        this.d_writer.printlnUnformatted("/* #define " + have_lock + " (sidl_recursive_mutex_trylock( &" + my_mutex + " )==EDEADLOCK) */");
        this.d_writer.printlnUnformatted("#else");
        this.d_writer.printlnUnformatted("#define " + lock_name);
        this.d_writer.printlnUnformatted("#define " + unlock_name);
        this.d_writer.printlnUnformatted("/* #define " + have_lock + " (1) */");
        this.d_writer.printlnUnformatted("#endif");
        this.d_writer.println();
        this.generateStaticVariables(cls);
        this.generateExternalReferences(cls);
        boolean doStatic = cls.hasStaticMethod(true);
        boolean doAsserts = IOR.supportAssertions(cls);
        boolean doIceptors = IOR.supportInterceptors(cls);
        RMIIORSource.generateCode(cls, this.d_writer);
        this.generateEnsureLoad(cls);
        this.generateCastFunction(cls);
        if (doAsserts) {
            if (doStatic) {
                this.generateChecksFunction(cls, true);
                this.generateDumpStatsFunction(cls, true);
            }
            this.generateChecksFunction(cls, false);
            this.generateDumpStatsFunction(cls, false);
            this.generateAllChecks(cls);
        }
        if (doIceptors) {
            if (doStatic) {
                this.generateInterceptorFunction(cls, true);
            }
            this.generateInterceptorFunction(cls, false);
            this.generateAllInterceptors(cls);
        }
        this.generateDeleteFunction(cls);
        this.generateMainExec(cls);
        this.generateInitEPV(cls);
        this.generateInitSEPV(cls);
        this.generateStaticFunction(cls, false);
        this.generateSuperFunction(cls);
        if (doAsserts || doIceptors) {
            this.generateStaticFunction(cls, true);
        }
        this.generateInitClassInfo(cls);
        this.generateInitMetadata(cls);
        this.generateNewFunction(cls);
        this.generateInitFunction(cls);
        this.generateFiniFunction(cls);
        this.generateVersionFunction(cls);
        this.generateExternalFunc(cls);
    }

    private void comment(String s) {
        this.d_writer.writeComment(s, false);
    }

    private void generateStaticVariables(Class cls) {
        this.comment("Static variables to hold version of IOR");
        this.d_writer.println("static const int32_t s_IOR_MAJOR_VERSION = 0;");
        this.d_writer.println("static const int32_t s_IOR_MINOR_VERSION = 9;");
        this.d_writer.println();
        if (!cls.isAbstract()) {
            this.comment("Static variable to hold shared ClassInfo interface.");
            this.d_writer.println("static " + C.getObjectName(this.d_classInfo) + " s_classInfo = " + "NULL" + ";");
            this.d_writer.println("static int s_classInfo_init = 1;");
            this.d_writer.println();
        }
        this.comment("Static variable to make sure _load called no more than once");
        this.d_writer.println("static int s_load_called = 0;");
        this.comment("Static variables for managing EPV initialization.");
        boolean has_static = cls.hasStaticMethod(true);
        boolean doAsserts = IOR.supportAssertions(cls);
        boolean doIceptors = IOR.supportInterceptors(cls);
        this.d_writer.println("static int s_method_initialized = 0;");
        if (has_static) {
            this.d_writer.println("static int s_static_initialized = 0;");
        }
        this.d_writer.println();
        IOR.generateStaticEPVVariables(this.d_writer, cls, has_static, false, 0);
        if (doAsserts) {
            IOR.generateStaticEPVVariables(this.d_writer, cls, has_static, false, 1);
        }
        if (doIceptors) {
            IOR.generateStaticEPVVariables(this.d_writer, cls, has_static, false, 2);
        }
        Set parents = Utilities.getAllParents(cls);
        Set new_interfaces = Utilities.getUniqueInterfaceIDs(cls);
        if (!parents.isEmpty()) {
            ArrayList sorted = Utilities.sort(parents);
            Iterator i = sorted.iterator();
            while (i.hasNext()) {
                SymbolID p_id = (SymbolID)i.next();
                String p_name = IOR.getSymbolName(p_id);
                String p_lower = p_name.toLowerCase();
                String p_epv = "static " + IOR.getEPVName(p_id);
                boolean is_old = !new_interfaces.contains(p_id);
                String p_epvStr = is_old ? p_epv + "  " : p_epv + " ";
                this.d_writer.print(p_epvStr);
                this.d_writer.println(IOR.getStaticEPVVariable(p_id, 0, 0) + ";");
                if (is_old) {
                    this.d_writer.print(p_epv + "* ");
                    this.d_writer.println(IOR.getStaticEPVVariable(p_id, 1, 0) + ";");
                }
                this.d_writer.println();
            }
        }
        if (has_static && (doAsserts || doIceptors)) {
            this.comment("Static variables for assertion and/or interceptor controls.");
            String asCtrls = "static " + IOR.getControlsStruct(cls.getSymbolID());
            int asWidth = asCtrls.length() + 1;
            this.d_writer.printAligned(asCtrls, asWidth);
            this.d_writer.println("s_control_stats;");
            this.d_writer.println();
        }
        if (doAsserts) {
            this.comment("Static file for assertion statistics.");
            this.d_writer.println("static FILE* s_dump_fptr = NULL;");
            this.d_writer.println();
        }
    }

    private void generateExternalReferences(Class cls) {
        this.comment("Declare EPV routines defined in the skeleton file.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.openCxxExtern();
        this.d_writer.println("extern void " + IOR.getSetEPVName(id) + "(");
        this.d_writer.tab();
        this.d_writer.println(IOR.getEPVName(id) + "* epv);");
        this.d_writer.backTab();
        if (cls.hasStaticMethod(true)) {
            this.d_writer.println("extern void " + IOR.getSetSEPVName(id) + "(");
            this.d_writer.tab();
            this.d_writer.println(IOR.getSEPVName(id) + "* sepv);");
            this.d_writer.backTab();
        }
        this.d_writer.println("extern void " + IOR.getCallLoadName(id) + "(void);");
        this.d_writer.closeCxxExtern();
        this.d_writer.println();
    }

    private void generateCastFunction(Class cls) {
        this.comment("CAST: dynamic type casting support.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("static void* " + this.getIORMethodName(id, s_castBuiltin) + '(');
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* " + s_self + ",");
        this.d_writer.println("const char* name)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("void* cast = NULL;");
        this.d_writer.println();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        this.generateCastLogic(cls, 0);
        this.d_writer.println();
        this.d_writer.println("return cast;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateCastLogic(Class cls, int level) {
        String self = "s" + String.valueOf(level);
        if (level > 0) {
            this.d_writer.print("} else ");
        }
        this.d_writer.println("if (!strcmp(name, \"" + cls.getFullName() + "\")) {");
        this.d_writer.tab();
        this.d_writer.println("cast = (void*) " + self + ";");
        this.d_writer.backTab();
        ArrayList interfaces = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
        Iterator i = interfaces.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            String fn = id.getFullName();
            String lower = IOR.getSymbolName(id).toLowerCase();
            this.d_writer.println("} else if (!strcmp(name, \"" + fn + "\")) {");
            this.d_writer.tab();
            this.d_writer.println("cast = (void*) &" + self + "->d_" + lower + ";");
            this.d_writer.backTab();
        }
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.generateCastLogic(parent, level + 1);
        } else {
            this.d_writer.println("}");
        }
    }

    private String getBaseControls(boolean doStatic, String self) {
        return doStatic ? "s_control_stats" : self + "->" + "d_controls";
    }

    private String getBaseMethodControls(String base, String indexVar) {
        return base + "method_controls" + "[" + indexVar + "]";
    }

    private String getBaseMethodControls(boolean doStatic, String self, String indexVar) {
        return this.getBaseMethodControls(this.getBaseControls(doStatic, self), indexVar);
    }

    private void generateStatisticsUpdate(String ctrlBase, String methBase, String aOkay, String mOkay, String methTime, String totalTime) {
        this.d_writer.printlnUnformatted("#ifdef SIDL_FULL_ASTATS");
        if (mOkay.equals("0")) {
            this.d_writer.println(methBase + "method_exceptions" + " += 1;");
        } else if (mOkay.equals("mOkay")) {
            this.d_writer.println(methBase + "tries" + " += 1;");
            this.d_writer.println("SIDL_INCR_IF_TRUE(!" + mOkay + "," + methBase + "method_exceptions" + ")");
            this.d_writer.println("SIDL_INCR_IF_TRUE(" + aOkay + "," + methBase + "successes" + ")");
        }
        this.d_writer.printlnUnformatted("#endif /* SIDL_FULL_ASTATS */");
        this.d_writer.println("SIDL_SET_COUNTDOWN(" + ctrlBase + "checking_level" + ",");
        this.d_writer.tab();
        this.d_writer.println(ctrlBase + "check_rate" + ", " + methBase + "countdown" + ", " + aOkay + ", " + mOkay + ", ");
        this.d_writer.println("" + methTime + ", " + totalTime + ")");
        this.d_writer.backTab();
    }

    private String getIORMethodName(SymbolID id, String name) {
        return "ior_" + IOR.getSymbolName(id) + '_' + name;
    }

    private String getSetChecksMethodName(SymbolID id, boolean doStatic) {
        return this.getIORMethodName(id, IOR.getBuiltinName(6, doStatic));
    }

    private void generateChecksFunction(Extendable ext, boolean doStatic) {
        String desc = doStatic ? "static " : "";
        this.comment("CHECKS: set the " + desc + "assertion checking level.");
        SymbolID id = ext.getSymbolID();
        String name = IOR.getSymbolName(id);
        boolean doAsserts = IOR.supportAssertions(ext);
        boolean doBoth = doAsserts && IOR.supportInterceptors(ext);
        this.d_writer.println("static void " + this.getSetChecksMethodName(id, doStatic) + '(');
        this.d_writer.tab();
        if (!doStatic) {
            this.d_writer.println(IOR.getObjectName(id) + "* " + s_self + ",");
        }
        this.d_writer.println("int32_t level,");
        this.d_writer.println("double  rate,");
        this.d_writer.println("int32_t resetCounters)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        if (doAsserts) {
            String base = this.getBaseControls(doStatic, s_self) + ".";
            String mBase = "mc->";
            this.d_writer.println(IOR.getMethodControlsStruct(id) + " *mc;");
            if (!doStatic) {
                this.d_writer.println("int checkAsserts = CHECK_ASSERTIONS & level;");
            }
            this.d_writer.println(base + "checking_level" + "  = level;");
            this.d_writer.println(base + "check_rate" + " = rate;");
            this.d_writer.println();
            this.d_writer.println("if (resetCounters) {");
            this.d_writer.tab();
            this.d_writer.println("int i;");
            this.d_writer.println("for (i =" + IOR.getMethodIndex(id, "MIN") + ";");
            this.d_writer.println("     i<=" + IOR.getMethodIndex(id, "MAX") + "; i++)" + " {");
            this.d_writer.tab();
            this.d_writer.println("mc = &" + this.getBaseMethodControls(base, "i") + ";");
            this.d_writer.printlnUnformatted("#ifdef SIDL_FULL_ASTATS");
            this.d_writer.println(mBase + "calls" + "             = 0;");
            this.d_writer.println(mBase + "method_exceptions" + " = 0;");
            this.d_writer.println(mBase + "tries" + "             = 0;");
            this.d_writer.println(mBase + "successes" + "         = 0;");
            this.d_writer.println(mBase + "countdown" + "         = 0;");
            this.d_writer.printlnUnformatted("#else /* !SIDL_FULL_ASTATS */");
            this.d_writer.println(mBase + "countdown" + "         = 0;");
            this.d_writer.printlnUnformatted("#endif /* SIDL_FULL_ASTATS */");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            if (!doStatic) {
                this.d_writer.println();
                this.d_writer.println("/* Ensure the EPVs are set properly. */");
            }
        }
        if (!doStatic) {
            String publicepv = "self->" + IOR.getEPVVar(0);
            if (doBoth) {
                String baseepv = "self->" + IOR.getEPVVar(1);
                String use = this.getBaseControls(false, s_self) + "." + "use_iceptors";
                this.d_writer.println("if (checkAsserts && (" + use + ")) {");
                this.d_writer.tab();
                this.d_writer.println(publicepv + "  = &" + IOR.getStaticEPVVariable(id, 0, 1) + ";");
                this.d_writer.println(baseepv + " = &" + IOR.getStaticEPVVariable(id, 0, 2) + ";");
                this.d_writer.backTab();
                this.d_writer.println("} else if (checkAsserts) {");
                this.d_writer.tab();
                this.d_writer.println(publicepv + "  = &" + IOR.getStaticEPVVariable(id, 0, 1) + ";");
                this.d_writer.println(baseepv + " = &" + IOR.getStaticEPVVariable(id, 0, 0) + ";");
                this.d_writer.backTab();
                this.d_writer.println("} else if (" + use + ") {");
                this.d_writer.tab();
                this.d_writer.println(publicepv + "  = &" + IOR.getStaticEPVVariable(id, 0, 2) + ";");
                this.d_writer.println(baseepv + " = &" + IOR.getStaticEPVVariable(id, 0, 0) + ";");
                this.d_writer.backTab();
                this.d_writer.println("} else {");
                this.d_writer.tab();
                this.d_writer.println(publicepv + "  = &" + IOR.getStaticEPVVariable(id, 0, 0) + ";");
                this.d_writer.println(baseepv + " = &" + IOR.getStaticEPVVariable(id, 0, 0) + ";");
                this.d_writer.backTab();
                this.d_writer.println("}");
            } else if (doAsserts) {
                this.d_writer.println("if (checkAsserts) {");
                this.d_writer.tab();
                this.d_writer.println(publicepv + " = &" + IOR.getStaticEPVVariable(id, 0, 1) + ";");
                this.d_writer.backTab();
                this.d_writer.println("} else {");
                this.d_writer.tab();
                this.d_writer.println(publicepv + " = &" + IOR.getStaticEPVVariable(id, 0, 0) + ";");
                this.d_writer.backTab();
                this.d_writer.println("}");
            } else {
                this.comment("Nothing to do since assertion support not needed.");
            }
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private String getDumpStatsMethodName(SymbolID id, boolean doStatic) {
        return this.getIORMethodName(id, IOR.getBuiltinName(9, doStatic));
    }

    private void generateDumpStatsFunction(Extendable ext, boolean doStatic) {
        String desc = doStatic ? "static " : "";
        this.comment("DUMP: Dump the " + desc + "assertion statistics.");
        SymbolID id = ext.getSymbolID();
        String name = IOR.getSymbolName(id);
        boolean doAsserts = IOR.supportAssertions(ext);
        boolean doIceptors = IOR.supportInterceptors(ext);
        this.d_writer.println("static void " + this.getDumpStatsMethodName(id, doStatic) + '(');
        this.d_writer.tab();
        if (!doStatic) {
            this.d_writer.println(IOR.getObjectName(id) + "* " + s_self + ",");
        }
        this.d_writer.println("const char* filename)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        if (doAsserts) {
            String base = this.getBaseControls(doStatic, s_self) + ".";
            String mBase = "mc->";
            this.d_writer.println(IOR.getMethodControlsStruct(id) + " *mc;");
            this.d_writer.println("time_t currTime = time(NULL);");
            this.d_writer.println("int    level    = " + base + "checking_level" + ";");
            this.d_writer.printlnUnformatted("#ifdef SIDL_TEXT_ASTATS");
            this.d_writer.println("char*  desc     = sidl_getCheckDescription(level);");
            this.d_writer.printlnUnformatted("#else /* !SIDL_TEXT_ASTATS */");
            this.d_writer.println("char*  desc     = sidl_getCheckFrequencyDesc(level);");
            this.d_writer.printlnUnformatted("#endif /* SIDL_TEXT_ASTATS */");
            this.d_writer.println("int    i;");
            this.d_writer.println();
            this.d_writer.println("if (s_dump_fptr == NULL) {");
            this.d_writer.tab();
            this.d_writer.println("if ((s_dump_fptr=fopen(filename,\"w\")) == NULL) {");
            this.d_writer.tab();
            this.d_writer.println("printf(\"Cannot open file %s to dump the " + desc + "assertion statistics.\\n\", filename);");
            this.d_writer.println("return;");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.printlnUnformatted("#ifdef SIDL_TEXT_ASTATS");
            this.d_writer.println("fprintf(s_dump_fptr, \"" + desc.toUpperCase() + "ASSERTION CONTROL AND STATISTICS AT %s\\n\"," + " ctime(&currTime));");
            this.d_writer.println("fprintf(s_dump_fptr, \"Checking Level      = %d (%s)\\n\", level, desc);");
            this.d_writer.println("fprintf(s_dump_fptr, \"Checking Threshold  = %f\\n\", " + base + "check_rate" + ");");
            if (doIceptors) {
                this.d_writer.println("fprintf(s_dump_fptr, \"Interceptor Support = %s\\n\", (" + base + "use_iceptors" + " ? \"on\" : \"off\"));");
            }
            this.d_writer.printlnUnformatted("#ifdef SIDL_FULL_ASTATS");
            this.d_writer.print("fprintf(s_dump_fptr, \"\\n%26s  \\t%s (%s (%s), %s)  \\t%s (%s, %s)\\n\",");
            this.d_writer.println("\"Method          \", \"Calls\", \"Chkd\", \"OK\", \"MExcs\", \"Cd\", \"Meth\", \"Total\");");
            this.d_writer.printlnUnformatted("#else /* !SIDL_FULL_ASTATS */");
            this.d_writer.print("fprintf(s_dump_fptr, \"\\n%26s  \\t%s\\n\",");
            this.d_writer.println("\"Method          \", \"Cd\");");
            this.d_writer.printlnUnformatted("#endif /* SIDL_FULL_ASTATS */");
            this.d_writer.printlnUnformatted("#endif /* SIDL_TEXT_ASTATS */");
            this.d_writer.println("for (i =" + IOR.getMethodIndex(id, "MIN") + ";");
            this.d_writer.println("     i<=" + IOR.getMethodIndex(id, "MAX") + "; i++)" + " {");
            this.d_writer.tab();
            this.d_writer.println("mc = &" + this.getBaseMethodControls(base, "i") + ";");
            this.d_writer.print("if (  (");
            if (!doStatic) {
                this.d_writer.print("!");
            }
            this.d_writer.println(IOR.getMethodDescDataName(id) + "[i].isStatic) ");
            this.d_writer.printlnUnformatted("#ifdef SIDL_FULL_ASTATS");
            this.d_writer.println("   && (" + mBase + "calls" + " > 0) ) {");
            this.d_writer.tab();
            this.d_writer.printlnUnformatted("#ifdef SIDL_TEXT_ASTATS");
            this.d_writer.println("fprintf(s_dump_fptr, \"%26s  \\t%5d (%d (%d), %d)  \\t\\t%2d\\n\",");
            this.d_writer.printlnUnformatted("#else /* !SIDL_TEXT_ASTATS */");
            this.d_writer.println("fprintf(s_dump_fptr, \"%s\\t%f\\t%s\\t%d\\t%d\\t%d\\t%d\\t%d\\n\",");
            this.d_writer.println("        desc,");
            this.d_writer.println("        " + base + "check_rate" + ",");
            this.d_writer.printlnUnformatted("#endif /* SIDL_TEXT_ASTATS */");
            this.d_writer.printlnUnformatted("#else /* !SIDL_FULL_ASTATS */");
            this.d_writer.backTab();
            this.d_writer.println("   && (" + mBase + "countdown" + " > 0) ) {");
            this.d_writer.tab();
            this.d_writer.printlnUnformatted("#ifdef SIDL_TEXT_ASTATS");
            this.d_writer.println("fprintf(s_dump_fptr, \"%26s  \\t%5d\\n\",");
            this.d_writer.printlnUnformatted("#else /* !SIDL_TEXT_ASTATS */");
            this.d_writer.println("fprintf(s_dump_fptr, \"%s\\t%f\\t%s\\t%d\\n\",");
            this.d_writer.println("        desc,");
            this.d_writer.println("        " + base + "check_rate" + ",");
            this.d_writer.printlnUnformatted("#endif /* SIDL_TEXT_ASTATS */");
            this.d_writer.printlnUnformatted("#endif /* SIDL_FULL_ASTATS */");
            this.d_writer.println("        " + IOR.getMethodDescDataName(id) + "[i].name,");
            this.d_writer.printlnUnformatted("#ifdef SIDL_FULL_ASTATS");
            this.d_writer.println("        " + mBase + "calls" + ",");
            this.d_writer.println("        " + mBase + "tries" + ",");
            this.d_writer.println("        " + mBase + "successes" + ",");
            this.d_writer.println("        " + mBase + "method_exceptions" + ",");
            this.d_writer.println("        " + mBase + "countdown" + ");");
            this.d_writer.printlnUnformatted("#else /* !SIDL_FULL_ASTATS */");
            this.d_writer.println("        " + mBase + "countdown" + ");");
            this.d_writer.printlnUnformatted("#endif /* SIDL_FULL_ASTATS */");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.printlnUnformatted("#ifdef SIDL_TEXT_ASTATS");
            this.d_writer.println("fprintf(s_dump_fptr, \"\\n\\n\");");
            this.d_writer.printlnUnformatted("#endif /* SIDL_TEXT_ASTATS */");
            this.d_writer.println("fflush(s_dump_fptr);");
            this.d_writer.println("free(desc);");
            this.d_writer.println("return;");
        } else {
            this.comment("Nothing to do since assertion support not needed.");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateAllChecks(Class cls) throws CodeGenerationException {
        ArrayList invariants = cls.getAllInvariants();
        List normal = (List)cls.getMethods(true);
        Iterator i = normal.iterator();
        Method meth = null;
        while (i.hasNext()) {
            meth = (Method)i.next();
            this.generateMethodChecks(cls, meth, invariants);
        }
    }

    private String getCheckMethodName(Extendable ext, Method meth) {
        return "check_" + IOR.getSymbolName(ext.getSymbolID()) + '_' + meth.getLongMethodName();
    }

    private void generateBaseCall(String name, String suffix, String var, List args, boolean isStatic, boolean doThrows, Type returnType) throws CodeGenerationException {
        boolean isOrig = suffix.equals("");
        if (isOrig && returnType != null && returnType.getType() != 0) {
            this.d_writer.print("_result = ");
        }
        this.d_writer.print("(" + var + "->");
        this.d_writer.println(IOR.getVectorEntry(name + suffix) + ")(");
        this.d_writer.tab();
        this.d_writer.tab();
        C.generateArguments(this.d_writer, s_self, args, isStatic, doThrows, suffix.equals("_post") ? returnType : null, false, false, false);
        this.d_writer.println(");");
        this.d_writer.backTab();
        this.d_writer.backTab();
    }

    private void generateMethodChecks(Class cls, Method m, ArrayList invariants) throws CodeGenerationException {
        String var;
        SymbolID id = cls.getSymbolID();
        String name = m.getLongMethodName();
        ArrayList preconditions = m.getPreconditions();
        ArrayList postconditions = m.getPostconditions();
        Object as = null;
        int numInv = invariants.size();
        int numPre = preconditions.size();
        int numPure = m.hasPureAssertion() ? 1 : 0;
        int numPost = postconditions.size() - numPure;
        int total = 2 * numInv + numPre + numPost;
        this.comment("Check relevant assertions, if any, before and after the method call.");
        String methname = this.getCheckMethodName(cls, m);
        Type type = m.getReturnType();
        boolean hasReturn = false;
        if (type != null && type.getType() != 0) {
            hasReturn = true;
        }
        this.d_writer.println("static " + IORSource.getReturnString(type) + " " + methname + '(');
        this.d_writer.tab();
        ArrayList args = m.getArgumentList();
        boolean hasThrows = !m.getThrows().isEmpty();
        boolean isStatic = m.isStatic();
        C.generateArguments(this.d_writer, IOR.getObjectName(id) + "* " + s_self, (List)args, isStatic, hasThrows, null, true, true, false);
        this.d_writer.println(")");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        if (hasReturn) {
            this.d_writer.println(IORSource.getReturnString(type) + " " + "_result" + ";");
        }
        if (!hasThrows && m.hasUnreservedMethodAssertion(false)) {
            this.d_writer.println(IOR.getExceptionFundamentalType() + "* " + s_exception_var + ";");
        }
        boolean addBlank = false;
        boolean doIceptors = IOR.supportInterceptors(cls);
        if (isStatic) {
            var = "sepv";
            if (doIceptors) {
                this.d_writer.println("int _type = " + this.getBaseControls(isStatic, "") + "." + "use_iceptors" + " ? " + IOR.getStaticTypeOption(id, 2) + " : " + IOR.getStaticTypeOption(id, 0) + ";");
                this.d_writer.println(IOR.getSEPVName(id) + "* " + var + " = " + IOR.getLocalStaticsName(id) + "(_type);");
            } else {
                this.d_writer.println(IOR.getSEPVName(id) + "* " + var + " = " + IOR.getLocalStaticsName(id) + "(" + IOR.getStaticTypeOption(id, 0) + ");");
            }
            addBlank = true;
        } else if (doIceptors) {
            var = "self->" + IOR.getEPVVar(1);
        } else {
            var = "epv";
            this.d_writer.println(IOR.getEPVName(id) + "* " + var + " = &" + IOR.getStaticEPVVariable(id, 0, 0) + ";");
            addBlank = true;
        }
        if (addBlank) {
            this.d_writer.println();
        }
        if (total > 0) {
            boolean doAssertEnd;
            String ctrlBase = this.getBaseControls(isStatic, s_self) + ".";
            String methIndex = IOR.getMethodIndex(id, m);
            String bvar = isStatic || doIceptors ? var : "self->" + IOR.getEPVVar(0);
            String excvar = hasThrows ? s_exception_var : "";
            String methBase = "mc->";
            this.d_writer.println("int aOkay    = 1;");
            this.d_writer.println("int mOkay    = 1;");
            this.d_writer.println("int doTiming = 0;");
            this.d_writer.println("struct timezone tz;");
            int totalMacros = 0;
            int maxMacros = m.getMaxArrayIterMacros(MethodCall.MACRO_RETURN_TYPE[0]);
            if (maxMacros > 0) {
                this.d_writer.println("int bres[" + maxMacros + "];");
                totalMacros += maxMacros;
            }
            if ((maxMacros = m.getMaxArrayIterMacros(MethodCall.MACRO_RETURN_TYPE[1])) > 0) {
                this.d_writer.println("double  dres[" + maxMacros + "];");
                totalMacros += maxMacros;
            } else {
                this.d_writer.println("double  dres;");
            }
            maxMacros = m.getMaxArrayIterMacros(MethodCall.MACRO_RETURN_TYPE[2]);
            if (maxMacros > 0) {
                this.d_writer.println("int32_t ires[" + maxMacros + "];");
                totalMacros += maxMacros;
            }
            if (totalMacros > 0) {
                this.d_writer.println("int32_t cnt, i, max;");
            }
            boolean doAssertBegin = numInv > 0 || numPre > 0;
            boolean bl = doAssertEnd = numInv > 0 || numPost > 0;
            if (doAssertBegin && doAssertEnd) {
                this.d_writer.println("struct timeval  aBegin, aEnd;");
            } else if (doAssertBegin) {
                this.d_writer.println("struct timeval  aBegin;");
            } else if (doAssertEnd) {
                this.d_writer.println("struct timeval  aEnd;");
            }
            this.d_writer.println("struct timeval  mBegin, mEnd;");
            this.d_writer.println("char*           errMsg;");
            if (numInv > 0) {
                this.generateAssertionViolation(1, 1, null, excvar);
            }
            if (numPre > 0) {
                this.generateAssertionViolation(2, 1, null, excvar);
            }
            if (numPost > 0) {
                this.generateAssertionViolation(4, 1, null, excvar);
            }
            this.d_writer.println();
            this.d_writer.println(IOR.getMethodControlsStruct(id) + " *mc = ");
            this.d_writer.tab();
            this.d_writer.println("&" + this.getBaseMethodControls(ctrlBase, methIndex) + ";");
            this.d_writer.backTab();
            this.d_writer.println("doTiming = (" + ctrlBase + "checking_level" + " & CHECK_TIMING) && (" + methBase + "countdown" + " >= 0);");
            if (hasThrows) {
                this.d_writer.println("(*_ex) = NULL;");
            }
            this.d_writer.printlnUnformatted("#ifdef SIDL_FULL_ASTATS");
            this.d_writer.println(methBase + "calls" + " += 1;");
            this.d_writer.printlnUnformatted("#endif /* SIDL_FULL_ASTATS */");
            this.d_writer.println();
            this.d_writer.println("if (" + methBase + "countdown" + " > 0) {");
            this.d_writer.tab();
            this.d_writer.println(methBase + "countdown" + " -= 1;");
            this.generateBaseCall(name, "", var, args, isStatic, hasThrows, type);
            if (hasThrows) {
                this.d_writer.println("if ((*_ex) != NULL) {");
                this.d_writer.tab();
                this.generateStatisticsUpdate(ctrlBase, methBase, "1", "0", "0", "0");
                this.d_writer.backTab();
                this.d_writer.println("}");
            }
            this.d_writer.backTab();
            this.d_writer.println("} else {");
            this.d_writer.tab();
            if (doAssertBegin) {
                this.d_writer.println("if (doTiming) { gettimeofday(&aBegin,&tz); }");
            }
            if (numPre > 0) {
                this.d_writer.println("if (" + ctrlBase + "checking_level" + " & CHECK_PRECONDITIONS) {");
                this.d_writer.tab();
                this.generateAssertionChecks(preconditions, bvar, isStatic, excvar);
                this.d_writer.backTab();
                this.d_writer.println("}");
            }
            if (numInv > 0) {
                this.d_writer.println("if (" + ctrlBase + "checking_level" + " & CHECK_INVARIANTS) {");
                this.d_writer.tab();
                this.generateAssertionChecks(invariants, bvar, isStatic, excvar);
                this.d_writer.backTab();
                this.d_writer.println("}");
            }
            this.d_writer.println("if (doTiming) { gettimeofday(&mBegin,&tz); }");
            if (hasThrows) {
                this.d_writer.println("if (aOkay) {");
                this.d_writer.tab();
            }
            this.generateBaseCall(name, "", var, args, isStatic, hasThrows, type);
            if (hasThrows) {
                this.d_writer.println("if ((*_ex) != NULL) {");
                this.d_writer.tab();
                this.d_writer.println("mOkay = 0;");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
            }
            if (doAssertEnd) {
                this.d_writer.println("if (doTiming) { gettimeofday(&mEnd,&tz); }");
            } else {
                this.d_writer.println("if (doTiming) {");
                this.d_writer.tab();
                this.d_writer.println("gettimeofday(&mEnd,&tz);");
            }
            if (numPost > 0) {
                this.d_writer.println("if (" + ctrlBase + "checking_level" + " & CHECK_POSTCONDITIONS) {");
                this.d_writer.tab();
                this.generateAssertionChecks(postconditions, bvar, isStatic, excvar);
                this.d_writer.backTab();
                this.d_writer.println("}");
            }
            if (numInv > 0) {
                this.d_writer.println("if (" + ctrlBase + "checking_level" + " & CHECK_INVARIANTS) {");
                this.d_writer.tab();
                this.generateAssertionChecks(invariants, bvar, isStatic, excvar);
                this.d_writer.backTab();
                this.d_writer.println("}");
            }
            if (doAssertEnd) {
                this.d_writer.println("if (doTiming) {");
                this.d_writer.tab();
                this.d_writer.println("gettimeofday(&aEnd,&tz);");
                this.d_writer.println();
            }
            String methodTime = "SIDL_DIFF_MICROSECONDS(mEnd,mBegin)";
            String timeMacroStart = "SIDL_DIFF_MICROSECONDS(";
            String assertTime = doAssertBegin && doAssertEnd ? timeMacroStart + "aEnd,aBegin)" : (doAssertBegin ? timeMacroStart + "mEnd,aBegin)" : (doAssertEnd ? timeMacroStart + "aEnd,mBegin)" : timeMacroStart + "mEnd,mBegin)"));
            this.generateStatisticsUpdate(ctrlBase, methBase, "aOkay", "mOkay", methodTime, assertTime);
            this.d_writer.backTab();
            this.d_writer.println("} else {");
            this.d_writer.tab();
            this.generateStatisticsUpdate(ctrlBase, methBase, "aOkay", "mOkay", "0", "0");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
        } else {
            this.generateBaseCall(name, "", var, args, isStatic, hasThrows, type);
        }
        if (hasReturn) {
            this.d_writer.println();
            this.d_writer.println("return _result;");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private static String getReturnString(Type type) throws CodeGenerationException {
        return IOR.getReturnString(type, true, false);
    }

    private int[] getNextStartInd(Assertion as, int[] startInd) {
        int[] nextStartInd = new int[3];
        for (int i = 0; i < 3; ++i) {
            nextStartInd[i] = startInd[i] + as.getNumArrayIterMacrosByType(MethodCall.MACRO_RETURN_TYPE[i]);
        }
        return nextStartInd;
    }

    private void generateAssertionChecks(ArrayList assertions, String var, boolean doStatic, String excvar) {
        if (!assertions.isEmpty()) {
            boolean first = true;
            Iterator i = assertions.iterator();
            int[] startInd = new int[3];
            for (int j = 0; j < 3; ++j) {
                startInd[j] = 0;
            }
            while (i.hasNext()) {
                Assertion as = (Assertion)i.next();
                String expr = as.cExpression(var, startInd);
                if (expr != null && !expr.equals("")) {
                    this.generateAssertion(as, var, startInd, doStatic, expr, excvar, first);
                    first = false;
                }
                startInd = this.getNextStartInd(as, startInd);
            }
        }
    }

    private void generateAssertion(Assertion as, String var, int[] startInd, boolean doStatic, String expr, String excvar, boolean first) {
        ArrayList mlist = as.getArrayIterMacros(var, startInd);
        int numIterMacros = mlist != null ? mlist.size() : 0;
        boolean extraIndent = false;
        if (!first) {
            if (numIterMacros <= 0) {
                this.d_writer.disableLineBreak();
                this.d_writer.println("else if (!" + expr + ") {");
                this.d_writer.enableLineBreak();
            } else {
                this.d_writer.println("if ( aOkay ) {");
                extraIndent = true;
                this.d_writer.tab();
                this.generateArrayIterMacros(mlist);
                this.d_writer.disableLineBreak();
                this.d_writer.println("if (!" + expr + ") {");
                this.d_writer.enableLineBreak();
            }
        } else {
            if (numIterMacros > 0) {
                this.generateArrayIterMacros(mlist);
            }
            this.d_writer.disableLineBreak();
            this.d_writer.println("if (!" + expr + ") {");
            this.d_writer.enableLineBreak();
        }
        this.d_writer.tab();
        this.d_writer.println("aOkay  = 0;");
        this.d_writer.disableLineBreak();
        this.d_writer.println("errMsg = \"" + as.errorMessage() + "\";");
        this.generateCheckErrorCall(as, var, doStatic);
        this.d_writer.enableLineBreak();
        if (!excvar.equals("")) {
            this.d_writer.println("if ((*" + excvar + ") == NULL) {");
            this.d_writer.tab();
            this.generateAssertionViolation(as.getType(), 2, as, excvar);
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        if (extraIndent) {
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateArrayIterMacros(ArrayList list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String mac = (String)i.next();
            this.d_writer.disableLineBreak();
            this.d_writer.println(mac);
            this.d_writer.enableLineBreak();
        }
    }

    private void generateAssertionViolation(int assertType, int genType, Assertion as, String excvar) {
        String prefix;
        String errType;
        String errStr;
        switch (assertType) {
            case 2: 
            case 3: {
                errStr = "pre_err";
                errType = IOR.getPreconditionExceptType();
                prefix = IOR.PRECONDITION_CALL_PREFIX;
                break;
            }
            case 4: 
            case 5: {
                errStr = "post_err";
                errType = IOR.getPostconditionExceptType();
                prefix = IOR.POSTCONDITION_CALL_PREFIX;
                break;
            }
            default: {
                errStr = "inv_err";
                errType = IOR.getInvariantExceptType();
                prefix = IOR.INVARIANT_CALL_PREFIX;
            }
        }
        if (genType == 1) {
            this.d_writer.println(errType + errStr + ";");
        } else {
            this.d_writer.println(errStr + " = " + prefix + "__create();");
            this.d_writer.println(prefix + "_setNote(" + errStr + ", errMsg);");
            this.d_writer.println("(*" + excvar + ") = " + IOR.FUND_EXCEPTION_CALL_PREFIX + "__cast(" + errStr + ");");
        }
    }

    private String getBuiltinErrorCheckFunctionPtr(boolean doStatic) {
        return IOR.getVectorEntry(IOR.getBuiltinName(8, doStatic));
    }

    private void generateCheckErrorCall(Assertion as, String var, boolean doStatic) {
        this.d_writer.print("(" + var + "->");
        this.d_writer.print(this.getBuiltinErrorCheckFunctionPtr(doStatic) + ")(");
        if (!doStatic) {
            this.d_writer.print("self, ");
        }
        this.d_writer.println("errMsg);");
    }

    private String getBuiltinInterceptorName(SymbolID id, boolean doStatic) {
        return this.getIORMethodName(id, IOR.getBuiltinName(7, doStatic));
    }

    private void generateInterceptorFunction(Class cls, boolean doStatic) {
        String desc = doStatic ? "static " : "";
        this.comment("INTERCEPTORS: set " + desc + "interceptor activation.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("static void " + this.getBuiltinInterceptorName(id, doStatic) + '(');
        this.d_writer.tab();
        if (!doStatic) {
            this.d_writer.println(IOR.getObjectName(id) + "* " + s_self + ",");
        }
        this.d_writer.println("int on)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        if (IOR.supportInterceptors(cls)) {
            String base = this.getBaseControls(doStatic, s_self) + ".";
            String use = base + "use_iceptors";
            this.d_writer.println(use + " = on;");
            if (!doStatic) {
                this.d_writer.println();
                this.d_writer.println("/* Ensure the EPVs are set properly. */");
                if (IOR.supportAssertions(cls)) {
                    String checks = base + "checking_level";
                    String rate = base + "check_rate";
                    this.d_writer.print(this.getSetChecksMethodName(id, doStatic) + "(");
                    this.d_writer.print("self, ");
                    this.d_writer.println(checks + ", " + rate + ", 0);");
                } else {
                    String publicepv = "self->" + IOR.getEPVVar(0);
                    this.d_writer.println("if (" + use + ") {");
                    this.d_writer.tab();
                    this.d_writer.println(publicepv + "  = &" + IOR.getStaticEPVVariable(id, 0, 2) + ";");
                    this.d_writer.backTab();
                    this.d_writer.println("} else {");
                    this.d_writer.tab();
                    this.d_writer.println(publicepv + "  = &" + IOR.getStaticEPVVariable(id, 0, 0) + ";");
                    this.d_writer.backTab();
                    this.d_writer.println("}");
                    this.d_writer.println("");
                }
            }
        } else {
            this.comment("Nothing to do since interceptor support not needed.");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private String getInterceptorMethodName(Extendable ext, Method meth) {
        return "iceptor_" + IOR.getSymbolName(ext.getSymbolID()) + '_' + meth.getLongMethodName();
    }

    private void generateAllInterceptors(Class cls) throws CodeGenerationException {
        ArrayList invariants = cls.getAllInvariants();
        List normal = (List)cls.getMethods(true);
        Iterator i = normal.iterator();
        Method meth = null;
        while (i.hasNext()) {
            meth = (Method)i.next();
            this.generateInterceptor(cls, meth);
        }
    }

    private void generateInterceptor(Class cls, Method meth) throws CodeGenerationException {
        String var;
        SymbolID id = cls.getSymbolID();
        String name = meth.getLongMethodName();
        String methname = this.getInterceptorMethodName(cls, meth);
        Type type = meth.getReturnType();
        String retStr = IORSource.getReturnString(type);
        boolean hasReturn = false;
        if (type != null && type.getType() != 0) {
            hasReturn = true;
        }
        this.comment("Sandwich the execution of the method between the pre- and post- calls.");
        this.d_writer.println("static " + retStr + " " + methname + "(");
        this.d_writer.tab();
        ArrayList args = meth.getArgumentList();
        boolean hasThrows = !meth.getThrows().isEmpty();
        boolean isStatic = meth.isStatic();
        C.generateArguments(this.d_writer, IOR.getObjectName(id) + "* " + s_self, (List)args, isStatic, hasThrows, null, true, true, false);
        this.d_writer.println(")");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        boolean addBlank = false;
        if (hasReturn) {
            this.d_writer.println(retStr + " " + "_result" + ";");
            addBlank = true;
        }
        if (isStatic) {
            var = "sepv";
            this.d_writer.println(IOR.getSEPVName(id) + "* " + var + " = " + IOR.getLocalStaticsName(id) + "(" + IOR.getStaticTypeOption(id, 0) + ");");
            addBlank = true;
        } else if (IOR.supportAssertions(cls)) {
            var = "self->" + IOR.getEPVVar(1);
        } else {
            var = "epv";
            this.d_writer.println(IOR.getEPVName(id) + "* " + var + " = &" + IOR.getStaticEPVVariable(id, 0, 0) + ";");
            addBlank = true;
        }
        if (addBlank) {
            this.d_writer.println();
        }
        this.generateBaseCall(name, "_pre", var, args, isStatic, false, null);
        this.generateBaseCall(name, "", var, args, isStatic, hasThrows, type);
        this.generateBaseCall(name, "_post", var, args, isStatic, false, type);
        if (hasReturn) {
            this.d_writer.println();
            this.d_writer.println("return _result;");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateDeleteFunction(Class cls) {
        this.comment("DELETE: call destructor and free object memory.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        this.d_writer.println("static void ior_" + name + '_' + s_deleteBuiltin + '(');
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* self)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println(IOR.getFiniName(id) + "(self);");
        this.d_writer.println("memset((void*)self, 0, sizeof(" + IOR.getObjectName(id) + "));");
        this.d_writer.println("free((void*) self);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateMainExec(Class cls) {
        SymbolID id = cls.getSymbolID();
        String my_symbolName = IOR.getSymbolName(id);
        this.d_writer.println("struct " + my_symbolName + "__method {");
        this.d_writer.tab();
        this.d_writer.println("const char *d_name;");
        this.d_writer.println("void (*d_func)(struct " + my_symbolName + "__object*,");
        this.d_writer.tab();
        this.d_writer.println("struct sidl_io_Deserializer__object *,");
        this.d_writer.println("struct sidl_io_Serializer__object *);");
        this.d_writer.backTab();
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
        this.d_writer.println("static void");
        this.d_writer.println("ior_" + my_symbolName + "__exec(");
        this.d_writer.println("    struct " + my_symbolName + "__object* self,");
        this.d_writer.println("    const char* methodName,");
        this.d_writer.println("    struct sidl_io_Deserializer__object* inArgs,");
        this.d_writer.println("    struct sidl_io_Serializer__object* outArgs ) { ");
        this.d_writer.tab();
        ArrayList methods = new ArrayList(cls.getMethods(true));
        Collections.sort(methods, new IOR.CompareMethods());
        this.d_writer.println("static const struct " + my_symbolName + "__method  s_methods[] = {");
        this.d_writer.tab();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            this.d_writer.println("{ \"" + m.getLongMethodName() + "\", " + my_symbolName + '_' + m.getLongMethodName() + "__exec }" + (i.hasNext() ? "," : ""));
        }
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println("int i, cmp, l = 0;");
        this.d_writer.println("int u = sizeof(s_methods)/sizeof(struct " + my_symbolName + "__method);");
        this.d_writer.println("if (methodName) {");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("Use binary search to locate method");
        this.d_writer.println("while (l < u) {");
        this.d_writer.tab();
        this.d_writer.println("i = (l + u) >> 1;");
        this.d_writer.println("if (!(cmp=strcmp(methodName, s_methods[i].d_name))) {");
        this.d_writer.tab();
        this.d_writer.println("(s_methods[i].d_func)(self, inArgs, outArgs);");
        this.d_writer.println("return;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("else if (cmp < 0) u = i;");
        this.d_writer.println("else l = i + 1;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeCommentLine("TODO: add code for method not found");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateSuperFunction(Class cls) {
        this.comment("SUPER: return's parent's non-overrided EPV");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        Class parent = cls.getParentClass();
        if (parent != null) {
            SymbolID pid = parent.getSymbolID();
            this.d_writer.println("static " + IOR.getEPVName(pid) + "* " + IOR.getSymbolName(id) + '_' + s_superBuiltin + "(void) {");
            this.d_writer.tab();
            this.d_writer.println("return " + IOR.getStaticEPVVariable(pid, 1, 0) + ";");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitEPV(Class cls) throws CodeGenerationException {
        this.comment("EPV: create method entry point vector (EPV) structure.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String object = IOR.getObjectName(id);
        this.d_writer.println("static void " + name + "__init_epv(");
        this.d_writer.tab();
        this.d_writer.println(object + "* " + s_self + ")");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.comment("assert( " + IOR.getHaveLockStaticGlobalsMacroName() + " );");
        this.d_writer.tab();
        if (cls.getParentClass() != null) {
            this.generateParentSelf(cls, 0, 0);
            this.d_writer.println();
        }
        ArrayList parents = Utilities.sort(Utilities.getAllParents(cls));
        this.aliasEPVs(cls, parents, false);
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.saveEPVs(parent, 1);
        }
        List methods = (List)cls.getNonstaticMethods(true);
        int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length() + "_post".length();
        for (int j = 0; j < 10; ++j) {
            if (!IOR.isBuiltinBasic(j) && (!IOR.isBuiltinAssert(j) || !IOR.supportAssertions(cls)) && (j != 7 || !IOR.supportInterceptors(cls))) continue;
            String mname = IOR.getBuiltinName(j);
            this.d_writer.print("epv->");
            this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
            if (j == 3 || j == 4 || j == 8) {
                this.d_writer.println(" = NULL;");
                continue;
            }
            this.d_writer.println(" = " + this.getIORMethodName(id, mname) + ';');
        }
        this.generateNonstaticMethods(cls, object, methods, "epv", parent, mwidth);
        this.copyEPVs(parents);
        this.d_writer.println("s_method_initialized = 1;");
        this.d_writer.println("ior_" + name + "__ensure_load_called();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateNonstaticMethods(Class cls, String object, List methods, String var, Class parent, int mwidth) throws CodeGenerationException {
        String xEPV;
        SymbolID id = cls.getSymbolID();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            String mname = method.getLongMethodName();
            boolean parentHas = parent != null && parent.hasMethodByLongName(mname, true);
            this.generateNonstaticMethod(cls, method, object, var, mname, parentHas, mwidth);
        }
        this.d_writer.println();
        this.d_writer.println(IOR.getSetEPVName(id) + "(" + var + ");");
        this.d_writer.println();
        boolean addBlank = false;
        if (IOR.supportAssertions(cls)) {
            xEPV = "aepv";
            this.d_writer.println("memcpy((void*)" + xEPV + ", " + var + ", sizeof(" + IOR.getEPVName(id) + "));");
            this.generateEPVMethodAssignments(cls, 1, xEPV, false);
            addBlank = true;
        }
        if (IOR.supportInterceptors(cls)) {
            if (addBlank) {
                this.d_writer.println();
                addBlank = false;
            }
            xEPV = "iepv";
            this.d_writer.println("memcpy((void*)" + xEPV + ", " + var + ", sizeof(" + IOR.getEPVName(id) + "));");
            this.generateEPVMethodAssignments(cls, 2, xEPV, false);
            addBlank = true;
        }
        if (addBlank) {
            this.d_writer.println();
        }
    }

    private void generateNonstaticMethod(Extendable ext, Method m, String object, String var, String name, boolean parentHas, int width) throws CodeGenerationException {
        String ename = IOR.getVectorEntry(name);
        if (IOR.supportInterceptors(ext)) {
            this.d_writer.print(var + "->");
            this.d_writer.printAligned(ename + "_pre", width);
            this.d_writer.println(" = NULL;");
            this.generateNonstaticEPV(m, object, var, ename, parentHas, width);
            this.d_writer.print(var + "->");
            this.d_writer.printAligned(ename + "_post", width);
            this.d_writer.println(" = NULL;");
        } else {
            this.generateNonstaticEPV(m, object, var, ename, parentHas, width);
        }
    }

    private void generateNonstaticEPV(Method m, String object, String var, String ename, boolean parentHas, int width) throws CodeGenerationException {
        this.d_writer.print(var + "->");
        this.d_writer.printAligned(ename, width);
        if (parentHas) {
            this.d_writer.print(" = ");
            this.d_writer.print(IOR.getCast(m, object + "*"));
            this.d_writer.println(" s1->" + IOR.getEPVVar(0) + "->" + ename + ";");
        } else {
            this.d_writer.println(" = NULL;");
        }
    }

    private void generateInitSEPV(Class cls) throws CodeGenerationException {
        if (cls.hasStaticMethod(true)) {
            int w;
            this.comment("SEPV: create the static entry point vector (SEPV).");
            SymbolID id = cls.getSymbolID();
            String name = IOR.getSymbolName(id);
            String lower = name.toLowerCase();
            int width = name.length();
            this.d_writer.println("static void " + name + "__init_sepv(void)");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.comment("assert( " + IOR.getHaveLockStaticGlobalsMacroName() + " );");
            Class parent = cls.getParentClass();
            SymbolID pid = null;
            boolean includeParent = parent != null && parent.hasStaticMethod(true);
            boolean doAsserts = IOR.supportAssertions(cls);
            boolean doIceptors = IOR.supportInterceptors(cls);
            if (includeParent && (w = IOR.getSymbolName(pid = parent.getSymbolID()).length()) > width) {
                width = w;
            }
            this.d_writer.printAligned(IOR.getSEPVName(id) + "*", width += "struct __sepv*".length() + 1);
            this.d_writer.println(" s = &" + IOR.getStaticEPVVariable(id, 3, 0) + ";");
            if (doAsserts) {
                this.d_writer.printAligned(IOR.getSEPVName(id) + "*", width);
                this.d_writer.println("as = &" + IOR.getStaticEPVVariable(id, 3, 1) + ";");
            }
            if (doIceptors) {
                this.d_writer.printAligned(IOR.getSEPVName(id) + "*", width);
                this.d_writer.println("is = &" + IOR.getStaticEPVVariable(id, 3, 2) + ";");
            }
            if (includeParent) {
                this.d_writer.printAligned(IOR.getSEPVName(pid) + "*", width);
                this.d_writer.println(" p = " + IOR.getStaticsName(pid) + "();");
            }
            this.d_writer.println();
            String var = "s";
            for (int j = 0; j < 10; ++j) {
                if (!IOR.hasStaticBuiltin(j) || (!IOR.isBuiltinAssert(j) || !doAsserts) && (j != 7 || !doIceptors)) continue;
                String mname = IOR.getBuiltinName(j, true);
                this.d_writer.print(var + "->");
                this.d_writer.printAligned(IOR.getVectorEntry(mname), width);
                if (6 == j || 7 == j || 9 == j) {
                    this.d_writer.println(" = " + this.getIORMethodName(id, mname) + ';');
                    continue;
                }
                this.d_writer.println(" = NULL;");
            }
            this.generateStaticMethods(cls, var, parent);
            this.d_writer.println(IOR.getSetSEPVName(id) + "(" + var + ");");
            this.d_writer.println();
            boolean addBlank = false;
            if (doIceptors) {
                String sEPV = "is";
                this.d_writer.println("memcpy((void*)" + sEPV + ", " + var + ", sizeof(" + IOR.getSEPVName(id) + "));");
                this.generateEPVMethodAssignments(cls, 2, sEPV, true);
                this.d_writer.println();
                if (doAsserts) {
                    this.d_writer.println(this.getBaseControls(true, "") + "." + "use_iceptors" + " = " + "0" + ";");
                } else {
                    this.d_writer.println(this.getBuiltinInterceptorName(id, true) + "(" + "0" + ");");
                }
                addBlank = true;
            }
            if (doAsserts) {
                if (addBlank) {
                    this.d_writer.println();
                }
                String sEPV = "as";
                this.d_writer.println("memcpy((void*)" + sEPV + ", " + var + ", sizeof(" + IOR.getSEPVName(id) + "));");
                this.generateEPVMethodAssignments(cls, 1, sEPV, true);
                this.d_writer.println();
                this.d_writer.println(this.getSetChecksMethodName(id, true) + "(" + "CHECK_ALL_TYPES | CHECK_ALWAYS" + ", " + "0.03" + ", 0);");
                addBlank = true;
            }
            if (addBlank) {
                this.d_writer.println();
            }
            this.d_writer.println("s_static_initialized = 1;");
            this.d_writer.println("ior_" + name + "__ensure_load_called();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateEnsureLoad(Class cls) {
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String lower = name.toLowerCase();
        this.d_writer.println("static void ior_" + name + "__ensure_load_called(void) {");
        this.d_writer.tab();
        this.comment("assert( " + IOR.getHaveLockStaticGlobalsMacroName() + " );");
        this.d_writer.println("if (! s_load_called ) {");
        this.d_writer.tab();
        this.d_writer.println(name + "__call_load();");
        this.d_writer.println("s_load_called=1;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateStaticMethods(Class cls, String var, Class parent) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        List methods = (List)cls.getStaticMethods(true);
        int mwidth = Utilities.getWidth(methods) + IOR.getVectorEntry("").length() + 5 + var.length() + 2;
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            String mname = method.getLongMethodName();
            boolean parentHas = parent != null && parent.hasMethodByLongName(mname, true);
            String ename = IOR.getVectorEntry(mname);
            if (IOR.supportInterceptors(cls)) {
                this.d_writer.print(var + "->");
                this.d_writer.printAligned(ename + "_pre", mwidth);
                this.d_writer.println(" = NULL;");
                this.generateStaticEPV(var, ename, parentHas, mwidth);
                this.d_writer.print(var + "->");
                this.d_writer.printAligned(ename + "_post", mwidth);
                this.d_writer.println(" = NULL;");
                continue;
            }
            this.generateStaticEPV(var, ename, parentHas, mwidth);
        }
        this.d_writer.println();
    }

    private void generateStaticEPV(String var, String ename, boolean parentHas, int mwidth) throws CodeGenerationException {
        this.d_writer.print(var + "->");
        this.d_writer.printAligned(ename, mwidth);
        if (parentHas) {
            this.d_writer.println(" = p->" + ename + ";");
        } else {
            this.d_writer.println(" = NULL;");
        }
    }

    void generateEPVMethodAssignments(Extendable ext, int setType, String ptrVar, boolean doStatics) {
        List methods = doStatics ? (List)ext.getStaticMethods(true) : (List)ext.getNonstaticMethods(true);
        Iterator i = methods.iterator();
        Method m = null;
        int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length() + ptrVar.length() + 2;
        while (i.hasNext()) {
            m = (Method)i.next();
            String mName = m.getLongMethodName();
            this.d_writer.printAligned(ptrVar + "->" + IOR.getVectorEntry(mName), mwidth);
            String tName = setType == 1 ? this.getCheckMethodName(ext, m) : this.getInterceptorMethodName(ext, m);
            this.d_writer.println(" = " + tName + ";");
        }
    }

    private void generateStaticFunction(Class cls, boolean doLocal) {
        boolean doAsserts = IOR.supportAssertions(cls);
        boolean doIceptors = IOR.supportInterceptors(cls);
        if (cls.hasStaticMethod(true) && (!doLocal || doAsserts || doIceptors)) {
            String desc = doLocal ? "specified " : "";
            this.comment("STATIC: return pointer to " + desc + "static EPV structure.");
            SymbolID id = cls.getSymbolID();
            String name = IOR.getSymbolName(id);
            String lower = name.toLowerCase();
            this.d_writer.println(IOR.getSEPVName(id) + "*");
            if (doLocal) {
                this.d_writer.println(IOR.getLocalStaticsName(id) + "(int type)");
            } else {
                this.d_writer.println(IOR.getStaticsName(id) + "(void)");
            }
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
            if (doAsserts || doIceptors) {
                this.d_writer.println(IOR.getSEPVName(id) + "* sepv;");
            }
            this.d_writer.println("if (!s_static_initialized) {");
            this.d_writer.tab();
            this.d_writer.println(name + "__init_sepv();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
            boolean cont = false;
            if (doAsserts) {
                cont = true;
                if (doLocal) {
                    this.d_writer.println("if (type == " + IOR.getStaticTypeOption(id, 1) + ") {");
                } else {
                    this.d_writer.println("if (" + this.getBaseControls(true, "") + "." + "checking_level" + " & CHECK_ASSERTIONS) {");
                }
                this.d_writer.tab();
                this.d_writer.println("sepv = &" + IOR.getStaticEPVVariable(id, 3, 1) + ";");
                this.d_writer.backTab();
                this.d_writer.print("}");
            }
            if (doIceptors) {
                if (cont) {
                    this.d_writer.print(" else ");
                }
                if (doLocal) {
                    this.d_writer.println("if (type == " + IOR.getStaticTypeOption(id, 2) + ") {");
                } else {
                    this.d_writer.println("if (" + this.getBaseControls(true, "") + "." + "use_iceptors" + ") {");
                }
                this.d_writer.tab();
                this.d_writer.println("sepv = &" + IOR.getStaticEPVVariable(id, 3, 2) + ";");
                this.d_writer.backTab();
                this.d_writer.print("}");
            }
            if (doAsserts || doIceptors) {
                this.d_writer.println(" else {");
                this.d_writer.tab();
                this.d_writer.println("sepv = &" + IOR.getStaticEPVVariable(id, 3, 0) + ";");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println("return sepv;");
            } else {
                this.d_writer.println("return &" + IOR.getStaticEPVVariable(id, 3, 0) + ";");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitClassInfo(Class cls) {
        if (!cls.isAbstract()) {
            if (this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println("static void initMetadata(" + IOR.getObjectName(cls.getSymbolID()) + "*);");
                this.d_writer.println();
            }
            this.comment("initClassInfo: create a ClassInfo interface if necessary.");
            this.d_writer.println("static void");
            this.d_writer.println("initClassInfo(" + C.getObjectName(this.d_classInfo) + " *info)");
            this.d_writer.println("{");
            this.d_writer.tab();
            if (!this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
            } else {
                this.d_writer.writeCommentLine("ClassInfo for ClassInfoI is a special case");
                this.d_writer.writeCommentLine(IOR.getUnlockStaticGlobalsMacroName() + ";");
            }
            this.d_writer.println("if (s_classInfo_init) {");
            this.d_writer.tab();
            this.d_writer.println(C.getObjectName(this.d_classInfoI) + " impl;");
            this.d_writer.println("s_classInfo_init = 0;");
            this.d_writer.println("impl = " + C.getFullMethodName(this.d_classInfoI, "_create") + "();");
            this.d_writer.println("s_classInfo = " + C.getFullMethodName(this.d_classInfo, "_cast") + "(impl);");
            this.d_writer.println("if (impl) {");
            this.d_writer.tab();
            this.d_writer.println(C.getFullMethodName(this.d_classInfoI, "setName") + "(impl, \"" + cls.getFullName() + "\");");
            this.d_writer.println(C.getFullMethodName(this.d_classInfoI, "setIORVersion") + "(impl, s_IOR_MAJOR_VERSION, s_IOR_MINOR_VERSION);");
            if (this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println("initMetadata(impl);");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (s_classInfo) {");
            this.d_writer.tab();
            this.d_writer.println("if (*info) {");
            this.d_writer.tab();
            this.d_writer.println(C.getFullMethodName(this.d_classInfo, "deleteRef") + "(*info);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("*info = s_classInfo;");
            this.d_writer.println(C.getFullMethodName(this.d_classInfo, "addRef") + "(*info);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            if (!this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
            } else {
                this.d_writer.writeCommentLine("ClassInfo for ClassInfoI is a special case");
                this.d_writer.writeCommentLine(IOR.getUnlockStaticGlobalsMacroName() + ";");
            }
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitMetadata(Class cls) {
        if (!cls.isAbstract()) {
            SymbolID id = cls.getSymbolID();
            String object = IOR.getObjectName(id);
            this.comment("initMetadata: store IOR version & class in sidl.BaseClass's data");
            this.d_writer.println("static void");
            this.d_writer.println("initMetadata(" + object + "* " + s_self + ")");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println("if (self) {");
            this.d_writer.tab();
            this.d_writer.println(C.getDataName(this.d_baseClass) + " *data = " + C.getDataGetName(this.d_baseClass) + "(" + C.getFullMethodName(this.d_baseClass, "_cast") + "(" + s_self + "));");
            this.d_writer.println("if (data) {");
            this.d_writer.tab();
            this.d_writer.println("data->d_IOR_major_version = s_IOR_MAJOR_VERSION;");
            this.d_writer.println("data->d_IOR_minor_version = s_IOR_MINOR_VERSION;");
            this.d_writer.println("initClassInfo(&(data->d_classinfo));");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateNewFunction(Class cls) {
        if (!cls.isAbstract()) {
            this.comment("NEW: allocate object and initialize it.");
            SymbolID id = cls.getSymbolID();
            String object = IOR.getObjectName(id);
            this.d_writer.println(object + "*");
            this.d_writer.println(IOR.getNewName(id) + "(void)");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println(object + "* " + s_self + " =");
            this.d_writer.tab();
            this.d_writer.println("(" + object + "*) malloc(");
            this.d_writer.tab();
            this.d_writer.println("sizeof(" + object + "));");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println(IOR.getInitName(id) + "(" + s_self + ");");
            this.d_writer.println("initMetadata(self);");
            this.d_writer.println("return self;");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitFunction(Class cls) {
        this.comment("INIT: initialize a new instance of the class object.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void " + IOR.getInitName(id) + "(");
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* " + s_self + ")");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        Class parent = cls.getParentClass();
        if (parent != null) {
            String p = IOR.getSymbolName(parent.getSymbolID());
            this.d_writer.println(IOR.getInitName(parent.getSymbolID()) + "(s1);");
            this.d_writer.println();
        }
        this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
        this.d_writer.println("if (!s_method_initialized) {");
        this.d_writer.tab();
        this.d_writer.println(IOR.getSymbolName(id) + "__init_epv(s0);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
        this.d_writer.println();
        this.fixEPVs(cls, 0, true);
        ArrayList interfaces = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
        Iterator i = interfaces.iterator();
        while (i.hasNext()) {
            SymbolID iid = (SymbolID)i.next();
            String name = IOR.getSymbolName(iid).toLowerCase();
            this.d_writer.println("s0->d_" + name + ".d_object = " + s_self + ";");
            this.d_writer.println();
        }
        this.d_writer.println("s0->d_data = NULL;");
        this.d_writer.println();
        if (IOR.supportInterceptors(cls)) {
            if (IOR.supportAssertions(cls)) {
                this.d_writer.println("s0->d_controls.use_iceptors = 0;");
            } else {
                this.d_writer.println(this.getBuiltinInterceptorName(id, false) + "(s0, " + "0" + ");");
            }
        }
        if (IOR.supportAssertions(cls)) {
            this.d_writer.println(this.getSetChecksMethodName(id, false) + "(s0, " + "CHECK_ALL_TYPES | CHECK_ALWAYS" + ", " + "0.03" + ", 0);");
        }
        this.d_writer.println();
        this.d_writer.println(IORSource.methodCall(cls, s_self, IOR.getBuiltinName(3), ""));
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateFiniFunction(Class cls) {
        this.comment("FINI: deallocate a class instance (destructor).");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void " + IOR.getFiniName(id) + "(");
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* " + s_self + ")");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        this.d_writer.println(IORSource.methodCall(cls, "s0", IOR.getBuiltinName(4), ""));
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.d_writer.println();
            this.fixEPVs(parent, 1, false);
            String p = IOR.getSymbolName(parent.getSymbolID());
            this.d_writer.println(IOR.getFiniName(parent.getSymbolID()) + "(s1);");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateVersionFunction(Class cls) {
        this.comment("VERSION: Return the version of the IOR used to generate this IOR.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.println(IOR.getVersionName(id) + "(int32_t *major, int32_t *minor" + ")");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("*major = s_IOR_MAJOR_VERSION;");
        this.d_writer.println("*minor = s_IOR_MINOR_VERSION;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateParentSelf(Class cls, int level, int width) {
        if (cls != null) {
            if (width == 0) {
                for (Class parent = cls; parent != null; parent = parent.getParentClass()) {
                    int w = IOR.getObjectName(parent.getSymbolID()).length();
                    if (w <= width) continue;
                    width = w;
                }
            }
            SymbolID id = cls.getSymbolID();
            this.d_writer.printAligned(IOR.getObjectName(id) + "*", width + 1);
            this.d_writer.print(" s" + String.valueOf(level) + " = ");
            if (level == 0) {
                this.d_writer.println("self;");
            } else {
                this.d_writer.print("&s" + String.valueOf(level - 1) + "->d_");
                this.d_writer.println(IOR.getSymbolName(id).toLowerCase() + ";");
            }
            this.generateParentSelf(cls.getParentClass(), level + 1, width);
        }
    }

    private void fixEPVs(Class cls, int level, boolean is_new) {
        if (cls != null) {
            this.fixEPVs(cls.getParentClass(), level + 1, is_new);
            String self = "s" + String.valueOf(level);
            int epvType = is_new ? 0 : 1;
            String prefix = is_new ? "&" : "";
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            String epv = IOR.getEPVVar(0);
            int width = Utilities.getWidth(ifce) + epv.length() + 3;
            boolean e = true;
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                String name = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.print(self + "->");
                this.d_writer.printAligned("d_" + name + "." + epv, width);
                this.d_writer.print(" = ");
                this.d_writer.println(prefix + IOR.getStaticEPVVariable(id, epvType, 0) + ";");
            }
            String rhs = prefix + IOR.getStaticEPVVariable(cls.getSymbolID(), epvType, 0) + ";";
            this.d_writer.print(self + "->");
            this.d_writer.printAligned(epv, width);
            this.d_writer.println(" = " + rhs);
            if (IOR.supportBaseEPVAttr(cls)) {
                this.d_writer.print(self + "->");
                this.d_writer.printAligned(IOR.getEPVVar(1), width);
                this.d_writer.println(" = " + rhs);
            }
            this.d_writer.println();
        }
    }

    private void saveEPVs(Class cls, int level) {
        if (cls != null) {
            this.saveEPVs(cls.getParentClass(), level + 1);
            String self = "s" + String.valueOf(level);
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            int width = Utilities.getWidth(ifce);
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                this.d_writer.print(IOR.getStaticEPVVariable(id, 1, 0));
                String name = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.printSpaces(width - name.length());
                this.d_writer.println(" = " + self + "->d_" + name + "." + IOR.getEPVVar(0) + ";");
            }
            this.d_writer.print(IOR.getStaticEPVVariable(cls.getSymbolID(), 1, 0));
            String lower = IOR.getSymbolName(cls.getSymbolID()).toLowerCase();
            this.d_writer.printSpaces(width - lower.length());
            this.d_writer.println(" = " + self + "->" + IOR.getEPVVar(0) + ";");
            this.d_writer.println();
        }
    }

    private void remoteEPVs(Class cls, int level) {
        if (cls != null) {
            this.remoteEPVs(cls.getParentClass(), level + 1);
            String self = "s" + String.valueOf(level);
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                String name = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.println(self + "->d_" + name + "." + IOR.getEPVVar(0) + "    = &" + IOR.getStaticEPVVariable(id, 2, 0) + ";");
                this.d_writer.println(self + "->d_" + name + ".d_object = " + "NULL" + "; /* FIXME */");
                this.d_writer.println();
            }
            this.d_writer.println(self + "->d_data = " + "NULL" + "; /* FIXME */");
            this.d_writer.println(self + "->" + IOR.getEPVVar(0) + "  = &" + IOR.getStaticEPVVariable(cls.getSymbolID(), 2, 0) + ";");
            this.d_writer.println();
        }
    }

    private void aliasEPVs(Class cls, Collection parents, boolean remote) {
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String epv = IOR.getEPVName(id);
        int epvType = remote ? 2 : 0;
        int width = epv.length() + 2;
        int w = Utilities.getWidth(parents) + "struct __epv*".length();
        if (w > width) {
            width = w;
        }
        this.d_writer.printAligned(epv + "*", width);
        this.d_writer.println(" epv  = &" + IOR.getStaticEPVVariable(id, epvType, 0) + ";");
        if (IOR.supportAssertions(cls)) {
            this.d_writer.printAligned(epv + "*", width);
            this.d_writer.println(" aepv = &" + IOR.getStaticEPVVariable(id, epvType, 1) + ";");
        }
        if (IOR.supportInterceptors(cls)) {
            this.d_writer.printAligned(epv + "*", width);
            this.d_writer.println(" iepv = &" + IOR.getStaticEPVVariable(id, epvType, 2) + ";");
        }
        int e = 0;
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            SymbolID sid = (SymbolID)i.next();
            String lower = IOR.getSymbolName(sid).toLowerCase();
            this.d_writer.printAligned(IOR.getEPVName(sid) + "*", width);
            this.d_writer.printAligned(" e" + String.valueOf(e++), 4);
            this.d_writer.println("  = &" + IOR.getStaticEPVVariable(sid, epvType, 0) + ";");
        }
        this.d_writer.println();
    }

    private void copyEPVs(Collection parents) throws CodeGenerationException {
        int e = 0;
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            Extendable ext = (Extendable)Utilities.lookupSymbol(id);
            String name = IOR.getSymbolName(id);
            List methods = (List)ext.getNonstaticMethods(true);
            int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length();
            String self = null;
            self = ext.isInterface() ? "void*" : IOR.getObjectName(id) + "*";
            String estring = "e" + String.valueOf(e) + "->";
            String vecEntry = IOR.getVectorEntry(s_castBuiltin);
            this.d_writer.print(estring);
            this.d_writer.printAligned(vecEntry, mwidth);
            this.d_writer.print(" = (void* (*)(" + self);
            this.d_writer.print(",const char*)) epv->");
            this.d_writer.print(vecEntry);
            this.d_writer.println(";");
            vecEntry = IOR.getVectorEntry(s_deleteBuiltin);
            this.d_writer.print(estring);
            this.d_writer.printAligned(vecEntry, mwidth);
            this.d_writer.println(" = (void (*)(" + self + ")) epv->" + vecEntry + ";");
            vecEntry = IOR.getVectorEntry(s_execBuiltin);
            Method m_exec = C.getExecMethod();
            String ename = m_exec.getLongMethodName();
            this.d_writer.print(estring);
            this.d_writer.printAligned(IOR.getVectorEntry(ename), mwidth);
            this.d_writer.print(" = " + IOR.getCast(m_exec, self));
            this.d_writer.println(" epv->" + IOR.getVectorEntry(ename) + ";");
            Iterator j = methods.iterator();
            while (j.hasNext()) {
                Method method = (Method)j.next();
                String mname = method.getLongMethodName();
                this.d_writer.print(estring);
                this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
                this.d_writer.print(" = " + IOR.getCast(method, self));
                this.d_writer.println(" epv->" + IOR.getVectorEntry(mname) + ";");
            }
            this.d_writer.println();
            ++e;
        }
    }

    private static String methodCall(Extendable ext, String var, String method, String args) {
        String result = "(*(" + var + "->" + IOR.getEPVVar(0) + "->" + IOR.getVectorEntry(method) + "))(" + var;
        if (ext.isInterface()) {
            result = result + "->d_object";
        }
        result = result + args;
        result = result + ");";
        return result;
    }

    private void generateReplaceValue(Symbol symbol) {
        this.d_writer.println("if (result) {");
        this.d_writer.tab();
        if (symbol instanceof Extendable) {
            this.d_writer.println("if (value) {");
            this.d_writer.tab();
            this.d_writer.println(IORSource.methodCall((Extendable)symbol, "value", "addRef", ""));
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (*result) {");
            this.d_writer.tab();
            this.d_writer.println(IORSource.methodCall((Extendable)symbol, "(*result)", "deleteRef", ""));
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.println("*result = value;");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    public static void generateExternalSignature(LanguageWriterForC lw, Symbol sym, String terminator) {
        SymbolID id = sym.getSymbolID();
        lw.beginBlockComment(false);
        lw.println("This function returns a pointer to a static structure of");
        lw.println("pointers to function entry points.  Its purpose is to provide");
        lw.println("one-stop shopping for loading DLLs.");
        lw.endBlockComment(false);
        lw.println("const " + IOR.getExternalName(id) + "*");
        lw.println(IOR.getExternalFunc(id) + "(void)" + terminator);
    }

    private void generateExternalFunc(Symbol sym) {
        SymbolID id = sym.getSymbolID();
        Class cls = null;
        if (sym instanceof Class) {
            cls = (Class)sym;
            this.d_writer.println("static const " + IOR.getExternalName(id));
        }
        this.d_writer.println("s_externalEntryPoints = {");
        this.d_writer.tab();
        if (sym instanceof Class) {
            if (!cls.isAbstract()) {
                this.d_writer.println(IOR.getNewName(id) + ",");
            }
            if (cls.hasStaticMethod(true)) {
                this.d_writer.println(IOR.getStaticsName(id) + ",");
            }
            if (cls.getParentClass() != null) {
                this.d_writer.println(IOR.getSymbolName(id) + "__super");
            }
        }
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
        IORSource.generateExternalSignature(this.d_writer, sym, "");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("return &s_externalEntryPoints;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    static {
        s_castBuiltin = IOR.getBuiltinName(0);
        s_deleteBuiltin = IOR.getBuiltinName(1);
        s_execBuiltin = IOR.getBuiltinName(2);
        s_longestBuiltin = 0;
        for (int j = 0; j < 10; ++j) {
            String mname = IOR.getBuiltinName(j, true);
            if (mname.length() <= s_longestBuiltin) continue;
            s_longestBuiltin = mname.length();
        }
    }
}

