/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.python;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.BuildGenerator;
import gov.llnl.babel.backend.FileListener;
import gov.llnl.babel.backend.writers.ChangeWriter;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForPython;
import gov.llnl.babel.symbols.SymbolID;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SetupGenerator
implements BuildGenerator,
FileListener {
    private Map d_mod2csrc = new HashMap();
    private Set d_pymodules = new TreeSet();
    private Set d_headers = new TreeSet();
    private Set d_packages = new TreeSet();

    private void writeList(LanguageWriter lw, String heading, Iterator i) {
        lw.println(heading + " = [");
        lw.tab();
        while (i.hasNext()) {
            lw.print("'" + i.next().toString() + "'");
            lw.println(i.hasNext() ? "," : "");
        }
        lw.backTab();
        lw.println("],");
    }

    private void processArgs(LanguageWriter lw) {
        lw.println();
        lw.println("inc_re = compile('^--include-dirs=(.*)$')");
        lw.println("lib_re = compile('^--library-dirs=(.*)$')");
        lw.println("exlib_re = compile('^--extra-library=(.*)$')");
        lw.println("old_argv = sys.argv");
        lw.println("sys.argv = []");
        lw.println("inc_dirs = ['.']");
        lw.println("lib_dirs = []");
        lw.println("libs = ['sidl']");
        lw.println();
        lw.println("for i in old_argv:");
        lw.tab();
        lw.println("m = inc_re.match(i)");
        lw.println("if (m):");
        lw.tab();
        lw.println("if (len(m.group(1))): inc_dirs.append(m.group(1))");
        lw.backTab();
        lw.println("else:");
        lw.tab();
        lw.println("m = lib_re.match(i)");
        lw.println("if (m):");
        lw.tab();
        lw.println("if (len(m.group(1))): lib_dirs.append(m.group(1))");
        lw.backTab();
        lw.println("else:");
        lw.tab();
        lw.println("m = exlib_re.match(i)");
        lw.println("if (m):");
        lw.tab();
        lw.println("if (len(m.group(1))): libs.append(m.group(1))");
        lw.backTab();
        lw.println("else:");
        lw.tab();
        lw.println("sys.argv.append(i)");
        lw.backTab();
        lw.backTab();
        lw.backTab();
        lw.backTab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAll() throws IOException {
        String directory = BabelConfiguration.getInstance().getOutputDirectory();
        String filename = BabelConfiguration.getInstance().getMakePrefix() + "setup.py";
        Writer fw = null;
        if (".".equals(directory)) {
            directory = "";
        } else {
            new File(directory).mkdirs();
        }
        if (directory != null && directory.length() > 0 && !directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        try {
            fw = ChangeWriter.createWriter(filename, directory);
            LanguageWriterForPython lw = new LanguageWriterForPython(new PrintWriter(fw));
            lw.printlnUnformatted("#! /usr/bin/env python");
            lw.println("# Build file for Python modules");
            lw.println("import sys");
            lw.println("from re import compile");
            lw.println("from distutils.core import setup, Extension");
            this.processArgs(lw);
            lw.println("setup(name='babel',");
            lw.tab();
            lw.println("include_dirs=inc_dirs,");
            this.writeList(lw, "headers", this.d_headers.iterator());
            this.writeList(lw, "packages", this.d_packages.iterator());
            lw.println("ext_modules = [");
            lw.tab();
            Iterator i = this.d_mod2csrc.keySet().iterator();
            while (i.hasNext()) {
                String module = (String)i.next();
                Set files = (Set)this.d_mod2csrc.get(module);
                lw.println("Extension('" + module + "',");
                lw.tab();
                lw.print("[");
                Iterator j = files.iterator();
                while (j.hasNext()) {
                    lw.print("\"" + j.next().toString() + "\"");
                    lw.println(j.hasNext() ? "," : "");
                }
                lw.println("],");
                lw.println("library_dirs=lib_dirs,");
                lw.print("libraries=libs)");
                lw.println(i.hasNext() ? "," : "");
                lw.backTab();
            }
            lw.backTab();
            lw.println("])");
            lw.backTab();
        }
        finally {
            if (null != fw) {
                fw.close();
            }
        }
    }

    private Set getCSources(String module) {
        TreeSet result = (TreeSet)this.d_mod2csrc.get(module);
        if (null == result) {
            result = new TreeSet();
            this.d_mod2csrc.put(module, result);
        }
        return result;
    }

    private static String join(String dir, String file) {
        StringBuffer buf = new StringBuffer(dir.length() + file.length());
        String outputDir = BabelConfiguration.getInstance().getOutputDirectory();
        if (!".".equals(outputDir) && dir.startsWith(outputDir) && ((dir = dir.substring(outputDir.length())).startsWith(File.separator) || dir.startsWith("/"))) {
            dir = dir.substring(1);
        }
        if (File.separatorChar != '/') {
            dir = dir.replace(File.separatorChar, '/');
        }
        return buf.append(dir).append(file).toString();
    }

    public void newFile(SymbolID id, int type, String role, String dir, String name) {
        String module = id.getFullName();
        if ("PYMOD_HDRS".equals(role)) {
            this.d_headers.add(SetupGenerator.join(dir, name));
        } else if ("PYMOD_SRCS".equals(role)) {
            Set files = this.getCSources(module);
            files.add(SetupGenerator.join(dir, name));
        } else if ("PYTHONSRC".equals(role)) {
            if (11 != type) {
                this.d_pymodules.add(module + "_Impl");
            } else {
                this.d_pymodules.add(module);
            }
        } else if ("PYTHONADMIN".equals(role)) {
            this.d_packages.add(module);
        }
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("python");
        return result;
    }
}

