/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.ucxx;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.ucxx.Cxx;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class CxxSkelSource {
    private static final String[] s_ensureOrderConstant = new String[]{Cxx.prependLocalUCxx() + "sidl::general_order", Cxx.prependLocalUCxx() + "sidl::column_major_order", Cxx.prependLocalUCxx() + "sidl::row_major_order"};
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;

    public CxxSkelSource(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void generateCode() throws CodeGenerationException {
        String filename = Cxx.generateFilename(this.d_ext.getSymbolID(), 2, 2);
        try {
            this.d_writer = Cxx.createSource(this.d_ext, 2, "SKELSRCS");
            SymbolID id = this.d_ext.getSymbolID();
            this.d_writer.generateInclude(Cxx.generateFilename(this.d_ext.getSymbolID(), 1, 1), true);
            this.d_writer.generateInclude(IOR.getHeaderFile(id), true);
            if (this.d_ext.hasExceptionThrowingMethod(true)) {
                this.d_writer.generateInclude(Cxx.generateFilename("sidl.BaseException", 3, 1), true);
            }
            Cxx.generateSourceIncludes(this.d_writer, this.d_ext);
            this.d_writer.generateInclude("sidl_String.h", false);
            this.d_writer.printlnUnformatted("#include <stddef.h>");
            this.d_writer.println();
            Cxx.beginExternCRegion(this.d_writer);
            this.writeSkelFunctions();
            this.writeLoad();
            this.writeConstructor();
            this.writeDestructor();
            this.writeInitializeEPV();
            if (this.d_ext.hasStaticMethod(true)) {
                this.writeInitializeSEPV();
            }
            Cxx.endExternCRegion(this.d_writer);
            Object var4_3 = null;
            if (this.d_writer == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
        this.d_writer.close();
        this.d_writer = null;
    }

    private void writeInitializeEPV() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(IOR.getSetEPVName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getEPVName(id));
        this.d_writer.println(" *epv) {");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("initialize builtin methods");
        this.initializeMethodPointer(IOR.getBuiltinMethod(3, id), id);
        this.initializeMethodPointer(IOR.getBuiltinMethod(4, id), id);
        this.d_writer.writeCommentLine("initialize local methods");
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.initializeMethodPointer(m, id);
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeInitializeSEPV() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(IOR.getSetSEPVName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getSEPVName(id));
        this.d_writer.println(" *sepv) {");
        this.d_writer.tab();
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!m.isStatic()) continue;
            this.d_writer.print("sepv->");
            this.d_writer.print(IOR.getVectorEntry(m.getLongMethodName()));
            this.d_writer.print(" = ");
            this.d_writer.print(Cxx.getMethodSkelName(id, m.getLongMethodName()));
            this.d_writer.println(";");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void initializeMethodPointer(Method m, SymbolID id) {
        String methodName = m.getLongMethodName();
        switch (m.getDefinitionModifier()) {
            case 0: 
            case 2: {
                this.d_writer.print("epv->");
                this.d_writer.print(IOR.getVectorEntry(methodName));
                this.d_writer.print(" = ");
                this.d_writer.print(Cxx.getMethodSkelName(id, methodName));
                this.d_writer.println(";");
                break;
            }
            case 1: {
                this.d_writer.print("epv->");
                this.d_writer.print(IOR.getVectorEntry(methodName));
                this.d_writer.println(" = NULL;");
                break;
            }
        }
    }

    private void writeConstructor() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("static void");
        this.d_writer.print(Cxx.getMethodSkelName(id, "_ctor"));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println("* self ) { ");
        this.d_writer.tab();
        this.d_writer.print("self->d_data = ");
        this.d_writer.print(Cxx.reinterpretCast("void*", "new " + Cxx.getImplSymbolName(id, "impl") + "(self)"));
        this.d_writer.println(";");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeDestructor() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("static void");
        this.d_writer.print(Cxx.getMethodSkelName(id, "_dtor"));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println("* self ) { ");
        this.d_writer.tab();
        this.d_writer.print("delete ( ");
        this.d_writer.print(Cxx.reinterpretCast(Cxx.getImplSymbolName(id, "impl") + "*", "self->d_data"));
        this.d_writer.println(" );");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeLoad() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(IOR.getSymbolName(id) + "__call_load");
        this.d_writer.print("(void) {");
        this.d_writer.tab();
        this.d_writer.print(Cxx.getImplSymbolName(id, "impl") + "::_load();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeGetDataPointer() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.print(C.getDataName(id));
        this.d_writer.println("*");
        this.d_writer.print(C.getDataGetName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println(" *self) {");
        this.d_writer.tab();
        this.d_writer.println("return self ? self->d_data : NULL;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeSetDataPointer() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(C.getDataSetName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println(" *self,");
        this.d_writer.tab();
        this.d_writer.print(C.getDataName(id));
        this.d_writer.println(" *data) {");
        this.d_writer.println("if (self) {");
        this.d_writer.tab();
        this.d_writer.println("self->d_data = data;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeSkelFunctions() throws CodeGenerationException {
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.writeImplDispatch(m);
        }
    }

    private void writeImplDispatch(Method m) throws CodeGenerationException {
        Argument arg;
        ArrayList vArgs = m.getArgumentList();
        ArrayList callArgs = m.getArgumentListWithIndices();
        int nargs = vArgs.size();
        boolean throwsExceptions = m.getThrows().size() > 0;
        StringBuffer func_decl = new StringBuffer(nargs * 32);
        StringBuffer pre_impl = new StringBuffer(nargs * 128);
        StringBuffer impl_call = new StringBuffer(nargs * 32);
        StringBuffer impl_suffix = new StringBuffer(16);
        StringBuffer post_impl = new StringBuffer(nargs * 128);
        String shortMethodName = m.getShortMethodName();
        String longMethodName = m.getLongMethodName();
        String className = this.d_ext.getSymbolID().getShortName();
        if (shortMethodName.equals(className)) {
            shortMethodName = "f_" + shortMethodName;
            System.out.println("WARNING: gov.llnl.babel.backend.UCxx.CxxSkelSource: sidl / C++ conflict!");
            System.out.println("         methodName == className is not allowed in C++");
            System.out.println("         (this is restricted to constructors in C++)");
            System.out.println("         changing to " + className + "::" + shortMethodName + "()");
        }
        func_decl.append("static ");
        String res = "_result";
        String lres = "_local" + res;
        Type return_type = m.getReturnType();
        int type_val = return_type.getDetailedType();
        func_decl.append(IOR.getReturnString(return_type, true, false));
        func_decl.append("\n");
        if (type_val != 0) {
            pre_impl.append(IOR.getReturnString(return_type, true, false));
            pre_impl.append(" " + res);
            if (type_val == 11) {
                pre_impl.append("");
            } else if (type_val == 5 || type_val == 3) {
                pre_impl.append(" = {0,0}");
            } else {
                pre_impl.append(" = 0");
            }
            pre_impl.append(";\n");
        }
        String defRetLine = Cxx.getReturnString(return_type) + " " + lres + ";\n";
        String addRefLine = "  " + lres + ".addRef();\n";
        switch (return_type.getDetailedType()) {
            case 16: {
                pre_impl.append(defRetLine);
                impl_call.append(lres + " = ");
                post_impl.append("if ( " + lres + "._not_nil() ) {\n");
                if (return_type.hasArrayOrderSpec()) {
                    post_impl.append("  " + lres + ".ensure(" + return_type.getArrayDimension() + ", " + s_ensureOrderConstant[return_type.getArrayOrder()] + ");\n");
                }
                post_impl.append(addRefLine);
                post_impl.append("}\n");
                post_impl.append(res + " = " + Cxx.getIORCall(lres, return_type) + ";\n");
                break;
            }
            case 1: {
                pre_impl.append(defRetLine);
                impl_call.append(lres + " = ");
                post_impl.append(res + " = ( " + lres + " ? TRUE : FALSE );\n");
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                impl_call.append(res + " = ");
                break;
            }
            case 12: 
            case 13: {
                pre_impl.append(defRetLine);
                impl_call.append(lres + " = ");
                post_impl.append("if ( " + lres + "._not_nil() ) {\n");
                post_impl.append(addRefLine);
                post_impl.append("}\n");
                post_impl.append(res + " = " + lres + "._get_ior();\n");
                break;
            }
            case 3: 
            case 5: {
                pre_impl.append(defRetLine);
                impl_call.append(lres + " = ");
                post_impl.append(res + ".real = " + lres + ".real();\n");
                post_impl.append(res + ".imaginary = " + lres + ".imag();\n");
                break;
            }
            case 11: {
                pre_impl.append(Cxx.getEnumName(return_type.getSymbolID()) + " " + lres + ";\n");
                impl_call.append(lres + " = ");
                post_impl.append(res + " = (" + IOR.getEnumName(return_type.getSymbolID()) + ")" + lres + ";\n");
                break;
            }
            case 10: {
                pre_impl.append(defRetLine);
                impl_call.append(lres + " = ");
                post_impl.append(res + " = sidl_String_strdup(" + lres + ".c_str());\n");
                break;
            }
            case 15: {
                throw new CodeGenerationException("Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE");
            }
            case 0: {
                break;
            }
        }
        func_decl.append(Cxx.getMethodSkelName(this.d_ext.getSymbolID(), longMethodName));
        func_decl.append("( ");
        if (m.isStatic()) {
            impl_call.append(Cxx.getMethodImplName(this.d_ext.getSymbolID(), shortMethodName));
        } else {
            func_decl.append("\n");
            func_decl.append("/* in */ ");
            func_decl.append(IOR.getObjectName(this.d_ext.getSymbolID()) + "* self");
            if (nargs > 0) {
                func_decl.append(", ");
            }
            pre_impl.append(Cxx.getImplSymbolName(this.d_ext.getSymbolID(), "impl"));
            pre_impl.append(" *_this = ");
            pre_impl.append(Cxx.reinterpretCast(Cxx.getImplSymbolName(this.d_ext.getSymbolID(), "impl") + "*", "self->d_data"));
            pre_impl.append(";\n");
            impl_call.append("_this->" + shortMethodName + "_impl");
        }
        impl_call.append("( ");
        Iterator it = vArgs.iterator();
        while (it.hasNext()) {
            arg = (Argument)it.next();
            String mode = "/* " + Cxx.argModeToString(arg) + " */ ";
            String argName = arg.getFormalName();
            func_decl.append(mode);
            func_decl.append(IOR.getArgumentString(arg, true, false, false) + " " + argName);
            if (!it.hasNext()) continue;
            func_decl.append(",");
        }
        it = callArgs.iterator();
        while (it.hasNext()) {
            arg = (Argument)it.next();
            Type type = arg.getType();
            int typeInt = type.getDetailedType();
            String argName = arg.getFormalName();
            String mode = "/* " + Cxx.argModeToString(arg) + " */ ";
            int modeInt = arg.getMode();
            impl_call.append(mode);
            boolean argGoesOut = true;
            if (modeInt == 0) {
                argGoesOut = false;
            }
            String localArgName = "_local_" + argName;
            addRefLine = "  " + localArgName + ".addRef();\n";
            switch (typeInt) {
                case 16: {
                    if (arg.getType().isRarray()) {
                        String r_name = arg.getFormalName();
                        Type arrayType = type.getArrayType();
                        Type argType = arg.getType();
                        int argDim = argType.getArrayDimension();
                        pre_impl.append(IOR.getReturnString(arg.getType(), false, false) + localArgName + " = " + C.getEnsureArray(argType.getArrayType()) + "(");
                        if (argGoesOut) {
                            pre_impl.append("*");
                        }
                        pre_impl.append(arg.getFormalName() + ", " + argDim + ", " + s_ensureOrderConstant[argType.getArrayOrder()] + ");\n");
                        if (modeInt != 0) {
                            String init_func_name = IOR.getArrayNameForFunctions(arrayType.getType()) + "_init";
                            post_impl.append(init_func_name + "(" + r_name + "_tmp" + ", *" + r_name + ", " + argDim + ", (*" + r_name + ")->d_metadata.d_lower, (*" + r_name + ")->d_metadata.d_upper, (*" + r_name + ")->d_metadata.d_stride);\n");
                        }
                        pre_impl.append(IOR.getArgumentWithFormal(arg, false, true, false) + "_tmp" + " = ");
                        pre_impl.append(localArgName + "->d_firstElement;\n");
                        impl_call.append(argName + "_tmp");
                        break;
                    }
                    boolean doEnsureCall = type.hasArrayOrderSpec();
                    String ensureCallLine = localArgName + ".ensure(" + type.getArrayDimension() + ", " + s_ensureOrderConstant[type.getArrayOrder()] + ");\n";
                    pre_impl.append(Cxx.getReturnString(type) + " " + localArgName);
                    if (modeInt != 2) {
                        pre_impl.append("(");
                        if (argGoesOut) {
                            pre_impl.append("*");
                        }
                        pre_impl.append(argName + ")");
                    }
                    pre_impl.append(";\n");
                    if (modeInt != 2) {
                        if (modeInt == 0) {
                            pre_impl.append("if (" + argName + ") {\n");
                            pre_impl.append(addRefLine);
                            if (doEnsureCall) {
                                pre_impl.append("  ");
                            }
                        } else {
                            pre_impl.append("*" + argName + " = 0;\n");
                        }
                        if (doEnsureCall) {
                            pre_impl.append(ensureCallLine);
                        }
                        if (modeInt == 0) {
                            pre_impl.append(" }\n");
                        }
                    }
                    impl_call.append(localArgName);
                    if (modeInt == 0) break;
                    post_impl.append("if ( " + localArgName + "._not_nil() ) {\n");
                    if (doEnsureCall) {
                        post_impl.append("  " + ensureCallLine);
                    }
                    post_impl.append(addRefLine);
                    post_impl.append("}\n");
                    post_impl.append("*" + argName + " = " + Cxx.getIORCall(localArgName, type) + ";\n");
                    break;
                }
                case 1: {
                    pre_impl.append("bool " + localArgName);
                    if (modeInt != 2) {
                        String argPtr = argGoesOut ? "*" : "";
                        pre_impl.append(" = (" + argPtr + argName + " == TRUE)");
                    }
                    pre_impl.append(";\n");
                    impl_call.append(localArgName);
                    if (!argGoesOut) break;
                    post_impl.append("*" + argName + " = (" + localArgName + " ? TRUE : FALSE);\n");
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    if (argGoesOut) {
                        impl_call.append("*");
                    }
                    impl_call.append(argName);
                    break;
                }
                case 12: 
                case 13: {
                    pre_impl.append(Cxx.getReturnString(type) + " " + localArgName);
                    if (modeInt != 2) {
                        pre_impl.append("(");
                        if (argGoesOut) {
                            pre_impl.append("*");
                        }
                        pre_impl.append(argName + ")");
                    }
                    pre_impl.append(";\n");
                    impl_call.append(localArgName);
                    if (modeInt == 0) break;
                    post_impl.append("if ( " + localArgName + "._not_nil() ) {\n");
                    post_impl.append(addRefLine);
                    post_impl.append("}\n");
                    if (1 == modeInt) {
                        post_impl.append("if (*" + argName + ") (*((*" + argName + ")->d_epv->f_deleteRef))((*" + argName + (typeInt == 13 ? ")->d_object);\n" : "));\n"));
                    }
                    post_impl.append("*" + argName + " = " + localArgName + "._get_ior();\n");
                    break;
                }
                case 3: 
                case 5: {
                    pre_impl.append(Cxx.getReturnString(type) + " " + localArgName);
                    if (modeInt != 2) {
                        String sep = argGoesOut ? "->" : ".";
                        pre_impl.append(" (" + argName + sep + "real, " + argName + sep + "imaginary)");
                    }
                    pre_impl.append(";\n");
                    impl_call.append(localArgName);
                    if (!argGoesOut) break;
                    post_impl.append(argName + "->real = " + localArgName + ".real();\n");
                    post_impl.append(argName + "->imaginary = " + localArgName + ".imag();\n");
                    break;
                }
                case 11: {
                    impl_call.append("(" + Cxx.getEnumName(type.getSymbolID()) + "&)");
                    if (argGoesOut) {
                        impl_call.append("*");
                    }
                    impl_call.append(argName);
                    break;
                }
                case 10: {
                    String dup_line;
                    pre_impl.append(Cxx.getReturnString(type) + " " + localArgName);
                    if (modeInt != 2) {
                        String argNamePtr = argGoesOut ? "*" : "";
                        pre_impl.append(" = ( " + argNamePtr + argName + " ? " + argNamePtr);
                        pre_impl.append(argName + ": \"\" )");
                    }
                    pre_impl.append(";\n");
                    impl_call.append(localArgName);
                    String string = dup_line = argGoesOut ? "*" + argName + " = sidl_String_strdup( " + localArgName + ".c_str() );\n" : "";
                    if (modeInt == 2) {
                        post_impl.append(dup_line);
                        break;
                    }
                    if (modeInt != 1) break;
                    post_impl.append("if ( *" + argName + " == 0) {\n");
                    post_impl.append("  " + dup_line);
                    post_impl.append("} else if ( strlen( *" + argName + " ) >= " + localArgName + ".length() ) {\n");
                    post_impl.append("  " + localArgName + ".copy( *" + argName + ", ::std::string::npos );\n");
                    post_impl.append("  (*" + argName + ")[ " + localArgName + ".length()] = 0;\n");
                    post_impl.append("} else { \n");
                    post_impl.append("  sidl_String_free( *" + argName + ");\n");
                    post_impl.append("  " + dup_line);
                    post_impl.append("}");
                    break;
                }
                case 15: {
                    throw new CodeGenerationException("Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE");
                }
            }
            if (!it.hasNext()) continue;
            impl_call.append(", ");
        }
        HashMap index_args = m.getRarrayInfo();
        Iterator i = index_args.values().iterator();
        while (i.hasNext()) {
            Collection index_collection = (Collection)i.next();
            Iterator tmp = index_collection.iterator();
            Method.RarrayInfo info = (Method.RarrayInfo)tmp.next();
            Argument index = info.index;
            Argument rarray = info.rarray;
            Type arrayType = rarray.getType().getArrayType();
            int dim = info.dim;
            if (index.getType().getType() == 8) {
                pre_impl.append("int64_t ");
            } else {
                pre_impl.append("int32_t ");
            }
            pre_impl.append(index.getFormalName() + " = sidlLength(");
            pre_impl.append("_local_" + info.rarray.getFormalName() + "," + dim + ");\n");
        }
        if (throwsExceptions) {
            if (nargs > 0 || !m.isStatic()) {
                func_decl.append(", ");
            }
            pre_impl.append("*_exception = 0;//init just to be safe\n");
            func_decl.append("sidl_BaseInterface__object ** _exception");
        }
        func_decl.append(" )\n");
        impl_call.append(" )" + impl_suffix.toString() + ";\n");
        this.d_writer.println(func_decl.toString().trim());
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("pack args to dispatch to impl");
        this.d_writer.println(pre_impl.toString().trim());
        this.d_writer.writeCommentLine("dispatch to impl");
        if (throwsExceptions) {
            this.d_writer.println("try { ");
            this.d_writer.tab();
        }
        this.d_writer.println(impl_call.toString().trim());
        if (throwsExceptions) {
            this.d_writer.backTab();
            this.d_writer.println("} catch ( " + Cxx.prependGlobalUCxx() + "::sidl::BaseInterface _ex ) { ");
            this.d_writer.tab();
            this.d_writer.println("_ex.addRef();");
            this.d_writer.println("*_exception = _ex._get_ior();");
            if (return_type.getType() != 0) {
                this.d_writer.println("return " + res + ";");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.writeCommentLine("unpack results and cleanup");
        this.d_writer.println(post_impl.toString().trim());
        if (return_type.getType() != 0) {
            this.d_writer.println("return " + res + ";");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }
}

