/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.writers;

import java.io.PrintWriter;

public class PrettyWriter {
    private static final int BUFSIZE = 80;
    private String d_block_after_tab = null;
    private boolean d_block_enabled = false;
    private String d_block_line_start = null;
    private int d_break_column = 80;
    private boolean d_break_enabled = false;
    private String d_break_line_end = null;
    private String d_break_line_start = null;
    private String d_break_string = ", (";
    private int d_cursor = 0;
    private int d_first_tab = 0;
    private int d_level = 0;
    private StringBuffer d_line = new StringBuffer(80);
    private int d_tab = 2;
    private int d_tmp_first_tab = 0;
    private PrintWriter d_writer;
    private boolean d_strict_break = false;

    public PrettyWriter(PrintWriter writer) {
        this.d_writer = writer;
    }

    public void close() {
        if (this.d_writer != null) {
            this.d_writer.flush();
            this.d_writer.close();
            this.d_writer = null;
        }
    }

    public PrintWriter getPrintWriter() {
        return this.d_writer;
    }

    public void enableLineBreak(int column, String start, String end) {
        this.d_break_column = column;
        this.d_break_enabled = true;
        this.d_break_line_end = end;
        this.d_break_line_start = start;
        if (this.d_break_column < 1) {
            this.d_break_column = 1;
        }
    }

    public void enableLineBreak() {
        this.d_break_enabled = true;
    }

    public void disableLineBreak() {
        this.d_break_enabled = false;
    }

    public void setStrictBreaking() {
        this.d_strict_break = true;
    }

    public void setLineBreakString(String s) {
        this.d_break_string = s;
    }

    public void defineBlockComment(String line_start, String after_tab) {
        this.d_block_after_tab = after_tab;
        this.d_block_line_start = line_start;
    }

    public void enableBlockComment() {
        this.d_block_enabled = true;
    }

    public void disableBlockComment() {
        this.d_block_enabled = false;
    }

    public void setFirstTabStop(int column) {
        this.d_tmp_first_tab = this.d_first_tab = column >= 0 ? column : 0;
    }

    public void changeTabLevel(int delta) {
        this.d_level += delta;
        if (this.d_level < 0) {
            this.d_level = 0;
        }
    }

    public void tab() {
        this.changeTabLevel(1);
    }

    public void backTab() {
        this.changeTabLevel(-1);
    }

    public void setTabSpacing(int spacing) {
        this.d_tab = spacing >= 1 ? spacing : 1;
    }

    public void setTemporaryFirstTabStop() {
        this.flushLine();
        this.d_tmp_first_tab = this.d_cursor;
    }

    public void restoreFirstTabStop() {
        this.d_tmp_first_tab = this.d_first_tab;
    }

    public void print(String s) {
        if (s != null && s.length() > 0) {
            int newline = s.indexOf("\n");
            if (newline < 0) {
                this.d_line.append(s);
            } else {
                this.println(s.substring(0, newline));
                this.print(s.substring(newline + 1));
            }
        }
    }

    public void println(String s) {
        if (s == null || s.length() == 0) {
            this.println();
        } else {
            int newline = s.indexOf("\n");
            if (newline < 0) {
                this.d_line.append(s);
                this.flushLine();
                this.d_writer.print('\n');
                this.d_writer.flush();
                this.d_cursor = 0;
            } else {
                this.println(s.substring(0, newline));
                this.println(s.substring(newline + 1));
            }
        }
    }

    public void printUnformatted(String s) {
        if (s != null) {
            this.d_writer.print(s);
            this.d_writer.flush();
            this.d_cursor = 0;
        }
    }

    public void printlnUnformatted(String s) {
        if (s == null || s.length() == 0) {
            this.d_writer.print('\n');
        } else {
            this.d_writer.print(s);
            this.d_writer.print('\n');
        }
        this.d_writer.flush();
        this.d_cursor = 0;
    }

    public void println() {
        if (this.d_line.length() > 0 || this.d_block_enabled) {
            this.flushLine();
        }
        this.d_writer.print('\n');
        this.d_writer.flush();
        this.d_cursor = 0;
    }

    public void printSpaces(int nspaces) {
        if (nspaces > 0) {
            for (int i = 0; i < nspaces; ++i) {
                this.print(" ");
            }
        }
    }

    public void printAligned(String text, int field) {
        if (text == null) {
            this.printSpaces(field);
        } else {
            this.print(text);
            this.printSpaces(field - text.length());
        }
    }

    private void flushLine() {
        boolean was_line_start = false;
        if (this.d_cursor == 0) {
            was_line_start = true;
            this.beginNormalLine();
        }
        if (!this.d_break_enabled || this.d_block_enabled || this.d_break_string == null) {
            this.d_writer.print(this.d_line.toString());
            this.d_cursor += this.d_line.length();
        } else {
            this.breakLine(0, was_line_start);
        }
        this.d_line = new StringBuffer(80);
    }

    private void breakLine(int start, boolean force) {
        int length = this.d_line.length();
        int remain = length - start;
        if (remain > 0) {
            if (this.d_cursor + remain <= this.d_break_column) {
                this.d_writer.print(this.d_line.substring(start));
                this.d_cursor += remain;
            } else {
                int index = -1;
                int search = this.d_break_column - this.d_cursor;
                for (int c = 0; c < this.d_break_string.length() && (index = this.findBreak(this.d_break_string.charAt(c), start, search)) < 0; ++c) {
                }
                if (index > 0) {
                    String fragment = this.d_line.substring(start, index + 1);
                    this.d_writer.print(fragment);
                    this.d_cursor += fragment.length();
                    this.endContinuationLine();
                    this.beginContinuationLine();
                    this.breakLine(this.firstNonSpace(index + 1), true);
                } else if (force) {
                    if (this.d_strict_break && search > 0) {
                        String fragment = this.d_line.substring(start, start + search);
                        this.d_writer.print(fragment);
                        this.endContinuationLine();
                        this.beginContinuationLine();
                        this.breakLine(this.firstNonSpace(start + search), true);
                    } else {
                        String fragment = this.d_line.substring(start);
                        this.d_writer.print(fragment);
                        this.d_cursor += fragment.length();
                    }
                } else {
                    this.endContinuationLine();
                    this.beginContinuationLine();
                    this.breakLine(this.firstNonSpace(start), true);
                }
            }
        }
    }

    private void endContinuationLine() {
        if (this.d_break_line_end != null) {
            this.writeSpaces(this.d_break_column - this.d_cursor);
            this.d_writer.print(this.d_break_line_end);
        }
        this.d_writer.print('\n');
        this.d_writer.flush();
        this.d_cursor = 0;
    }

    private int firstNonSpace(int start) {
        int length;
        int index = length = this.d_line.length();
        for (int c = start; c < length; ++c) {
            if (this.d_line.charAt(c) == ' ') continue;
            index = c;
            break;
        }
        return index;
    }

    private int findBreak(char c, int start, int search) {
        int index = -1;
        for (int s = start + search - 1; s >= start; --s) {
            if (this.d_line.charAt(s) != c) continue;
            index = s;
            break;
        }
        return index;
    }

    private void beginNormalLine() {
        if (this.d_block_enabled && this.d_block_line_start != null) {
            this.d_writer.print(this.d_block_line_start);
            this.d_cursor += this.d_block_line_start.length();
        }
        int first_column = this.d_tmp_first_tab + this.d_level * this.d_tab;
        this.writeSpaces(first_column - this.d_cursor);
        if (this.d_block_enabled && this.d_block_after_tab != null) {
            this.d_writer.print(this.d_block_after_tab);
            this.d_cursor += this.d_block_after_tab.length();
        }
    }

    private void beginContinuationLine() {
        if (this.d_break_line_start != null) {
            this.d_writer.print(this.d_break_line_start);
            this.d_cursor += this.d_break_line_start.length();
        }
        int first_column = this.d_tmp_first_tab + (this.d_level + 1) * this.d_tab;
        this.writeSpaces(first_column - this.d_cursor);
    }

    private void writeSpaces(int nspaces) {
        if (nspaces > 0) {
            for (int i = 0; i < nspaces; ++i) {
                this.d_writer.print(' ');
            }
            this.d_cursor += nspaces;
        }
    }
}

