/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.AssertionExpression;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import java.util.ArrayList;

public class Assertion {
    private int d_type = 0;
    private String d_source = null;
    private String d_tag = null;
    private Comment d_comment = null;
    private AssertionExpression d_expression = null;
    public static final int UNKNOWN = 0;
    public static final int INVARIANT = 1;
    public static final int REQUIRE = 2;
    public static final int REQUIRE_ELSE = 3;
    public static final int ENSURE = 4;
    public static final int ENSURE_THEN = 5;
    private static final int MIN_VALID_TYPE = 1;
    private static final int MAX_VALID_TYPE = 5;
    public static final String[] s_names = new String[]{"unknown", "invariant", "require", "require else", "ensure", "ensure then"};

    public Assertion(int type, String source, String tag, Comment comment) throws AssertionException {
        String prefix;
        String string = prefix = tag == null ? "Assertion: " : "Assertion: " + tag;
        if (type < 1 || type > 5) {
            throw new AssertionException(prefix, "Invalid assertion type value \"" + type + "\", must be in " + 1 + "..." + 5 + ".");
        }
        if (source == null || source.equals("")) {
            throw new AssertionException(prefix, "Cannot create assertion without the source information since it is required for debug messages.");
        }
        this.d_type = type;
        this.d_source = source;
        this.d_tag = tag;
        this.d_comment = comment;
        this.d_expression = null;
    }

    public int getType() {
        return this.d_type;
    }

    public int getType(String name) {
        int t;
        for (t = 1; t <= 5 && !name.equalsIgnoreCase(s_names[t]); ++t) {
        }
        if (t > 5) {
            t = 0;
        }
        return t;
    }

    public boolean isPrecondition() {
        return this.d_type == 2 || this.d_type == 3;
    }

    public boolean isPostcondition() {
        return this.d_type == 4 || this.d_type == 5;
    }

    public boolean isInvariant() {
        return this.d_type == 1;
    }

    public String getTypeName() {
        return s_names[this.d_type];
    }

    public String getSource() {
        return this.d_source;
    }

    public String getTag() {
        return this.d_tag;
    }

    public Comment getComment() {
        return this.d_comment;
    }

    protected String getExceptionPrefix(Extendable ext, Method m) {
        return ext == null ? "Assertion" : (m == null ? ext.getFullName() : ext.getFullName() + "." + m.getLongMethodName());
    }

    protected void ensureNoPostAssertions(AssertionExpression expr) throws AssertionException {
        if (expr.hasPure()) {
            throw new AssertionException("Assertion", "Cannot specify a PURE clause in a(n) " + this.getTypeName() + "assertion.");
        }
        if (expr.hasResult()) {
            throw new AssertionException("Assertion", "Cannot specify RESULT in a(n) " + this.getTypeName() + " assertion.");
        }
    }

    public void setExpression(AssertionExpression expr) throws AssertionException {
        if (this.isInvariant()) {
            this.ensureNoPostAssertions(expr);
            if (expr.requiresMethodContext()) {
                throw new AssertionException("Assertion", "An invariant cannot contain an assertion expression that is associated with a method.");
            }
        } else if (this.isPrecondition()) {
            this.ensureNoPostAssertions(expr);
        }
        this.d_expression = expr;
    }

    public AssertionExpression getExpression() {
        return this.d_expression;
    }

    public boolean isValid() {
        return this.d_expression.isValid();
    }

    public void validateExpression(Extendable ext, Method m, boolean skip) throws AssertionException {
        if (this.d_expression == null) {
            throw new AssertionException(this.getExceptionPrefix(ext, m), "Cannot validate a " + this.getTypeName() + " assertion when its " + "expression is null.");
        }
        if (ext == null && this.d_expression.requiresExtendableContext()) {
            throw new AssertionException(this.getExceptionPrefix(ext, m), "Cannot validate the " + this.getTypeName() + " assertion " + "expression without access to the extendable's context.");
        }
        if (m == null && this.d_expression.requiresMethodContext()) {
            throw new AssertionException(this.getExceptionPrefix(ext, m), "Cannot validate the " + this.getTypeName() + " assertion " + "expression without access to the method's context.");
        }
        this.d_expression.validateExpression(ext, m);
    }

    public boolean hasPureClause() {
        return this.d_expression.hasPure();
    }

    public boolean hasResult() {
        return this.d_expression.hasResult();
    }

    public boolean hasMethodCall() {
        return this.d_expression.hasMethodCall();
    }

    public boolean hasReservedMethod(int type) {
        return this.d_expression.hasReservedMethod(type);
    }

    public boolean hasUnreservedMethod(boolean any) {
        return this.d_expression.hasUnreservedMethod(any);
    }

    public String errorMessage() {
        return this.getTypeName().toUpperCase() + " VIOLATION: " + this.d_source + ": " + this.toString() + ".";
    }

    public ArrayList getArrayIterMacros(String epvVar, int[] startInd) {
        return this.d_expression.getArrayIterMacros(epvVar, startInd);
    }

    public int getNumArrayIterMacrosByType(char type) {
        return this.d_expression.getNumArrayIterMacrosByType(type);
    }

    public String cExpression(String epvVar, int[] startInd) {
        return this.d_expression.cExpression(epvVar, startInd);
    }

    public String toString() {
        return this.d_tag != null && !this.d_tag.equals("") ? this.d_tag + ": " + this.d_expression.toString() : this.d_expression.toString();
    }
}

