/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

public class Comment {
    private String[] d_comment;

    public Comment(String[] comment) {
        this.d_comment = comment;
    }

    public String[] getComment() {
        return this.d_comment;
    }

    public boolean isEmpty() {
        boolean empty = false;
        String[] lines = this.d_comment;
        if (lines == null || lines.length == 0) {
            empty = true;
        }
        return empty;
    }

    public int hashCode() {
        int result = 0;
        if (this.d_comment != null) {
            for (int i = 0; i < this.d_comment.length; ++i) {
                result += this.d_comment[i].hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Comment) {
            Comment arg = (Comment)o;
            if (this.d_comment == arg.d_comment) {
                return true;
            }
            if (this.d_comment != null && arg.d_comment != null && this.d_comment.length == arg.d_comment.length) {
                for (int i = 0; i < this.d_comment.length; ++i) {
                    if (this.d_comment[i].equals(arg.d_comment[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static Comment combineComments(Comment original, Comment additional) {
        if (original == null) {
            return additional;
        }
        if (additional == null || additional.d_comment == null || original.equals(additional)) {
            return original;
        }
        if (original.d_comment == null) {
            return additional;
        }
        int origlen = original.d_comment.length;
        int addlen = additional.d_comment.length;
        String[] comment = new String[origlen + addlen + 1];
        System.arraycopy(original.d_comment, 0, comment, 0, origlen);
        System.arraycopy(additional.d_comment, 0, comment, origlen + 1, addlen);
        comment[origlen] = "";
        return new Comment(comment);
    }
}

