/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.xml;

import gov.llnl.babel.url.URLUtilities;
import gov.llnl.babel.xml.XMLUtilities;
import java.io.IOException;
import org.w3c.dom.Document;

public class XMLTest {
    public static void main(String[] argv) {
        if (argv.length != 1 && argv.length != 3) {
            System.err.println("usage: gov.llnl.babel.xml.XMLTest [DTD-URI start-element] XML-URI");
            System.exit(1);
        }
        String xml = null;
        try {
            String xml_uri = argv.length == 1 ? argv[0] : argv[2];
            xml = URLUtilities.readURL(URLUtilities.expandURL(xml_uri));
        }
        catch (IOException ex) {
            System.err.println("Babel: Error: IOException");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        Document document = null;
        if (argv.length == 1) {
            document = XMLUtilities.checkXML(xml);
        } else {
            String string = URLUtilities.expandURL(argv[0]);
        }
        if (document == null) {
            System.out.println("Invalid XML document");
        } else {
            System.out.println(XMLUtilities.getXMLString(document));
        }
    }
}

