/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.sidl;

import gov.llnl.sidl.BaseClass;

public abstract class BaseArray {
    protected long d_array;
    protected boolean d_owner;

    protected BaseArray() {
        this.d_array = 0L;
        this.d_owner = true;
    }

    protected BaseArray(long array, boolean owner) {
        this.d_array = array;
        this.d_owner = owner;
    }

    protected void reset(long array, boolean owner) {
        this.destroy();
        this.d_array = array;
        this.d_owner = owner;
    }

    public boolean isNull() {
        return this.d_array == 0L;
    }

    public native int _type();

    public native int _dim();

    public native int _lower(int var1);

    public native int _upper(int var1);

    public int _length(int dim) {
        return 1 + this._upper(dim) - this.lower(dim);
    }

    public native int _stride(int var1);

    public native boolean _isColumnOrder();

    public native boolean _isRowOrder();

    public native void _addRef();

    public native BaseArray _smartCopy();

    public native void _deallocate();

    public native void _destroy();

    public abstract void _reallocate(int var1, int[] var2, int[] var3, boolean var4);

    public void destroy() {
        if (this.d_owner && this.d_array != 0L) {
            this._destroy();
        }
        this.d_array = 0L;
        this.d_owner = true;
    }

    public long get_ior_pointer() {
        return this.d_array;
    }

    public void set_ior_pointer(long p) {
        this.d_array = p;
    }

    public boolean get_owner() {
        return this.d_owner;
    }

    public void set_owner(boolean p) {
        this.d_owner = p;
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public void reallocate(int dim, int[] lower, int[] upper, boolean isRow) {
        this.destroy();
        if (lower == null || upper == null) {
            throw new ArrayIndexOutOfBoundsException("Null array index argument");
        }
        if (dim > lower.length || dim > upper.length) {
            throw new ArrayIndexOutOfBoundsException("Array dimension mismatch");
        }
        for (int d = 0; d < dim; ++d) {
            if (upper[d] + 1 >= lower[d]) continue;
            throw new ArrayIndexOutOfBoundsException("Upper bound less than lower");
        }
        this._reallocate(dim, lower, upper, isRow);
    }

    public int dim() {
        return this.isNull() ? 0 : this._dim();
    }

    protected void checkNullArray() {
        if (this.isNull()) {
            throw new NullPointerException("Array data has not been allocated");
        }
    }

    protected void checkDimension(int d) {
        if (d != this._dim()) {
            throw new ArrayIndexOutOfBoundsException("Illegal array dimension : " + d);
        }
    }

    protected void checkIndexBounds(int i, int d) {
        if (i < this._lower(d) || i > this._upper(d)) {
            throw new ArrayIndexOutOfBoundsException("Index " + d + " out of bounds: " + i);
        }
    }

    protected void checkBounds(int i) {
        this.checkNullArray();
        this.checkDimension(1);
        this.checkIndexBounds(i, 0);
    }

    protected void checkBounds(int i, int j) {
        this.checkNullArray();
        this.checkDimension(2);
        this.checkIndexBounds(i, 0);
        this.checkIndexBounds(j, 1);
    }

    protected void checkBounds(int i, int j, int k) {
        this.checkNullArray();
        this.checkDimension(3);
        this.checkIndexBounds(i, 0);
        this.checkIndexBounds(j, 1);
        this.checkIndexBounds(k, 2);
    }

    protected void checkBounds(int i, int j, int k, int l) {
        this.checkNullArray();
        this.checkDimension(4);
        this.checkIndexBounds(i, 0);
        this.checkIndexBounds(j, 1);
        this.checkIndexBounds(k, 2);
        this.checkIndexBounds(l, 3);
    }

    protected void checkBounds(int i, int j, int k, int l, int m) {
        this.checkNullArray();
        this.checkDimension(5);
        this.checkIndexBounds(i, 0);
        this.checkIndexBounds(j, 1);
        this.checkIndexBounds(k, 2);
        this.checkIndexBounds(l, 3);
        this.checkIndexBounds(m, 4);
    }

    protected void checkBounds(int i, int j, int k, int l, int m, int n) {
        this.checkNullArray();
        this.checkDimension(6);
        this.checkIndexBounds(i, 0);
        this.checkIndexBounds(j, 1);
        this.checkIndexBounds(k, 2);
        this.checkIndexBounds(l, 3);
        this.checkIndexBounds(m, 4);
        this.checkIndexBounds(n, 5);
    }

    protected void checkBounds(int i, int j, int k, int l, int m, int n, int o) {
        this.checkNullArray();
        this.checkDimension(7);
        this.checkIndexBounds(i, 0);
        this.checkIndexBounds(j, 1);
        this.checkIndexBounds(k, 2);
        this.checkIndexBounds(l, 3);
        this.checkIndexBounds(m, 4);
        this.checkIndexBounds(n, 5);
        this.checkIndexBounds(o, 6);
    }

    public int lower(int dim) {
        this.checkNullArray();
        return this._lower(dim);
    }

    public int upper(int dim) {
        this.checkNullArray();
        return this._upper(dim);
    }

    public int stride(int dim) {
        this.checkNullArray();
        return this._stride(dim);
    }

    static {
        BaseClass._registerNatives("gov.llnl.sidl.BaseArray");
    }

    public static class Holder {
        private BaseArray d_obj;

        public Holder() {
            this.d_obj = null;
        }

        public Holder(BaseArray obj) {
            this.d_obj = obj;
        }

        public void set(BaseArray obj) {
            this.d_obj = obj;
        }

        public BaseArray get() {
            return this.d_obj;
        }
    }
}

