//
// File:        SymbolException.java
// Package:     gov.llnl.babel.symbols
// Revision:    @(#) $Id: SymbolException.java 4434 2005-03-17 17:05:29Z epperly $
// Description: sidl parser exception for symbol or analysis errors
//
// Copyright (c) 2000-2001, The Regents of the University of Calfornia.
// Produced at the Lawrence Livermore National Laboratory.
// Written by the Components Team <components@llnl.gov>
// UCRL-CODE-2002-054
// All rights reserved.
// 
// This file is part of Babel. For more information, see
// http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
// for Our Notice and the LICENSE file for the GNU Lesser General Public
// License.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License (as published by
// the Free Software Foundation) version 2.1 dated February 1999.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
// conditions of the GNU Lesser General Public License for more details.
// 
// You should have recieved a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package gov.llnl.babel.parsers.sidl;

import gov.llnl.babel.parsers.sidl.Grammar;
import gov.llnl.babel.parsers.sidl.SIDLException;
import gov.llnl.babel.parsers.sidl.Token;

/**
 * A <code>SymbolException</code> is thrown if the specified symbol cannot
 * be found or if there is a symbol name conflict (e.g., a redefinition of
 * a symbol or a misuse).
 */
public class SymbolException extends SIDLException {
   private static final String EOL = "\n";
   private String d_message;

   /**
    * Create a new exception object using the specified token, production,
    * and message.  Initialize the base class with the location of the
    * error and the production number.
    */
   public SymbolException(Token token, int production, String message) {
      super(token.beginLine, token.beginColumn, production);
      d_message = message;
   }

   /**
    * Generate an error message corresponding to this exception.  The
    * error message will report the line number, column number, production,
    * and message.
    */
   public String getMessage() {
      StringBuffer buffer = new StringBuffer();

      buffer.append(d_message);
      buffer.append(EOL);
      buffer.append("Symbol exception at line=");
      buffer.append(String.valueOf(getLineNumber()));
      buffer.append(" column=");
      buffer.append(String.valueOf(getColumnNumber()));
      buffer.append(EOL);

      buffer.append("Grammar production: ");
      buffer.append(Grammar.getProduction(getProductionNumber()));
      buffer.append(EOL);

      buffer.append(d_message);
      buffer.append(EOL);

      return buffer.toString();
   }
}
