/*
 * File:          HelloClient_Component_Impl.c
 * Symbol:        HelloClient.Component-v0.5
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for HelloClient.Component
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "HelloClient.Component" (version 0.5)
 * 
 * The component uses the hello port and provides a go port.
 */

#include "HelloClient_Component_Impl.h"

#line 26 "../../../../babel/examples/cca/hello-client/HelloClient_Component_Impl.c"
/* DO-NOT-DELETE splicer.begin(HelloClient.Component._includes) */
#include <stdio.h>
#include "strop_StringProducerPort.h"
#include "sidl_String.h"
#include "sidl_string_IOR.h"
/* DO-NOT-DELETE splicer.end(HelloClient.Component._includes) */
#line 33 "HelloClient_Component_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_HelloClient_Component__load"

void
impl_HelloClient_Component__load(
  void)
{
#line 44 "../../../../babel/examples/cca/hello-client/HelloClient_Component_Impl.c"
  /* DO-NOT-DELETE splicer.begin(HelloClient.Component._load) */
  /* Insert the implementation of the static class initializer method here... */
  /* DO-NOT-DELETE splicer.end(HelloClient.Component._load) */
#line 50 "HelloClient_Component_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_HelloClient_Component__ctor"

void
impl_HelloClient_Component__ctor(
  /* in */ HelloClient_Component self)
{
#line 59 "../../../../babel/examples/cca/hello-client/HelloClient_Component_Impl.c"
  /* DO-NOT-DELETE splicer.begin(HelloClient.Component._ctor) */
  struct HelloClient_Component__data* data =
    (struct HelloClient_Component__data*) malloc(
      sizeof(struct HelloClient_Component__data));

  data->services = NULL;

  HelloClient_Component__set_data(self, data);
  /* DO-NOT-DELETE splicer.end(HelloClient.Component._ctor) */
#line 73 "HelloClient_Component_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_HelloClient_Component__dtor"

void
impl_HelloClient_Component__dtor(
  /* in */ HelloClient_Component self)
{
#line 81 "../../../../babel/examples/cca/hello-client/HelloClient_Component_Impl.c"
  /* DO-NOT-DELETE splicer.begin(HelloClient.Component._dtor) */
  struct HelloClient_Component__data* data =
    HelloClient_Component__get_data(self);

  if (data->services != NULL) {
    gov_cca_Services_deleteRef(data->services);
  }

  free((void*) data);
  HelloClient_Component__set_data(self, NULL);
  /* DO-NOT-DELETE splicer.end(HelloClient.Component._dtor) */
#line 99 "HelloClient_Component_Impl.c"
}

/*
 * The following method starts the component.
 */

#undef __FUNC__
#define __FUNC__ "impl_HelloClient_Component_go"

int32_t
impl_HelloClient_Component_go(
  /* in */ HelloClient_Component self)
{
#line 105 "../../../../babel/examples/cca/hello-client/HelloClient_Component_Impl.c"
  /* DO-NOT-DELETE splicer.begin(HelloClient.Component.go) */
  struct HelloClient_Component__data* data =
    HelloClient_Component__get_data(self);
  sidl_BaseInterface err = 0;

  gov_cca_Port port = gov_cca_Services_getPort(data->services, "HelloServer", &err);
  strop_StringProducerPort hello = strop_StringProducerPort__cast(port);

  char* saying = strop_StringProducerPort_get(hello);
  printf("%s\n", saying);
  sidl_String_free(saying);

  gov_cca_Services_releasePort(data->services, "HelloServer", &err);
  gov_cca_Port_deleteRef(port);

  return 0;
  /* DO-NOT-DELETE splicer.end(HelloClient.Component.go) */
#line 131 "HelloClient_Component_Impl.c"
}

/*
 * Method <code>setServices</code> is called by the framework.
 */

#undef __FUNC__
#define __FUNC__ "impl_HelloClient_Component_setServices"

void
impl_HelloClient_Component_setServices(
  /* in */ HelloClient_Component self,
  /* in */ gov_cca_Services services)
{
#line 136 "../../../../babel/examples/cca/hello-client/HelloClient_Component_Impl.c"
  /* DO-NOT-DELETE splicer.begin(HelloClient.Component.setServices) */
  struct HelloClient_Component__data* data = HelloClient_Component__get_data(self);
  sidl_BaseInterface ex;

  gov_cca_Services_registerUsesPort(services, "HelloServer", "HelloServer.HelloPort", 0, &ex );

  gov_cca_Services_addProvidesPort( services, gov_cca_Port__cast(self), "GoPort", "gov.cca.ports.GoPort", 0, &ex );

  data->services = services;
  gov_cca_Services_addRef(services);

  /* DO-NOT-DELETE splicer.end(HelloClient.Component.setServices) */
#line 159 "HelloClient_Component_Impl.c"
}
