!
!     File:       HelloDriver.F90
!     Copyright:  (c) 2003 The Regents of the University of California
!     Revision:   @(#) $Revision: 4434 $
!     Date:       $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
!     Description:Simple CCA Hello World F90 client
!
!
#include "decaf_Framework_fAbbrev.h"
#include "sidl_BaseInterface_fAbbrev.h"
#include "sidl_SIDLException_fAbbrev.h"
#include "gov_cca_TypeMap_fAbbrev.h"
#include "gov_cca_Port_fAbbrev.h"
#include "gov_cca_ports_GoPort_fAbbrev.h"
#include "gov_cca_ComponentID_fAbbrev.h"
#include "gov_cca_ConnectionID_fAbbrev.h"

program HelloDriver
  use decaf_Framework
  use sidl_BaseInterface
  use sidl_SIDLException
  use gov_cca_TypeMap
  use gov_cca_Port
  use gov_cca_ports_GoPort
  use gov_cca_ComponentID
  use gov_cca_ConnectionID
  
  type(decaf_Framework_t) :: decaf
  type(gov_cca_ComponentID_t) :: server, client
  type(gov_cca_Port_t) :: port
  type(gov_cca_ports_GoPort_t) :: goPort
  integer(selected_int_kind(9)) :: retval
  type(sidl_SIDLException_t) :: sExcept
  type(sidl_BaseInterface_t) :: iExcept
  type(gov_cca_TypeMap_t) :: properties
  type(gov_cca_ConnectionID_t) :: connectionID

  call new(decaf)

  call createTypeMap( decaf, properties, iExcept )
  call cast(iExcept, sExcept)
  if (not_null(sExcept)) then
     write(*,*) 'createTypeMap threw an exception'
     stop
  end if

  call createInstance(decaf, 'HelloServerInstance', 'HelloServer.Component', &
       properties, server, iExcept)
  call cast(iExcept, sExcept)
  if (not_null(sExcept)) then
     write(*,*) 'createInstance(server) threw an exception'
     stop
  end if
  
  call createInstance(decaf, 'HelloClientInstance', 'HelloClient.Component', &
       properties,  client, iExcept)
  call cast(iExcept, sExcept)
  if (not_null(sExcept)) then
     write(*,*) 'createInstance(client) threw an exception'
     stop
  end if
  call deleteRef(properties)
  
  call connect(decaf, client, 'HelloServer', &
       server, 'HelloServer', connectionID, iExcept)
  call cast(iExcept, sExcept)
  if (not_null(sExcept)) then
     write(*,*) 'connect threw an exception'
     stop
  end if
  call deleteRef(connectionID)

  call lookupPort(decaf, client, 'GoPort', port)
  call cast(port, goPort)
  call go(goPort, retval)
  call deleteRef(goPort)

  call destroyInstance(decaf, server, 0.0, iExcept)
  call destroyInstance(decaf, client, 0.0, iExcept)

! remove remaining references
  call deleteRef(server)
  call deleteRef(client)
  call deleteRef(decaf)
end program HelloDriver
