C
C File:       arraytests.f
C Copyright:  (c) 2002 The Regents of the University of California
C Revision:   @(#) $Revision: 4476 $
C Date:       $Date: 2005-03-24 15:43:50 -0800 (Thu, 24 Mar 2005) $
C Description:Exercise the FORTRAN interface
C
C

 
      subroutine reporttest(test, number, python, tracker)
      implicit none
      integer*4       number
      logical         test, python
      integer*8       tracker 

      call synch_RegOut_getInstance_f(tracker)
      call synch_RegOut_startPart_f(tracker, number)
      if (test) then
         call synch_RegOut_endPart_f(tracker, number, 0)
      else
      if (python) then
         call synch_RegOut_endPart_f(tracker, number, 2)
      else
         call synch_RegOut_endPart_f(tracker, number, 1)
      endif
      endif
      call synch_RegOut_deleteRef_f(tracker)
      number = number + 1
      end 

      subroutine my_force_float(f)
      real f
      return
      end 

      subroutine my_force_fcomplex(f)
      complex  f
      return
      end 

      subroutine checkBoolArrays(test,  python, tracker)
      implicit none
      integer*4 test
      logical  python, retval
      integer*8  barray, tracker
  
      barray = 0
C      call sidl_bool_array_set_null(barray)

      call ArrayTest_ArrayOps_createBool_f(217,barray)
      call reporttest(barray .ne. 0, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkBool_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseBool_f(barray, .true., retval)
      call reporttest(retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeBool_f(218, barray)
      call reporttest(barray .ne. 0, test,  python, tracker)

      call ArrayTest_ArrayOps_checkBool_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseBool_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkBool_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeBool_f(9, barray)

      call ArrayTest_ArrayOps_reverseBool_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkBool_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeBool_f(-1, barray)
      call reporttest(barray .eq. 0, test,  python, tracker)
      
      if (barray .ne. 0) then
        call sidl_bool__array_deleteRef_f(barray)
      endif
  
      end 


      subroutine checkCharArrays(test,  python, tracker)
      implicit none
      integer*4 test
      logical  python, retval
      integer*8  barray, tracker
      
      barray = 0
C      call sidl_bool_array_set_null(barray)

      call ArrayTest_ArrayOps_createChar_f(217,barray)
      call reporttest(barray .ne. 0, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkChar_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseChar_f(barray, .true., retval)
      call reporttest(retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeChar_f(218, barray)
      call reporttest(barray .ne. 0, test,  python, tracker)

      call ArrayTest_ArrayOps_checkChar_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseChar_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkChar_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeChar_f(9, barray)

      call ArrayTest_ArrayOps_reverseChar_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkChar_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeChar_f(-1, barray)
      call reporttest(barray .eq. 0, test,  python, tracker)
      
      if (barray .ne. 0) then
        call sidl_bool__array_deleteRef_f(barray)
      endif
  
      end 

      subroutine checkIntArrays(test,  python, tracker)
      implicit none
      integer*4 test
      logical  python, retval
      integer*8  barray, tracker
      
      barray = 0
C      call sidl_bool_array_set_null(barray)

      call ArrayTest_ArrayOps_createInt_f(217,barray)
      call reporttest(barray .ne. 0, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkInt_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseInt_f(barray, .true., retval)
      call reporttest(retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeInt_f(218, barray)
      call reporttest(barray .ne. 0, test,  python, tracker)

      call ArrayTest_ArrayOps_checkInt_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseInt_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkInt_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeInt_f(9, barray)

      call ArrayTest_ArrayOps_reverseInt_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkInt_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeInt_f(-1, barray)
      call reporttest(barray .eq. 0, test,  python, tracker)
      
      if (barray .ne. 0) then
        call sidl_bool__array_deleteRef_f(barray)
      endif
  
      end 

      subroutine checkLongArrays(test,  python, tracker)
      implicit none
      integer*4 test
      logical  python, retval
      integer*8  barray, tracker
      
      barray = 0
C      call sidl_bool_array_set_null(barray)

      call ArrayTest_ArrayOps_createLong_f(217,barray)
      call reporttest(barray .ne. 0, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkLong_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseLong_f(barray, .true., retval)
      call reporttest(retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeLong_f(218, barray)
      call reporttest(barray .ne. 0, test,  python, tracker)

      call ArrayTest_ArrayOps_checkLong_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseLong_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkLong_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeLong_f(9, barray)

      call ArrayTest_ArrayOps_reverseLong_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkLong_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeLong_f(-1, barray)
      call reporttest(barray .eq. 0, test,  python, tracker)
      
      if (barray .ne. 0) then
        call sidl_bool__array_deleteRef_f(barray)
      endif
  
      end 

      subroutine checkStringArrays(test,  python, tracker)
      implicit none
      integer*4 test
      logical  python, retval
      integer*8  barray, tracker
      
      barray = 0
C      call sidl_bool_array_set_null(barray)

      call ArrayTest_ArrayOps_createString_f(217,barray)
      call reporttest(barray .ne. 0, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkString_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseString_f(barray, .true., retval)
      call reporttest(retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeString_f(218, barray)
      call reporttest(barray .ne. 0, test,  python, tracker)

      call ArrayTest_ArrayOps_checkString_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseString_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkString_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeString_f(9, barray)

      call ArrayTest_ArrayOps_reverseString_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkString_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeString_f(-1, barray)
      call reporttest(barray .eq. 0, test,  python, tracker)
      
      if (barray .ne. 0) then
        call sidl_bool__array_deleteRef_f(barray)
      endif
  
      end 

      subroutine checkDoubleArrays(test,  python, tracker)
      implicit none
      integer*4 test
      logical  python, retval
      integer*8  barray, tracker
      
      barray = 0
C      call sidl_bool_array_set_null(barray)

      call ArrayTest_ArrayOps_createDouble_f(217,barray)
      call reporttest(barray .ne. 0, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkDouble_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseDouble_f(barray, .true., retval)
      call reporttest(retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeDouble_f(218, barray)
      call reporttest(barray .ne. 0, test,  python, tracker)

      call ArrayTest_ArrayOps_checkDouble_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseDouble_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkDouble_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeDouble_f(9, barray)

      call ArrayTest_ArrayOps_reverseDouble_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkDouble_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeDouble_f(-1, barray)
      call reporttest(barray .eq. 0, test,  python, tracker)
      
      if (barray .ne. 0) then
        call sidl_bool__array_deleteRef_f(barray)
      endif
  
      end 

      subroutine checkFloatArrays(test,  python, tracker)
      implicit none
      integer*4 test
      logical  python, retval
      integer*8  barray, tracker
      
      barray = 0
C      call sidl_bool_array_set_null(barray)

      call ArrayTest_ArrayOps_createFloat_f(217,barray)
      call reporttest(barray .ne. 0, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkFloat_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseFloat_f(barray, .true., retval)
      call reporttest(retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeFloat_f(218, barray)
      call reporttest(barray .ne. 0, test,  python, tracker)

      call ArrayTest_ArrayOps_checkFloat_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseFloat_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkFloat_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeFloat_f(9, barray)

      call ArrayTest_ArrayOps_reverseFloat_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkFloat_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeFloat_f(-1, barray)
      call reporttest(barray .eq. 0, test,  python, tracker)
      
      if (barray .ne. 0) then
        call sidl_bool__array_deleteRef_f(barray)
      endif
  
      end 

      subroutine checkFcomplexArrays(test,  python, tracker)
      implicit none
      integer*4 test
      logical  python, retval
      integer*8  barray, tracker
      
      barray = 0
C      call sidl_bool_array_set_null(barray)

      call ArrayTest_ArrayOps_createFcomplex_f(217,barray)
      call reporttest(barray .ne. 0, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkFcomplex_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseFcomplex_f(barray, .true., retval)
      call reporttest(retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeFcomplex_f(218, barray)
      call reporttest(barray .ne. 0, test,  python, tracker)

      call ArrayTest_ArrayOps_checkFcomplex_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseFcomplex_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkFcomplex_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeFcomplex_f(9, barray)

      call ArrayTest_ArrayOps_reverseFcomplex_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkFcomplex_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeFcomplex_f(-1, barray)
      call reporttest(barray .eq. 0, test,  python, tracker)
      
      if (barray .ne. 0) then
        call sidl_bool__array_deleteRef_f(barray)
      endif
  
      end 

      subroutine checkDcomplexArrays(test,  python, tracker)
      implicit none
      integer*4 test
      logical  python, retval
      integer*8  barray, tracker
      
      barray = 0
C      call sidl_bool_array_set_null(barray)

      call ArrayTest_ArrayOps_createDcomplex_f(217,barray)
      call reporttest(barray .ne. 0, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkDcomplex_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseDcomplex_f(barray, .true., retval)
      call reporttest(retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeDcomplex_f(218, barray)
      call reporttest(barray .ne. 0, test,  python, tracker)

      call ArrayTest_ArrayOps_checkDcomplex_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_reverseDcomplex_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkDcomplex_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeDcomplex_f(9, barray)

      call ArrayTest_ArrayOps_reverseDcomplex_f(barray, .false., retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_checkDcomplex_f(barray, retval)
      call reporttest(.not. retval, test,  python, tracker)
      call sidl_bool__array_deleteRef_f(barray)
      
      barray = 0
      
      call ArrayTest_ArrayOps_makeDcomplex_f(-1, barray)
      call reporttest(barray .eq. 0, test,  python, tracker)
      
      if (barray .ne. 0) then
        call sidl_bool__array_deleteRef_f(barray)
      endif
  
      end 

      subroutine check2DoubleArrays(test,  python, tracker)
      implicit none
      integer*4 test
      logical  python, retval
      integer*8  barray, tracker
      
      barray = 0
C      call sidl_bool_array_set_null(barray)

      call ArrayTest_ArrayOps_create2Double_f(21,17,barray)
      call reporttest(barray .ne. 0, test,  python, tracker)
      
      call ArrayTest_ArrayOps_check2Double_f(barray, retval)
      call reporttest(retval, test,  python, tracker)
      
C      call sidl_bool__array_deleteRef_f(barray)
      
      if (barray .ne. 0) then
        call sidl_bool__array_deleteRef_f(barray)
      endif
  
      end 

      subroutine checkRarrays(test, python, tracker)
      implicit none
      integer*4 test
      logical  python, retval
      integer*8  iarray, darray, dcarray, tracker
      integer*4 ir(0:99), ir3(0:5, 0:3, 0:3)
      integer*4 ir7(0:2, 0:2, 0:2, 0:2, 0:3, 0:3, 0:3)
      double precision dr(0:99)
      double complex dcr(0:99)
      call ArrayTest_ArrayOps_initRarray1Int_f(ir, 100)
      call ArrayTest_ArrayOps_checkRarray1Int_f(ir, 100, retval)
      call reporttest(retval, test,  python, tracker)
      
      call ArrayTest_ArrayOps_initRarray3Int_f(ir3, 6,4,4)
      call ArrayTest_ArrayOps_checkRarray3Int_f(ir3, 6,4,4, retval)
      call reporttest(retval, test,  python, tracker)

      call ArrayTest_ArrayOps_initRarray7Int_f(ir7, 3,3,3,3,4,4,4)
      call ArrayTest_ArrayOps_checkRarray7Int_f(ir7,3,3,3,3,4,4,4,
     $     retval)
      call reporttest(retval, test,  python, tracker)

      call ArrayTest_ArrayOps_initRarray1Double_f(dr, 100)
      call ArrayTest_ArrayOps_checkRarray1Double_f(dr, 100, retval)
      call reporttest(retval, test,  python, tracker)

      call ArrayTest_ArrayOps_initRarray1Dcomplex_f(dcr, 100)
      call ArrayTest_ArrayOps_checkRarray1Dcomplex_f(dcr, 100, retval)
      call reporttest(retval, test,  python, tracker)
      end


      program arraytests

      integer*4 test
      integer*8 tracker
      character*80  language
      logical ispython
      language = ' '
C      if (IArgc() .eq. 1) then
C        call GetArg(1, language)
C      endif
      ispython = language .eq. 'Python'
      test = 1
      call synch_RegOut_getInstance_f(tracker)
      call synch_RegOut_setExpectations_f(tracker, 97)

      call synch_RegOut_writeComment_f(tracker, 'Boolean tests')
      call CheckBoolArrays(test,  ispython, tracker)

      call synch_RegOut_writeComment_f(tracker, 'Char tests')
      call CheckCharArrays(test,  ispython, tracker)

      call synch_RegOut_writeComment_f(tracker, 'Int tests')
      call CheckIntArrays(test,  ispython, tracker)

      call synch_RegOut_writeComment_f(tracker, 'Long tests')
      call CheckLongArrays(test,  ispython, tracker)

      call synch_RegOut_writeComment_f(tracker, 'String tests')
      call CheckStringArrays(test,  ispython, tracker)

      call synch_RegOut_writeComment_f(tracker, 'Double tests')
      call CheckDoubleArrays(test,  ispython, tracker)
      
      call synch_RegOut_writeComment_f(tracker, 'Float tests')
      call CheckFloatArrays(test,  ispython, tracker)

      call synch_RegOut_writeComment_f(tracker, 'Fcomplex tests')
      call CheckFcomplexArrays(test,  ispython, tracker)
      
      call synch_RegOut_writeComment_f(tracker, 'Dcomplex tests')
      call CheckDcomplexArrays(test,  ispython, tracker)

      call synch_RegOut_writeComment_f(tracker, '2D double tests')
      call Check2DoubleArrays(test,  ispython, tracker)

      call synch_RegOut_writeComment_f(tracker, 'Rarray tests')
      call CheckRarrays(test,  ispython, tracker)

      call synch_RegOut_close_f(tracker)
      call synch_RegOut_deleteRef_f(tracker)

      end 
