!
! File:       exceptionclient.F90
! Copyright:  (c) 2001-2002 The Regents of the University of California
! Revision:   @(#) $Revision: 4434 $
! Date:       $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
! Description:Simple F90 exception test client
!
!
#include "sidl_BaseInterface_fAbbrev.h"
#include "sidl_SIDLException_fAbbrev.h"
#include "ExceptionTest_Fib_fAbbrev.h"
#include "synch_RegOut_fAbbrev.h"

subroutine starttest(number)
  use synch_RegOut
  implicit none
  integer (selected_int_kind(9)) :: number
  type(synch_RegOut_t) :: tracker
  call getInstance(tracker)
  call startPart(tracker, number)
  call deleteRef(tracker)
end subroutine starttest

subroutine reporttest(test, number)
  use synch_RegOut
  use synch_ResultType
  implicit none
  integer (selected_int_kind(9)) :: number
  type(synch_RegOut_t) :: tracker
  logical                        :: test
  call getInstance(tracker)
  if (test) then
     call endPart(tracker, number, PASS)
  else
     call endPart(tracker, number, FAIL)
  endif
  number = number + 1
  call deleteRef(tracker)
end subroutine reporttest

subroutine reportexc(sExcept)
  use sidl_SIDLException
  implicit none
  type(sidl_SIDLException_t)  :: sExcept
  character (len=100)         :: msg
  character (len=1024)        :: trace

  call getNote(sExcept, msg)
  write (6, *) msg
  call getTrace(sExcept, trace)
  write (6, *) trace
end subroutine reportexc

subroutine testnone(fib, test)
  use ExceptionTest_Fib
  use sidl_BaseInterface
  use sidl_SIDLException
  implicit none
  type(ExceptionTest_Fib_t)      :: fib
  type(sidl_BaseInterface_t)     :: iExcept
  type(sidl_SIDLException_t)     :: sExcept
  integer (selected_int_kind(9)) :: test
  integer (selected_int_kind(9)) :: retval

  call starttest(test)
  call getFib(fib, 10, 25, 200, 0, retval, iExcept)
  if (is_null(iExcept)) then
     call reporttest(.true., test)
     write (6, 100) retval
  else
     call reporttest(.false., test)
     call cast(iExcept, sExcept)
     call reportexc(sExcept)
     call deleteRef(sExcept)
  endif
100 format ('fib= ', I4)
end subroutine testnone

subroutine testneg(fib, test)
  use sidl_BaseInterface
  use sidl_SIDLException
  use ExceptionTest_Fib
  implicit none
  type(ExceptionTest_Fib_t)      :: fib
  type(sidl_BaseInterface_t)     :: iExcept
  type(sidl_SIDLException_t)     :: sExcept
  integer (selected_int_kind(9)) :: test
  integer (selected_int_kind(9)) :: retval
  logical                        :: isone

  call starttest(test)
  call getFib(fib, -1, 10, 10, 0, retval, iExcept)
  if (is_null(iExcept)) then
     call reporttest(.false., test)
     write (6, 100) retval
  else
     call isType(iExcept, &
          'ExceptionTest.NegativeValueException', isone)
     if (isone .eqv. .true.) then
        call reporttest(.true., test)
     else
        call reporttest(.false., test)
     endif
     call cast(iExcept, sExcept)
     call reportexc(sExcept)
     call deleteRef(sExcept)
  endif
100 format ('fib= ', I4)
end subroutine testneg

subroutine testdeep(fib, test)
  use sidl_BaseInterface
  use sidl_SIDLException
  use ExceptionTest_Fib
  implicit none
  type(ExceptionTest_Fib_t)      :: fib
  type(sidl_BaseInterface_t)     :: iExcept
  type(sidl_SIDLException_t)     :: sExcept
  integer (selected_int_kind(9)) :: test
  integer (selected_int_kind(9)) :: retval
  logical                        :: isone

  call starttest(test)
  call getFib (fib, 10, 1, 100, 0, retval, iExcept)
  if (is_null(iExcept)) then
     call reporttest(.false., test)
     write (6, 100) retval
  else
     call isType(iExcept, 'ExceptionTest.TooDeepException', &
          isone)
     if (isone .eqv. .true.) then
        call reporttest(.true., test)
     else
        call reporttest(.false., test)
     endif
     call cast(iExcept, sExcept)
     call reportexc(sExcept)
     call deleteRef(sExcept)
  endif
100 format ('fib= ', I4)
end subroutine testdeep

subroutine testbig(fib, test)
  use sidl_BaseInterface
  use sidl_SIDLException
  use ExceptionTest_Fib
  implicit none
  type(ExceptionTest_Fib_t)      :: fib
  type(sidl_BaseInterface_t)     :: iExcept
  type(sidl_SIDLException_t)     :: sExcept
  integer (selected_int_kind(9)) :: test
  integer (selected_int_kind(9)) :: retval
  integer (selected_int_kind(9)), parameter :: n = 10, max_depth = 100, &
       depth = 0, maxvalue = 1
  logical                        :: isone

  call starttest(test)
  call getFib(fib, n, max_depth, depth, maxvalue, retval, iExcept)
  if (is_null(iExcept)) then
     call reporttest(.false., test)
     write (6, 100) retval
  else
     call isType(iExcept, 'ExceptionTest.TooBigException', &
          isone)
     if (isone .eqv. .true.) then
        call reporttest(.true., test)
     else
        call reporttest(.false., test)
     endif
     call cast(iExcept, sExcept)
     call reportexc(sExcept)
     call deleteRef(sExcept)
  endif
100 format ('fib= ', I4)
end subroutine testbig


program exceptionclient
  use ExceptionTest_Fib
  use synch_RegOut
  implicit none
  integer (selected_int_kind(9))  :: test
  type(synch_RegOut_t)            :: tracker
  type(ExceptionTest_Fib_t)       :: fib

  call getInstance(tracker)
  call setExpectations(tracker, 4)
  call new(fib)

  test = 1

  call writeComment(tracker, 'No Exception test            ')
  call testnone(fib, test)
  call writeComment(tracker, 'Negative Value Exception test')
  call testneg(fib, test)
  call writeComment(tracker, 'Too Deep Exception test      ')
  call testdeep(fib, test)
  call writeComment(tracker, 'Too Big Exception test       ')
  call testbig(fib, test)

  call deleteRef(fib)
  call close(tracker)
  call deleteRef(tracker)
end program exceptionclient
