##
## File:        make.runJava
## Package:     Babel regression checks
## Revision:    $Revision: 4434 $
## Modified:    $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
## Description: automake makefile for run regression tests
##
## Copyright (c) 2000-2002, The Regents of the University of Calfornia.
## Produced at the Lawrence Livermore National Laboratory.
## Written by the Components Team <components@llnl.gov>
## UCRL-CODE-2002-054
## All rights reserved.
##
## This file is part of Babel. For more information, see
## http:##www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
## for Our Notice and the LICENSE file for the GNU Lesser General Public
## License.
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU Lesser General Public License (as published by
## the Free Software Foundation) version 2.1 dated February 1999.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
## conditions of the GNU Lesser General Public License for more details.
##
## You should have recieved a copy of the GNU Lesser General Public License
## along with this program; if not, write to the Free Software Foundation,
## Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA





OUTPUTSIDL=$(srcdir)/../../output/output.sidl

if SUPPORT_JAVA
check_SCRIPTS = runJava2C.sh runJava2Cxx.sh runJava2UCxx.sh \
	runJava2F77.sh runJava2F90.sh runJava2Java.sh

check_LTLIBRARIES = libClient.la
endif

BABELDIR    = $(top_builddir)/bin
INCLUDEDIR  = $(top_builddir)/runtime/sidl
INCLUDEDIR2 = .
LIBSIDL     = $(top_builddir)/runtime/sidl/libsidl.la
LIBSYNC     = ../../output/libC/libOutput.la
PUREBABELGEN = $(STUBSRCS) $(IORHDRS) $(synch_STUBSRCS) $(synch_IORHDRS)
CLEANFILES = $(PUREBABELGEN) babel-temp babel-stamp stamp-installcheck

libClient_la_SOURCES      = $(PUREBABELGEN)
libClient_la_LIBADD       = $(LIBSYNC) $(LIBSIDL) 
libClient_la_LDFLAGS      = -no-undefined -rpath `pwd`/.libs \
			    -release @VERSION@

EXTRA_DIST = $(TESTFILE)
AM_CPPFLAGS   = -I. -I$(INCLUDEDIR) -I$(INCLUDEDIR2) $(JNI_INCLUDES)

$(PUREBABELGEN) : babel-stamp
	@if test -f $@; then \
	  touch $@; \
	else \
	  $(MAKE) $(AM_MAKEFLAGS) babel-stamp; \
	fi

CP = ../../../lib/sidl-@VERSION@.jar:.
if SUPPORT_CYGWIN
  CLASSPATH = `cygpath --path --windows "$(CP)"`
else
  CLASSPATH = $(CP)
endif
JAVAC_FLAGS = -g -d . -classpath "$(CLASSPATH)"

babel-stamp: $(SIDLFILE) $(TESTFILE) $(OUTPUTSIDL)
	@rm -f babel-temp
	@touch babel-temp
	$(SHELL) $(BABELDIR)/babel --client=java \
		--suppress-timestamp $(SIDLFILE)
	$(SHELL) $(BABELDIR)/babel --client=java --make-prefix=synch_ \
		--suppress-timestamp --exclude-external $(OUTPUTSIDL)
	if test "X$(srcdir)" = "X."; then				    \
	  $(JAVAC) $(JAVAC_FLAGS) `find . -name "*.java" -print`;	    \
	else								    \
	  $(JAVAC) $(JAVAC_FLAGS) `find $(srcdir) . -name "*.java" -print`; \
	fi
	rm -f libClient.scl
	echo "<?xml version=\"1.0\" ?>" > libClient.scl
	echo "<scl>" >> libClient.scl
	echo "  <library uri=\""`pwd`"/libClient.la\" scope=\"local\" resolution=\"lazy\" >" >> libClient.scl
	grep __register $(STUBSRCS) $(synch_STUBSRCS) /dev/null | awk 'BEGIN {FS=":"} { print $$1}' | sort -u | sed -e 's/_jniStub.c//g' -e 's/_/./g' | awk ' { printf "    <class name=\"%s\" desc=\"java\" />\n", $$1 }' >> libClient.scl
	echo "  </library>" >> libClient.scl
	echo "</scl>" >> libClient.scl
	@mv -f babel-temp babel-stamp

clean-local:
	rm -f *.a *.so *.scl *.class 
	rm -rf `find * -type d ! -name CVS`
	test "X$(srcdir)" = "X." || rm -f babel.make synch_babel.make \
		$(check_SCRIPTS)

check-local:
	@if test -f stamp-installcheck; then            \
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;           \
	  $(MAKE) $(AM_MAKEFLAGS) clean;                \
	fi
	$(MAKE) $(AM_MAKEFLAGS)

installcheck-local:
	@if test ! -f stamp-installcheck; then          \
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;           \
	  $(MAKE) $(AM_MAKEFLAGS) clean;                \
	fi
	$(MAKE) $(AM_MAKEFLAGS)                         \
	  BABELDIR=$(bindir)				\
	  INCLUDEDIR=$(includedir)	                 \
	  INCLUDEDIR2=$(exec_prefix)/include            \
	  LIBSIDL=$(libdir)/libsidl.la $(check_PROGRAMS) $(check_SCRIPTS) $(check_LTLIBRARIES)
	touch stamp-installcheck

# Make sure Makefile.in is newer than babel.make
dist-hook:
	touch -c $(distdir)/Makefile.in
