/*
 * File:          objarg_Employee_jniStub.c
 * Symbol:        objarg.Employee-v0.5
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Client-side JNI glue code for objarg.Employee
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "objarg_Employee_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct objarg_Employee__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct objarg_Employee__object*) ptr;
}

/*
 * External reference to IOR methods.
 */

static const struct objarg_Employee__external* s_external = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * Provide the data for the employee object to hold.
 * <code>false</code> is returned when the data was unacceptable.
 * <code>true</code> means the employee object was successfully
 * initialized.
 */

static jboolean
jni_init(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name,
  jint _arg_age,
  jfloat _arg_salary,
  jchar _arg_status)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_Employee__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  int32_t _tmp_age = 0;
  float _tmp_salary = 0.0;
  char _tmp_status = (char) 0;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);
  _tmp_age = (int32_t) _arg_age;
  _tmp_salary = (float) _arg_salary;
  _tmp_status = (char) _arg_status;

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_init))(
    _ior,
    _tmp_name,
    _tmp_age,
    _tmp_salary,
    _tmp_status);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Change the name of an employee.
 */

static void
jni_setName(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_Employee__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_setName))(
    _ior,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
}

/*
 * Return the name of an employee.
 */

static jstring
jni_getName(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_Employee__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getName))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);

  return _res;
}

/*
 * Change the age of an employee.
 */

static void
jni_setAge(
  JNIEnv* env,
  jobject obj,
  jint _arg_age)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_Employee__object* _ior = NULL;
  int32_t _tmp_age = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_age = (int32_t) _arg_age;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_setAge))(
    _ior,
    _tmp_age);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Return the age of an employee.
 */

static jint
jni_getAge(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_Employee__object* _ior = NULL;
  int32_t _ior_res = 0;
  jint _res = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getAge))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jint) _ior_res;

  return _res;
}

/*
 * Set an employee's salary.
 */

static void
jni_setSalary(
  JNIEnv* env,
  jobject obj,
  jfloat _arg_salary)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_Employee__object* _ior = NULL;
  float _tmp_salary = 0.0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_salary = (float) _arg_salary;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_setSalary))(
    _ior,
    _tmp_salary);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Return an employee's salary.
 */

static jfloat
jni_getSalary(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_Employee__object* _ior = NULL;
  float _ior_res = 0.0;
  jfloat _res = 0.0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getSalary))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jfloat) _ior_res;

  return _res;
}

/*
 * Set an employee's marital status.
 */

static void
jni_setStatus(
  JNIEnv* env,
  jobject obj,
  jchar _arg_status)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_Employee__object* _ior = NULL;
  char _tmp_status = (char) 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_status = (char) _arg_status;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_setStatus))(
    _ior,
    _tmp_status);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Return an employee's marital status.
 */

static jchar
jni_getStatus(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_Employee__object* _ior = NULL;
  char _ior_res = (char) 0;
  jchar _res = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getStatus))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jchar) _ior_res;

  return _res;
}

/*
 * Register JNI methods with the Java JVM.
 */

void objarg_Employee__register(JNIEnv* env)
{
  JNINativeMethod methods[10];
  jclass cls;

#ifdef SIDL_STATIC_LIBRARY
  s_external = objarg_Employee__externals();
#else
  sidl_DLL dll = sidl_DLL__create();
  const struct objarg_Employee__external*(*dll_f)(void);
  /* check global namespace for symbol first */
  if (dll && sidl_DLL_loadLibrary(dll, "main:", TRUE, FALSE)) {
    dll_f =
      (const struct objarg_Employee__external*(*)(void)) sidl_DLL_lookupSymbol(
        dll, "objarg_Employee__externals");
    s_external = (dll_f ? (*dll_f)() : NULL);
  }
  if (dll) sidl_DLL_deleteRef(dll);
  if (!s_external) {
    dll = sidl_Loader_findLibrary("objarg.Employee",
      "ior/impl", sidl_Scope_SCLSCOPE,
      sidl_Resolve_SCLRESOLVE);
    if (dll) {
      dll_f =
        (const struct objarg_Employee__external*(*)(void)) 
          sidl_DLL_lookupSymbol(
          dll, "objarg_Employee__externals");
      s_external = (dll_f ? (*dll_f)() : NULL);
      sidl_DLL_deleteRef(dll);
    }
  }
  if (!s_external) {
    jclass e = (*env)->FindClass(env, "java/lang/UnsatisfiedLinkError");
    if (e != NULL) {
      (*env)->ThrowNew(env, e, "Could not find implementation for sidl class objarg.Employee");
      (*env)->DeleteLocalRef(env, e);
    }
  }
#endif

  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "init";
  methods[1].signature = "(Ljava/lang/String;IFC)Z";
  methods[1].fnPtr     = (void *)jni_init;
  methods[2].name      = "setName";
  methods[2].signature = "(Ljava/lang/String;)V";
  methods[2].fnPtr     = (void *)jni_setName;
  methods[3].name      = "getName";
  methods[3].signature = "()Ljava/lang/String;";
  methods[3].fnPtr     = (void *)jni_getName;
  methods[4].name      = "setAge";
  methods[4].signature = "(I)V";
  methods[4].fnPtr     = (void *)jni_setAge;
  methods[5].name      = "getAge";
  methods[5].signature = "()I";
  methods[5].fnPtr     = (void *)jni_getAge;
  methods[6].name      = "setSalary";
  methods[6].signature = "(F)V";
  methods[6].fnPtr     = (void *)jni_setSalary;
  methods[7].name      = "getSalary";
  methods[7].signature = "()F";
  methods[7].fnPtr     = (void *)jni_getSalary;
  methods[8].name      = "setStatus";
  methods[8].signature = "(C)V";
  methods[8].fnPtr     = (void *)jni_setStatus;
  methods[9].name      = "getStatus";
  methods[9].signature = "()C";
  methods[9].fnPtr     = (void *)jni_getStatus;


  cls = (*env)->FindClass(env, "objarg/Employee");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 10);
    (*env)->DeleteLocalRef(env, cls);
  }
}
