/*
 * File:          sidl_ClassInfoI_jniStub.c
 * Symbol:        sidl.ClassInfoI-v0.9.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.ClassInfoI
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_ClassInfoI_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct sidl_ClassInfoI__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct sidl_ClassInfoI__object*) ptr;
}

/*
 * External reference to IOR methods.
 */

static const struct sidl_ClassInfoI__external* s_external = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * Set the name of the class.
 */

static void
jni_setName(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_ClassInfoI__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_setName))(
    _ior,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
}

/*
 * Set the IOR major and minor version numbers.
 */

static void
jni_setIORVersion(
  JNIEnv* env,
  jobject obj,
  jint _arg_major,
  jint _arg_minor)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_ClassInfoI__object* _ior = NULL;
  int32_t _tmp_major = 0;
  int32_t _tmp_minor = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_major = (int32_t) _arg_major;
  _tmp_minor = (int32_t) _arg_minor;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_setIORVersion))(
    _ior,
    _tmp_major,
    _tmp_minor);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Return the name of the class.
 */

static jstring
jni_getName(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_ClassInfoI__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getName))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);

  return _res;
}

/*
 * Get the version of the intermediate object representation.
 * This will be in the form of major_version.minor_version.
 */

static jstring
jni_getIORVersion(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_ClassInfoI__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getIORVersion))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);

  return _res;
}

/*
 * Register JNI methods with the Java JVM.
 */

void sidl_ClassInfoI__register(JNIEnv* env)
{
  JNINativeMethod methods[5];
  jclass cls;

  s_external = sidl_ClassInfoI__externals();
  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "setName";
  methods[1].signature = "(Ljava/lang/String;)V";
  methods[1].fnPtr     = (void *)jni_setName;
  methods[2].name      = "setIORVersion";
  methods[2].signature = "(II)V";
  methods[2].fnPtr     = (void *)jni_setIORVersion;
  methods[3].name      = "getName";
  methods[3].signature = "()Ljava/lang/String;";
  methods[3].fnPtr     = (void *)jni_getName;
  methods[4].name      = "getIORVersion";
  methods[4].signature = "()Ljava/lang/String;";
  methods[4].fnPtr     = (void *)jni_getIORVersion;


  cls = (*env)->FindClass(env, "sidl/ClassInfoI");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 5);
    (*env)->DeleteLocalRef(env, cls);
  }
}
