/*
 * File:          synch_RegOut_jniStub.c
 * Symbol:        synch.RegOut-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Client-side JNI glue code for synch.RegOut
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "synch_RegOut_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct synch_RegOut__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct synch_RegOut__object*) ptr;
}

/*
 * External reference to IOR methods.
 */

static const struct synch_RegOut__external* s_external = NULL;

/*
 * External reference to static EPV.
 */

static const struct synch_RegOut__sepv* s_sepv = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * In some circumstances, it is necessary to use the
 * singleton pattern.
 */

static jobject
jni_getInstance(
  JNIEnv* env,
  jclass  cls)
{
  /*
   * Declare return and temporary variables.
   */

  struct synch_RegOut__object* _ior_res = (struct synch_RegOut__object*) NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */


  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_getInstance))();

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_cls(env, _ior_res, "synch.RegOut");

  return _res;
}

/*
 * Tell this class how many parts to expect.
 * Calling this method twice or after any of the other
 * methods in this class causes it to execute
 * forceFailure.
 * @param numparts  a negative number indicates the number
 *                  of parts is unknown
 */

static void
jni_setExpectations(
  JNIEnv* env,
  jobject obj,
  jint _arg_numparts)
{
  /*
   * Declare return and temporary variables.
   */

  struct synch_RegOut__object* _ior = NULL;
  int32_t _tmp_numparts = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_numparts = (int32_t) _arg_numparts;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_setExpectations))(
    _ior,
    _tmp_numparts);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Return the current part number.
 */

static jint
jni_getCurrentPart(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct synch_RegOut__object* _ior = NULL;
  int32_t _ior_res = 0;
  jint _res = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getCurrentPart))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jint) _ior_res;

  return _res;
}

/*
 * Print the start part line.
 */

static void
jni_startPart(
  JNIEnv* env,
  jobject obj,
  jint _arg_part)
{
  /*
   * Declare return and temporary variables.
   */

  struct synch_RegOut__object* _ior = NULL;
  int32_t _tmp_part = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_part = (int32_t) _arg_part;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_startPart))(
    _ior,
    _tmp_part);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Print the end part line.
 */

static void
jni_endPart(
  JNIEnv* env,
  jobject obj,
  jint _arg_part,
  jint _arg_res)
{
  /*
   * Declare return and temporary variables.
   */

  struct synch_RegOut__object* _ior = NULL;
  int32_t _tmp_part = 0;
  enum synch_ResultType__enum _tmp_res = (enum synch_ResultType__enum) 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_part = (int32_t) _arg_part;
  _tmp_res = (enum synch_ResultType__enum) _arg_res;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_endPart))(
    _ior,
    _tmp_part,
    _tmp_res);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Print COMMENT: <comment>\n.
 */

static void
jni_writeComment(
  JNIEnv* env,
  jobject obj,
  jstring _arg_comment)
{
  /*
   * Declare return and temporary variables.
   */

  struct synch_RegOut__object* _ior = NULL;
  char* _tmp_comment = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_comment = sidl_Java_J2I_string(env, _arg_comment);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_writeComment))(
    _ior,
    _tmp_comment);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_comment);
}

/*
 * Unconditionally fail right now.
 */

static void
jni_forceFailure(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct synch_RegOut__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_forceFailure))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Finish the test. This is called by the destructor if you
 * forget.
 */

static void
jni_close(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct synch_RegOut__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_close))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Register JNI methods with the Java JVM.
 */

void synch_RegOut__register(JNIEnv* env)
{
  JNINativeMethod methods[9];
  jclass cls;

#ifdef SIDL_STATIC_LIBRARY
  s_external = synch_RegOut__externals();
#else
  sidl_DLL dll = sidl_DLL__create();
  const struct synch_RegOut__external*(*dll_f)(void);
  /* check global namespace for symbol first */
  if (dll && sidl_DLL_loadLibrary(dll, "main:", TRUE, FALSE)) {
    dll_f =
      (const struct synch_RegOut__external*(*)(void)) sidl_DLL_lookupSymbol(
        dll, "synch_RegOut__externals");
    s_external = (dll_f ? (*dll_f)() : NULL);
  }
  if (dll) sidl_DLL_deleteRef(dll);
  if (!s_external) {
    dll = sidl_Loader_findLibrary("synch.RegOut",
      "ior/impl", sidl_Scope_SCLSCOPE,
      sidl_Resolve_SCLRESOLVE);
    if (dll) {
      dll_f =
        (const struct synch_RegOut__external*(*)(void)) sidl_DLL_lookupSymbol(
          dll, "synch_RegOut__externals");
      s_external = (dll_f ? (*dll_f)() : NULL);
      sidl_DLL_deleteRef(dll);
    }
  }
  if (!s_external) {
    jclass e = (*env)->FindClass(env, "java/lang/UnsatisfiedLinkError");
    if (e != NULL) {
      (*env)->ThrowNew(env, e, "Could not find implementation for sidl class synch.RegOut");
      (*env)->DeleteLocalRef(env, e);
    }
  }
#endif

  s_sepv = (*(s_external->getStaticEPV))();

  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "getInstance";
  methods[1].signature = "()Lsynch/RegOut;";
  methods[1].fnPtr     = (void *)jni_getInstance;
  methods[2].name      = "setExpectations";
  methods[2].signature = "(I)V";
  methods[2].fnPtr     = (void *)jni_setExpectations;
  methods[3].name      = "getCurrentPart";
  methods[3].signature = "()I";
  methods[3].fnPtr     = (void *)jni_getCurrentPart;
  methods[4].name      = "startPart";
  methods[4].signature = "(I)V";
  methods[4].fnPtr     = (void *)jni_startPart;
  methods[5].name      = "endPart";
  methods[5].signature = "(II)V";
  methods[5].fnPtr     = (void *)jni_endPart;
  methods[6].name      = "writeComment";
  methods[6].signature = "(Ljava/lang/String;)V";
  methods[6].fnPtr     = (void *)jni_writeComment;
  methods[7].name      = "forceFailure";
  methods[7].signature = "()V";
  methods[7].fnPtr     = (void *)jni_forceFailure;
  methods[8].name      = "close";
  methods[8].signature = "()V";
  methods[8].fnPtr     = (void *)jni_close;


  cls = (*env)->FindClass(env, "synch/RegOut");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 9);
    (*env)->DeleteLocalRef(env, cls);
  }
}
