/*
 * File:          sort_SortTest_Impl.c
 * Symbol:        sort.SortTest-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for sort.SortTest
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sort.SortTest" (version 0.1)
 * 
 * Run a bunch of sorts through a stress test.
 */

#include "sort_SortTest_Impl.h"

#line 26 "../../../../babel/regression/sort/libC/sort_SortTest_Impl.c"
/* DO-NOT-DELETE splicer.begin(sort.SortTest._includes) */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "sort_CompInt.h"
#include "sort_IntegerContainer.h"
#include "synch.h"

static const int32_t s_testSizes[] = {
  0,
  1,
  2,
  3,
  4,
  7,
  10,
  51,
  100,
  -1
};

static int
notSorted(sort_Container cont,
          sort_Comparator comp)
{
  const int32_t length = sort_Container_getLength(cont);
  int32_t i;
  for(i = 1 ; i < length ; ++i ){
    if (sort_Container_compare(cont, i-1, i, comp) > 0) return TRUE;
  }
  return FALSE;
}

static void
sortAndReport(sort_SortingAlgorithm alg,
              sort_Container cont,
              sort_Comparator comp,
              sidl_bool *result)
{
  char buffer[64];
  synch_RegOut tracker = synch_RegOut_getInstance();
  sort_Counter swpCnt = NULL;
  sort_Counter cmpCnt = NULL;
  sort_SortingAlgorithm_reset(alg);
  sort_SortingAlgorithm_sort(alg, cont, comp);
  swpCnt = sort_SortingAlgorithm_getSwapCounter(alg);
  cmpCnt = sort_SortingAlgorithm_getCompareCounter(alg);
  sprintf(buffer, "compares (%d) swaps (%d)",
         sort_Counter_getCount(cmpCnt),
         sort_Counter_getCount(swpCnt));
  synch_RegOut_writeComment(tracker, buffer);
  sort_Counter_deleteRef(cmpCnt);
  sort_Counter_deleteRef(swpCnt);
  if (notSorted(cont, comp)) {
    synch_RegOut_writeComment(tracker, "sort failed!!");
    *result = FALSE;
  }
  synch_RegOut_deleteRef(tracker);
}
/* DO-NOT-DELETE splicer.end(sort.SortTest._includes) */
#line 87 "sort_SortTest_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortTest__load"

void
impl_sort_SortTest__load(
  void)
{
#line 98 "../../../../babel/regression/sort/libC/sort_SortTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sort.SortTest._load) */
  /* Insert the implementation of the static class initializer method here... */
  /* DO-NOT-DELETE splicer.end(sort.SortTest._load) */
#line 104 "sort_SortTest_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortTest__ctor"

void
impl_sort_SortTest__ctor(
  /* in */ sort_SortTest self)
{
#line 113 "../../../../babel/regression/sort/libC/sort_SortTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sort.SortTest._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.SortTest._ctor) */
#line 121 "sort_SortTest_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortTest__dtor"

void
impl_sort_SortTest__dtor(
  /* in */ sort_SortTest self)
{
#line 129 "../../../../babel/regression/sort/libC/sort_SortTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sort.SortTest._dtor) */
  /* Insert the implementation of the destructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.SortTest._dtor) */
#line 139 "sort_SortTest_Impl.c"
}

/*
 * Perform the array stress test.
 * 
 * Return true if all the algorithms work okay.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortTest_stressTest"

sidl_bool
impl_sort_SortTest_stressTest(
  /* in */ struct sort_SortingAlgorithm__array* algs)
{
#line 147 "../../../../babel/regression/sort/libC/sort_SortTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sort.SortTest.stressTest) */
  sidl_bool result = FALSE;
  if (algs) {
    const int32_t lower = sort_SortingAlgorithm__array_lower(algs, 0);
    const int32_t upper = sort_SortingAlgorithm__array_upper(algs, 0);
    int32_t i,j;
    result = TRUE;
    for(i = lower; i <= upper; ++i) {
      sort_SortingAlgorithm alg =
        sort_SortingAlgorithm__array_get1(algs, i);
      if (alg) {
        synch_RegOut tracker = synch_RegOut_getInstance();
        sort_IntegerContainer data = sort_IntegerContainer__create();
        sort_Container cont = sort_Container__cast(data);
        sort_CompInt intcomp = sort_CompInt__create();
        sort_Comparator comp = sort_Comparator__cast(intcomp);
        char *name           = sort_SortingAlgorithm_getName(alg);
        char *buffer         = malloc(25 + strlen(name) + 14);
        j = 0;
        sprintf(buffer, "****ALGORITHM IS %s****", name);
        synch_RegOut_writeComment(tracker, buffer);
        free((void *)name);
        while (s_testSizes[j] >= 0) {
          sort_CompInt_setSortIncreasing(intcomp, TRUE);
          sprintf(buffer, "DATA SIZE %d", s_testSizes[j]);
          synch_RegOut_writeComment(tracker, buffer);
          sort_IntegerContainer_setLength(data, s_testSizes[j]);
          sortAndReport(alg, cont, comp, &result);
          synch_RegOut_writeComment(tracker, "pre-sorted list");
          sortAndReport(alg, cont, comp, &result);
          synch_RegOut_writeComment(tracker, "reverse sorted list");
          sort_CompInt_setSortIncreasing(intcomp, FALSE);
          sortAndReport(alg, cont, comp, &result);
          ++j;
        }
        free(buffer);
        sort_IntegerContainer_deleteRef(data);
        sort_SortingAlgorithm_deleteRef(alg);
        sort_CompInt_deleteRef(intcomp);
        synch_RegOut_deleteRef(tracker);
      }
      else{
        result = FALSE;
      }
    }
  }
  fflush(stdout);
  return result;
  /* DO-NOT-DELETE splicer.end(sort.SortTest.stressTest) */
#line 205 "sort_SortTest_Impl.c"
}
