//
// File:        SortTest.java
// Package:     
// Copyright:   (c) 2002 The Regents of the University of California
// Revision:    @(#) $Revision: 4434 $
// Date:        $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
// Description: Regression test for sorting and abstract classes
// 

public class SortTest {

  private final static String[] s_results = {
    "synch.ResultType.PASS",
    "FAIL",
    "XFAIL",
    "Xsynch.ResultType.PASS",
  };

  private static int s_part = 0;
  private static int s_result = synch.ResultType.PASS;
  private static synch.RegOut tracker = new synch.RegOut();  
  /**
   * Check the results of the test case.
   */
  //Comments should really be passed in here.
  private static void startTest(String test) {
    tracker.startPart(++s_part);
    if(test != null)
      tracker.writeComment(test);
  }
  
  private static void check(int expected, boolean pass, String test ) {
    if (test != null)
      tracker.writeComment(test);

    if(expected == synch.ResultType.PASS)
      if(pass)
        tracker.endPart(s_part, synch.ResultType.PASS);
      else
        tracker.endPart(s_part, synch.ResultType.FAIL);
    else if (expected == synch.ResultType.XFAIL)
      if(pass)
        tracker.endPart(s_part, synch.ResultType.XPASS);
      else
        tracker.endPart(s_part, synch.ResultType.XFAIL);
    else
      tracker.endPart(s_part, synch.ResultType.FAIL);
  }


  public static void main(String args[]) {
    try {
      tracker = new synch.RegOut();
      tracker.setExpectations(-1);
      s_part = 0;
      s_result = synch.ResultType.PASS;
      sort.SortingAlgorithm.Array1 algs = 
        new sort.SortingAlgorithm.Array1(3,true); 
     
      sort.MergeSort merge = new sort.MergeSort();
      sort.HeapSort heap = new sort.HeapSort();
      sort.QuickSort quick = new sort.QuickSort();

      startTest(null);
      check(synch.ResultType.PASS, (merge != null), "(merge != null)");
      startTest(null);
      check(synch.ResultType.PASS, (heap != null), "(heap != null)");
      startTest(null);
      check(synch.ResultType.PASS, (quick != null), "(quick != null)");
      algs.set(0, (sort.SortingAlgorithm)merge);
      algs.set(1, (sort.SortingAlgorithm)heap);
      algs.set(2, (sort.SortingAlgorithm)quick);

      System.out.println(((sort.SortingAlgorithm)merge).getName());
      

      startTest(null);
      check(synch.ResultType.PASS, sort.SortTest.stressTest(algs), "Stress Test!");
      System.gc();

      tracker.close();
      Runtime.getRuntime().exit(0); /* workaround for Linux JVM 1.3.1 bug */
    }
    catch (Throwable ex) {
      tracker.close();
      //System.out.println("TEST_RESULT FAIL");
      //System.out.println(ex.toString());
      ex.printStackTrace(System.err);
      System.exit(1);
      
    }
  }
}
