/*
 * File:          Strings_Cstring_Impl.c
 * Symbol:        Strings.Cstring-v1.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for Strings.Cstring
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "Strings.Cstring" (version 1.1)
 * 
 * Class to allow testing of string passing using every possible mode.
 */

#include "Strings_Cstring_Impl.h"

#line 26 "../../../../babel/regression/strings/libC/Strings_Cstring_Impl.c"
/* DO-NOT-DELETE splicer.begin(Strings.Cstring._includes) */
#include <string.h>
#include "sidl_String.h"
/* DO-NOT-DELETE splicer.end(Strings.Cstring._includes) */
#line 31 "Strings_Cstring_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring__load"

void
impl_Strings_Cstring__load(
  void)
{
#line 42 "../../../../babel/regression/strings/libC/Strings_Cstring_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring._load) */
  /* Insert the implementation of the static class initializer method here... */
  /* DO-NOT-DELETE splicer.end(Strings.Cstring._load) */
#line 48 "Strings_Cstring_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring__ctor"

void
impl_Strings_Cstring__ctor(
  /* in */ Strings_Cstring self)
{
#line 57 "../../../../babel/regression/strings/libC/Strings_Cstring_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(Strings.Cstring._ctor) */
#line 65 "Strings_Cstring_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring__dtor"

void
impl_Strings_Cstring__dtor(
  /* in */ Strings_Cstring self)
{
#line 73 "../../../../babel/regression/strings/libC/Strings_Cstring_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring._dtor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(Strings.Cstring._dtor) */
#line 83 "Strings_Cstring_Impl.c"
}

/*
 * If <code>nonNull</code> is <code>true</code>, this will
 * return "Three"; otherwise, it will return a NULL or empty string.
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_returnback"

char*
impl_Strings_Cstring_returnback(
  /* in */ Strings_Cstring self,
  /* in */ sidl_bool nonNull)
{
#line 91 "../../../../babel/regression/strings/libC/Strings_Cstring_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.returnback) */
  return nonNull ? sidl_String_strdup("Three") : NULL;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.returnback) */
#line 103 "Strings_Cstring_Impl.c"
}

/*
 * This will return <code>true</code> iff <code>c</code> equals "Three".
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_passin"

sidl_bool
impl_Strings_Cstring_passin(
  /* in */ Strings_Cstring self,
  /* in */ const char* c)
{
#line 108 "../../../../babel/regression/strings/libC/Strings_Cstring_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.passin) */
  return (c && !strcmp(c,"Three")) ? TRUE : FALSE;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.passin) */
#line 122 "Strings_Cstring_Impl.c"
}

/*
 * If <code>nonNull</code> is <code>true</code>, this will return
 * "Three" in <code>c</code>; otherwise, it will return a null or
 * empty string. The return value is <code>false</code> iff 
 * the outgoing value of <code>c</code> is <code>null</code>.
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_passout"

sidl_bool
impl_Strings_Cstring_passout(
  /* in */ Strings_Cstring self,
  /* in */ sidl_bool nonNull,
  /* out */ char** c)
{
#line 129 "../../../../babel/regression/strings/libC/Strings_Cstring_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.passout) */
  *c = nonNull ? sidl_String_strdup("Three") : NULL;
  return (*c == NULL) ? FALSE : TRUE;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.passout) */
#line 146 "Strings_Cstring_Impl.c"
}

/*
 * Method:  passinout[]
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_passinout"

sidl_bool
impl_Strings_Cstring_passinout(
  /* in */ Strings_Cstring self,
  /* inout */ char** c)
{
#line 147 "../../../../babel/regression/strings/libC/Strings_Cstring_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.passinout) */
  char * s = "s";
  char * temp;
  if ( *c == NULL ) { 
    return FALSE;
  }
  if ((temp=(char*)malloc( (strlen(*c) + 2) * sizeof(char) )) == NULL ) { 
    return FALSE;
  }
  strcpy( temp, *c );
  strcat( temp, s );
  free(*c);
  *c = NULL;
  if ( temp[0] >= 'a' && temp[0] <= 'z' ) { 
    temp[0] += 'A' - 'a';
  } else if ( temp[0] >= 'A' && temp[0] <= 'Z' ) { 
    temp[0] += 'a' - 'A';
  }
  *c = temp;
  return TRUE;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.passinout) */
#line 183 "Strings_Cstring_Impl.c"
}

/*
 * Method:  passeverywhere[]
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_passeverywhere"

char*
impl_Strings_Cstring_passeverywhere(
  /* in */ Strings_Cstring self,
  /* in */ const char* c1,
  /* out */ char** c2,
  /* inout */ char** c3)
{
#line 184 "../../../../babel/regression/strings/libC/Strings_Cstring_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.passeverywhere) */
  char * temp;  
  *c2 = NULL;
  if ( *c3 == NULL ) {
    return NULL;
  }
  temp = *c3;
  temp[ strlen( temp ) - 1 ] = '\0'; /* remove last character */
  if ( temp[0] >= 'a' && temp[0] <= 'z' ) { 
    temp[0] += 'A' - 'a';
  } else if ( temp[0] >= 'A' && temp[0] <= 'Z' ) { 
    temp[0] += 'a' - 'A';
  }
  *c3 = temp;
  *c2 = sidl_String_strdup("Three");
  return (c1 && !(strcmp(c1,"Three")) ) ? sidl_String_strdup("Three") : NULL;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.passeverywhere) */
#line 218 "Strings_Cstring_Impl.c"
}

/*
 * Method:  mixedarguments[]
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_mixedarguments"

sidl_bool
impl_Strings_Cstring_mixedarguments(
  /* in */ Strings_Cstring self,
  /* in */ const char* s1,
  /* in */ char c1,
  /* in */ const char* s2,
  /* in */ char c2)
{
#line 218 "../../../../babel/regression/strings/libC/Strings_Cstring_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.mixedarguments) */
  return (s1 && s2 && (c1 == c2) && !strcmp(s1, s2)) ? TRUE : FALSE;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.mixedarguments) */
#line 240 "Strings_Cstring_Impl.c"
}
