/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHMethodDeclaration;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReturnControl;
import java.io.Serializable;

class BshMethod
implements Serializable {
    public BSHMethodDeclaration method;
    NameSpace declaringNameSpace;

    public BshMethod(BSHMethodDeclaration bSHMethodDeclaration, NameSpace nameSpace) {
        this.method = bSHMethodDeclaration;
        this.declaringNameSpace = nameSpace;
    }

    public Class[] getArgTypes() {
        return this.method.params.argTypes;
    }

    public Object invokeDeclaredMethod(Object[] objectArray, Interpreter interpreter) throws EvalError {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (objectArray.length != this.method.params.numArgs) {
            try {
                String string = (String)this.declaringNameSpace.get("bsh.help." + this.method.name, interpreter);
                interpreter.println(string);
                return Primitive.VOID;
            }
            catch (Exception exception) {
                throw new EvalError("Wrong number of arguments for local method: " + this.method.name, this.method);
            }
        }
        NameSpace nameSpace = new NameSpace(this.declaringNameSpace, this.method.name);
        int n = 0;
        while (n < this.method.params.numArgs) {
            if (this.method.params.argTypes[n] != null) {
                try {
                    objectArray[n] = NameSpace.checkAssignableFrom(objectArray[n], this.method.params.argTypes[n]);
                }
                catch (EvalError evalError) {
                    throw new EvalError("Incorrect argument type for parameter: " + this.method.params.argNames[n] + " in method: " + this.method.name + ": " + evalError.getMessage(), this.method);
                }
                nameSpace.setTypedVariable(this.method.params.argNames[n], this.method.params.argTypes[n], objectArray[n], false);
            } else {
                if (objectArray[n] == Primitive.VOID) {
                    throw new EvalError("Attempt to pass void parameter: " + this.method.params.argNames[n] + " to method: " + this.method.name, this.method);
                }
                nameSpace.setVariable(this.method.params.argNames[n], objectArray[n]);
            }
            ++n;
        }
        Object object = this.method.block.eval(nameSpace, interpreter);
        if (object instanceof ReturnControl) {
            ReturnControl returnControl = (ReturnControl)object;
            if (returnControl.kind == 41) {
                object = ((ReturnControl)object).value;
            } else {
                throw new EvalError("continue or break in method body", this.method);
            }
        }
        if (this.method.returnType != null) {
            if (this.method.returnType == Primitive.VOID) {
                return this.method.returnType;
            }
            try {
                object = NameSpace.checkAssignableFrom(object, (Class)this.method.returnType);
            }
            catch (EvalError evalError) {
                throw new EvalError("Incorrect type returned from method: " + this.method.name + evalError.getMessage(), this.method);
            }
        }
        return object;
    }

    public String toString() {
        return "Bsh Method: " + this.method.name;
    }
}

