
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.utilities;

/**
 * Provides mechanisms for sorting arrays.
 * Better mechanisms are provided in java.util.Array in JDK1.2; these
 * are merely provided for code that must be compatible with JDK1.1.
 */
public class Sorter {
    /**
     * Sort an array of integers in ascending order.
     * Uses a quadratic time insertion sort.
     *
     * @param data the array to be sorted.
     */
    public static void sort(int[] data) {
        int tot = data.length;
        int current, pos;
        int minPos;
        int tmp;
        for (current = 0; current < tot-1; current++) {
            // Find the integer to place in current's position.
            minPos = current;
            for (pos = current+1; pos < tot; pos++)
                if (data[pos] < data[minPos])
                    minPos = pos;

            // Swap the two integers.
            if (minPos != current) {
                tmp = data[minPos];
                data[minPos] = data[current];
                data[current] = tmp;
            }
        }
    }
}

