package org.biojava.utils.bytecode;

/**
 * Instructions which take a one-byte operand.
 *
 * @author Thomas Down
 * @author Matthew Pocock
 */

class ByteInstruction implements Instruction {
  private final byte opcode;
  private final byte val;
  private final int delta;
  
  ByteInstruction(byte opcode, byte val, int delta) {
    this.opcode = opcode;
    this.val = val;
    this.delta = delta;
  }
  
  public void writeCode(CodeContext ctx) throws CodeException {
    ctx.writeByte(opcode);
    ctx.writeByte(val);
  }
  
  public int stackDepth() {
    return Math.max(delta, 0);
  }
  
  public int stackDelta() {
    return delta;
  }
}
