/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.FontState;

public class BlockContainer
extends FObj {
    FontState fs;
    ColorType backgroundColor;
    int paddingTop;
    int paddingBottom;
    int paddingLeft;
    int paddingRight;
    int position;
    int top;
    int bottom;
    int left;
    int right;
    int width;
    int height;
    ColorType borderColor;
    int borderWidth;
    int borderStyle;
    AreaContainer areaContainer;
    PageSequence pageSequence;

    protected BlockContainer(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:block-container";
    }

    public Status layout(Area area) throws FOPException {
        int n;
        Object object;
        if (this.marker == -1000) {
            this.marker = 0;
            String string = this.properties.get("font-family").getString();
            object = this.properties.get("font-style").getString();
            String string2 = this.properties.get("font-weight").getString();
            n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, (String)object, string2, n);
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.paddingLeft = this.paddingTop = this.properties.get("padding").getLength().mvalue();
            this.paddingRight = this.paddingTop;
            this.paddingBottom = this.paddingTop;
            if (this.paddingTop == 0) {
                this.paddingTop = this.properties.get("padding-top").getLength().mvalue();
                this.paddingLeft = this.properties.get("padding-left").getLength().mvalue();
                this.paddingBottom = this.properties.get("padding-bottom").getLength().mvalue();
                this.paddingRight = this.properties.get("padding-right").getLength().mvalue();
            }
            this.position = this.properties.get("position").getEnum();
            this.top = this.properties.get("top").getLength().mvalue();
            this.bottom = this.properties.get("bottom").getLength().mvalue();
            this.left = this.properties.get("left").getLength().mvalue();
            this.right = this.properties.get("right").getLength().mvalue();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.borderColor = this.properties.get("border-color").getColorType();
            this.borderWidth = this.properties.get("border-width").getLength().mvalue();
            this.borderStyle = this.properties.get("border-style").getEnum();
        }
        boolean bl = false;
        object = (AreaContainer)area;
        if (this.width == 0 && this.height == 0) {
            this.width = this.right - this.left;
            this.height = this.bottom - this.top;
        }
        this.areaContainer = new AreaContainer(this.fs, ((AreaContainer)object).getXPosition() + this.left, ((AreaContainer)object).getYPosition() - this.top, this.width, this.height, this.position);
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setPadding(this.paddingTop, this.paddingLeft, this.paddingBottom, this.paddingRight);
        this.areaContainer.setBorderStyle(this.borderStyle, this.borderStyle, this.borderStyle, this.borderStyle);
        this.areaContainer.setBorderWidth(this.borderWidth, this.borderWidth, this.borderWidth, this.borderWidth);
        this.areaContainer.setBorderColor(this.borderColor, this.borderColor, this.borderColor, this.borderColor);
        this.areaContainer.start();
        int n2 = this.children.size();
        n = this.marker;
        while (n < n2) {
            FObj fObj = (FObj)this.children.elementAt(n);
            Status status = fObj.layout(this.areaContainer);
            status.isIncomplete();
            if (status.getCode() == 7) {
                bl = true;
            }
            ++n;
        }
        this.areaContainer.end();
        if (this.position == 3) {
            this.areaContainer.setHeight(this.height);
        }
        area.addChild(this.areaContainer);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new BlockContainer(fObj, propertyList);
        }
    }
}

