/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.hsqldb.ByteArray;
import org.hsqldb.Column;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcConnection;
import org.hsqldb.jdbcStatement;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement,
CallableStatement {
    private String sSql;
    private Vector vParameter;

    jdbcPreparedStatement(jdbcConnection jdbcConnection2, String string) {
        super(jdbcConnection2);
        this.sSql = string;
        this.vParameter = new Vector();
    }

    public void addBatch() throws SQLException {
        throw this.getNotSupported();
    }

    private String build() {
        if (this.vParameter.isEmpty()) {
            return this.sSql;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this.sSql.length();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            char c = this.sSql.charAt(n3);
            if (c == '?' && !bl && !bl2) {
                stringBuffer.append(this.getParameter(n++));
            } else {
                if (c == '\'' && !bl2) {
                    bl ^= true;
                } else if (c == '\"' && !bl) {
                    bl2 ^= true;
                }
                stringBuffer.append(c);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public void clearParameters() {
        this.vParameter.removeAllElements();
    }

    public boolean execute() throws SQLException {
        return super.execute(this.build());
    }

    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.build());
    }

    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this.build());
    }

    public Array getArray(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public Blob getBlob(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public boolean getBoolean(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public byte getByte(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public byte[] getBytes(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Clob getClob(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Date getDate(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw this.getNotSupported();
    }

    public double getDouble(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public float getFloat(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public int getInt(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public long getLong(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw this.getNotSupported();
    }

    private SQLException getNotSupported() {
        return Trace.error(19);
    }

    public Object getObject(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw this.getNotSupported();
    }

    private String getParameter(int n) {
        if (n >= this.vParameter.size()) {
            return null;
        }
        return (String)this.vParameter.elementAt(n);
    }

    public Ref getRef(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public short getShort(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public String getString(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Time getTime(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw this.getNotSupported();
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw this.getNotSupported();
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        throw this.getNotSupported();
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw this.getNotSupported();
    }

    public void setArray(int n, Array array) throws SQLException {
        throw this.getNotSupported();
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n);
        } else {
            this.setString(n, StringConverter.InputStreamToString(inputStream));
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull(n);
        } else {
            this.setParameter(n, bigDecimal.toString());
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw Trace.error(32, iOException.getMessage());
        }
        this.setBytes(n, byArray);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw this.getNotSupported();
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setParameter(n, bl ? "TRUE" : "FALSE");
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setParameter(n, String.valueOf(by));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n);
        } else {
            this.setParameter(n, "'" + ByteArray.createString(byArray) + "'");
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw this.getNotSupported();
    }

    public void setDate(int n, Date date) throws SQLException {
        if (date == null) {
            this.setNull(n);
        } else {
            this.setParameter(n, "'" + date.toString() + "'");
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.setParameter(n, String.valueOf(d));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setParameter(n, String.valueOf(f));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setParameter(n, String.valueOf(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.setParameter(n, String.valueOf(l));
    }

    private void setNull(int n) {
        this.setParameter(n, "NULL");
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setNull(n);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.setNull(n);
            return;
        }
        int n2 = 1111;
        if (object instanceof String) {
            n2 = 12;
        } else if (object instanceof BigDecimal) {
            n2 = 2;
        } else if (object instanceof Integer) {
            n2 = 4;
        } else if (object instanceof Long) {
            n2 = -5;
        } else if (object instanceof Float) {
            n2 = 7;
        } else if (object instanceof Double) {
            n2 = 8;
        } else if (object instanceof byte[]) {
            n2 = -2;
        } else if (object instanceof Date) {
            n2 = 91;
        } else if (object instanceof Time) {
            n2 = 92;
        } else if (object instanceof Timestamp) {
            n2 = 93;
        } else if (object instanceof Boolean) {
            n2 = -7;
        } else if (object instanceof Byte) {
            n2 = -6;
        } else if (object instanceof Short) {
            n2 = 5;
        }
        this.setObjectInType(n, object, n2);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (object == null) {
            this.setNull(n);
            return;
        }
        object = Column.convertObject(object, n2);
        this.setObjectInType(n, object, n2);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n2);
    }

    private void setObjectInType(int n, Object object, int n2) throws SQLException {
        if (object == null) {
            this.setNull(n);
            return;
        }
        switch (n2) {
            case -7: {
                this.setBoolean(n, (boolean)((Boolean)object));
                break;
            }
            case -6: {
                this.setByte(n, (byte)((Byte)object));
                break;
            }
            case 5: {
                this.setShort(n, (short)((Short)object));
                break;
            }
            case 4: {
                this.setInt(n, (int)((Integer)object));
                break;
            }
            case -5: {
                this.setLong(n, (long)((Long)object));
                break;
            }
            case 7: {
                this.setFloat(n, ((Float)object).floatValue());
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(n, (double)((Double)object));
                break;
            }
            case 2: {
                this.setBigDecimal(n, (BigDecimal)object);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, (String)object);
                break;
            }
            case 91: {
                this.setDate(n, (Date)object);
                break;
            }
            case 92: {
                this.setTime(n, (Time)object);
                break;
            }
            case 93: {
                this.setTimestamp(n, (Timestamp)object);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(n, (byte[])object);
                break;
            }
            case 1111: {
                this.setParameter(n, "'" + ByteArray.serializeToString(object) + "'");
                break;
            }
            default: {
                this.setParameter(n, object.toString());
            }
        }
    }

    private void setParameter(int n, String string) {
        if (this.vParameter.size() < n) {
            this.vParameter.setSize(n);
        }
        this.vParameter.setElementAt(string, --n);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw this.getNotSupported();
    }

    public void setShort(int n, short s) throws SQLException {
        this.setParameter(n, String.valueOf(s));
    }

    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.setNull(n);
        } else {
            this.setParameter(n, Column.createString(string));
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        if (time == null) {
            this.setNull(n);
        } else {
            this.setParameter(n, "'" + time.toString() + "'");
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(n);
        } else {
            this.setParameter(n, "'" + timestamp.toString() + "'");
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(n, inputStream, n2);
    }

    public boolean wasNull() throws SQLException {
        throw this.getNotSupported();
    }
}

